/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.security.digest;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.security.digest.LispMessageDigest;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;

public class StringToHexifiedMessageDigest
extends BinaryArgs {
    @Override
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        String s = SubrUtils.getString(c1a, mesg);
        String al = SubrUtils.getSymbolName(c2a, mesg);
        try {
            MessageDigest md = MessageDigest.getInstance(al.toUpperCase());
            byte[] b = md.digest(s.getBytes());
            return new LispString(LispMessageDigest.hexify(b));
        }
        catch (NoSuchAlgorithmException e) {
            throw mesg.getError("err.digest.algorithm.notfound", c2a);
        }
    }
}

