/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.security.keypair;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.MultiValues;
import net.morilib.lisp.security.keypair.LispPrivateKey;
import net.morilib.lisp.security.keypair.LispPublicKey;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;

public class GenerateKeyPair
extends UnaryArgs {
    @Override
    protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
        String al = SubrUtils.getSymbolName(c1a, mesg);
        try {
            KeyPairGenerator kg = KeyPairGenerator.getInstance(al.toUpperCase());
            KeyPair pr = kg.generateKeyPair();
            return MultiValues.newValues(new LispPublicKey(pr.getPublic()), new LispPrivateKey(pr.getPrivate()));
        }
        catch (NoSuchAlgorithmException e) {
            throw mesg.getError("err.keypair.algorithm.notfound", c1a);
        }
    }
}

