/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.sound;

import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.sound.LispAudioFormat;
import net.morilib.lisp.sound.LispDataLine;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.lisp.uvector.HomogeneousFloatArray;
import net.morilib.util.Endianness2;

public class LispSourceDataLine
extends Datum2
implements LispDataLine {
    private SourceDataLine sourceLine;
    private AudioFormat audioFormat;

    private LispSourceDataLine(SourceDataLine source, AudioFormat format) {
        this.sourceLine = source;
        this.audioFormat = format;
    }

    @Override
    public void open() throws LineUnavailableException {
        this.sourceLine.open(this.audioFormat);
    }

    @Override
    public void start() {
        this.sourceLine.start();
    }

    @Override
    public void stop() {
        this.sourceLine.stop();
    }

    @Override
    public void flush() {
        this.sourceLine.flush();
    }

    @Override
    public void close() {
        this.sourceLine.close();
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<source-data-line>");
    }

    /* synthetic */ LispSourceDataLine(SourceDataLine sourceDataLine, AudioFormat audioFormat, LispSourceDataLine lispSourceDataLine) {
        this(sourceDataLine, audioFormat);
    }

    public static class MakeSourceDataLine
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof LispAudioFormat)) {
                throw mesg.getError("err.sound.require.audioformat", c1a);
            }
            try {
                LispAudioFormat f = (LispAudioFormat)c1a;
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, f.audioFormat);
                SourceDataLine t = (SourceDataLine)AudioSystem.getLine(info);
                return new LispSourceDataLine(t, f.audioFormat, null);
            }
            catch (LineUnavailableException e) {
                throw mesg.getError("err.sound.lineunavailable");
            }
        }
    }

    public static class WriteDataLineRelative
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            List<Datum> l = LispUtils.consToList(body, mesg);
            int size = -1;
            if (l.size() < 2) {
                throw mesg.getError("err.argument", body);
            }
            if (!(l.get(0) instanceof LispSourceDataLine)) {
                throw mesg.getError("err.sound.require.dataline.source", l.get(0));
            }
            LispSourceDataLine s = (LispSourceDataLine)l.get(0);
            HomogeneousFloatArray[] as = new HomogeneousFloatArray[l.size() - 1];
            int i = 1;
            while (i < l.size()) {
                if (!(l.get(i) instanceof HomogeneousFloatArray)) {
                    throw mesg.getError("err.uvector.require.float");
                }
                HomogeneousFloatArray a = (HomogeneousFloatArray)((Object)l.get(i));
                if (size >= 0 && size != a.size()) {
                    throw mesg.getError("err.sound.notsamevectors");
                }
                size = a.size();
                as[i - 1] = a;
                ++i;
            }
            AudioFormat af = s.audioFormat;
            int bts = af.getSampleSizeInBits() >> 3;
            int cnl = af.getChannels();
            byte[] buf = new byte[size * cnl * bts];
            Endianness2 end = af.isBigEndian() ? Endianness2.BIG : Endianness2.LITTLE;
            i = 0;
            while (i < size) {
                int j = 0;
                while (j < cnl) {
                    long ll;
                    double f = as[j].get(i).getRealDouble();
                    if (af.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
                        if (f < 0.0) {
                            f = 0.0;
                        } else if (f > 1.0) {
                            f = 1.0;
                        }
                        ll = (long)(f * (double)((1 << bts * 8) - 1));
                    } else {
                        if (f < -1.0) {
                            f = -1.0;
                        } else if (f > 1.0) {
                            f = 1.0;
                        }
                        ll = (long)(f * (double)((1 << bts * 8 - 1) - 1));
                    }
                    end.write(buf, (i * bts + j) * cnl, bts, ll);
                    ++j;
                }
                ++i;
            }
            s.sourceLine.write(buf, 0, buf.length);
            return LispInteger.valueOf(size);
        }
    }
}

