/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.subr;

import java.math.BigInteger;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.subr.UnaryArgs;

public class IsOdd
extends UnaryArgs {
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    @Override
    protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
        if (c1a instanceof LispNumber) {
            LispNumber n = (LispNumber)c1a;
            if (!n.isInteger()) {
                throw mesg.getError("err.require.int", n);
            }
            if (n instanceof LispReal) {
                BigInteger v = n.getBigInteger();
                return LispBoolean.getInstance(v.mod(TWO).equals(BigInteger.ONE));
            }
            throw mesg.getError("err.require.int", n);
        }
        throw mesg.getError("err.require.int", c1a);
    }
}

