/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.lisp.swing.LightweightGUIElement;
import net.morilib.lisp.swing.LispSwing;
import net.morilib.lisp.swing.Selectable;
import net.morilib.lisp.swing.listener.ActionListenable;
import net.morilib.lisp.swing.listener.ItemListenable;

public class LispComboBox
extends LightweightGUIElement
implements Selectable,
ActionListenable,
ItemListenable {
    private JComboBox combo;

    public LispComboBox(JComboBox combo) {
        this.combo = combo;
    }

    @Override
    public JComponent getComponent() {
        return this.combo;
    }

    @Override
    public Selectable.Item getCurrentItem() {
        return (Selectable.Item)this.combo.getSelectedItem();
    }

    @Override
    public Selectable.Item[] getItems() {
        Selectable.Item[] res = new Selectable.Item[this.combo.getItemCount()];
        int i = 0;
        while (i < res.length) {
            res[i] = (Selectable.Item)this.combo.getItemAt(i);
            ++i;
        }
        return res;
    }

    @Override
    public void setItems(Selectable.Item ... data) {
        this.combo.removeAllItems();
        int i = 0;
        while (i < data.length) {
            this.combo.addItem(data);
            ++i;
        }
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.combo.addActionListener(listener);
    }

    @Override
    public void addItemListener(ItemListener l) {
        this.combo.addItemListener(l);
    }

    @Override
    public Component getAWTComponent() {
        return this.getComponent();
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<combobox>");
    }

    public static class MakeComboBox
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            JComboBox<Selectable.Item> c = new JComboBox<Selectable.Item>(LispSwing.toItem(c1a));
            c.setEditable(true);
            return new LispComboBox(c);
        }
    }

    public static class MakeListBox
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            JComboBox<Selectable.Item> c = new JComboBox<Selectable.Item>(LispSwing.toItem(c1a));
            c.setEditable(false);
            return new LispComboBox(c);
        }
    }
}

