/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Undef;
import net.morilib.lisp.subr.QuaternaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.lisp.swing.GUIElement;
import net.morilib.lisp.swing.ILispComponent;
import net.morilib.lisp.swing.LispMenuBar;

public class LispPopupMenu
extends GUIElement
implements ILispComponent {
    private JPopupMenu menu;

    public LispPopupMenu(JPopupMenu menu) {
        this.menu = menu;
    }

    static JPopupMenu parseMenuBar(Datum d, Environment env, LispMessage mesg) {
        JPopupMenu mb = new JPopupMenu();
        ConsIterator itr = new ConsIterator(d);
        while (itr.hasNext()) {
            mb.add(LispMenuBar.parseMenu(itr.next(), env, mesg));
        }
        if (!itr.getTerminal().isNil()) {
            throw mesg.getError("err.list", d);
        }
        return mb;
    }

    @Override
    public JComponent getComponent() {
        return this.menu;
    }

    @Override
    public Component getAWTComponent() {
        return this.menu;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<popup-menu>");
    }

    public static class HidePopupMenu
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispPopupMenu) {
                ((LispPopupMenu)c1a).menu.setVisible(false);
                return Undef.UNDEF;
            }
            throw mesg.getError("err.swing.require.popupmenu", c1a);
        }
    }

    public static class MakePopupMenu
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof Cons) {
                return new LispPopupMenu(LispPopupMenu.parseMenuBar(c1a, env, mesg));
            }
            throw mesg.getError("err.require.list", c1a);
        }
    }

    public static class ShowPopupMenu
    extends QuaternaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Datum c4a, Environment env, LispMessage mesg) {
            JComponent c;
            int x = SubrUtils.getSmallInt(c3a, mesg);
            int y = SubrUtils.getSmallInt(c4a, mesg);
            if (!c2a.isTrue()) {
                c = null;
            } else if (c2a instanceof ILispComponent) {
                c = ((ILispComponent)((Object)c2a)).getComponent();
            } else {
                throw mesg.getError("err.swing.require.component", c2a);
            }
            if (c1a instanceof LispPopupMenu) {
                ((LispPopupMenu)c1a).menu.show(c, x, y);
                return Undef.UNDEF;
            }
            throw mesg.getError("err.swing.require.popupmenu", c1a);
        }
    }
}

