/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JTextArea;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.swing.HasText;
import net.morilib.lisp.swing.ILispLoadableComponent;
import net.morilib.lisp.swing.ILispPrintableComponent;
import net.morilib.lisp.swing.ILispSavableComponent;
import net.morilib.lisp.swing.LightweightGUIElement;
import net.morilib.util.IOs;

public class LispTextArea
extends LightweightGUIElement
implements ILispPrintableComponent,
ILispSavableComponent,
ILispLoadableComponent,
HasText {
    private JTextArea area;

    public LispTextArea(JTextArea a) {
        this.area = a;
    }

    @Override
    public JTextArea getComponent() {
        return this.area;
    }

    @Override
    public String getText() {
        return this.area.getText();
    }

    @Override
    public void setText(String s) {
        this.area.setText(s);
    }

    @Override
    public Component getAWTComponent() {
        return this.getComponent();
    }

    @Override
    public void load(File f, String enc) throws IOException {
        this.area.setText(IOs.toString(f, enc));
    }

    @Override
    public void save(File f, String enc) throws IOException {
        IOs.fromString(f, this.area.getText(), enc);
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<text-area>");
    }

    public static class MakeTextArea
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            JTextArea f;
            List<Datum> l = LispUtils.consToList(body, mesg);
            if (l.size() == 0) {
                f = new JTextArea();
            } else if (l.size() == 2) {
                int row = SubrUtils.getSmallInt(l.get(0), mesg);
                int col = SubrUtils.getSmallInt(l.get(1), mesg);
                f = new JTextArea(row, col);
            } else {
                throw mesg.getError("err.argument", body);
            }
            return new LispTextArea(f);
        }
    }
}

