/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing.tree;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Nil;
import net.morilib.lisp.swing.tree.LispJTree;
import net.morilib.lisp.swing.tree.LispJTreeNode;
import net.morilib.lisp.swing.tree.MyMutableTreeNode;
import net.morilib.util.ArrayListStack;

public final class LispJTreeUtils {
    private LispJTreeUtils() {
    }

    static void setRoot(Datum c1a, MyMutableTreeNode o, LispMessage mesg) {
        JTree t = ((LispJTree)c1a).tree;
        ((DefaultTreeModel)t.getModel()).setRoot(o);
    }

    static void addNode(Datum c1a, Datum c2a, MyMutableTreeNode o, LispMessage mesg) {
        JTree t = ((LispJTree)c1a).tree;
        MyMutableTreeNode n = ((LispJTreeNode)c2a).node;
        ((DefaultTreeModel)t.getModel()).insertNodeInto(o, n, n.getChildCount());
    }

    static void insertNode(Datum c1a, Datum c2a, int i, MyMutableTreeNode o, LispMessage mesg) {
        JTree t = ((LispJTree)c1a).tree;
        MyMutableTreeNode n = ((LispJTreeNode)c2a).node;
        try {
            ((DefaultTreeModel)t.getModel()).insertNodeInto(o, n, i);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw mesg.getError("err.swing.jtree.outofrange", Integer.toString(i));
        }
    }

    static Datum pathToS(TreePath p, Datum cdr) {
        ConsListBuilder b = new ConsListBuilder();
        if (p == null) {
            return LispBoolean.FALSE;
        }
        Object[] objectArray = p.getPath();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            b.append(new LispJTreeNode((MyMutableTreeNode)o));
            ++n2;
        }
        return b.get(cdr);
    }

    static Datum pathToS(TreePath p) {
        return LispJTreeUtils.pathToS(p, Nil.NIL);
    }

    public static MyMutableTreeNode sToNode(Datum root) {
        ArrayListStack<MyMutableTreeNode> stn = new ArrayListStack<MyMutableTreeNode>();
        ArrayListStack<Datum> stk = new ArrayListStack<Datum>();
        MyMutableTreeNode s = null;
        MyMutableTreeNode r = null;
        stk.push(root);
        while (!stk.isEmpty()) {
            MyMutableTreeNode t;
            Datum d = (Datum)stk.pop();
            if (d == null) {
                s = (MyMutableTreeNode)stn.pop();
                continue;
            }
            if (d instanceof Cons) {
                ConsIterator itr = new ConsIterator(d);
                if (!itr.hasNext()) continue;
                t = new MyMutableTreeNode(itr.next());
                if (s == null) {
                    r = t;
                    stn.push(r);
                } else {
                    s.insert(t, 0);
                    stn.push(s);
                }
                s = t;
                stk.push(null);
                while (itr.hasNext()) {
                    stk.push(itr.next());
                }
                continue;
            }
            t = new MyMutableTreeNode(d);
            s.insert(t, 0);
        }
        return r;
    }

    public static Datum nodeToS(DefaultMutableTreeNode root) {
        ArrayListStack<DefaultMutableTreeNode> stk = new ArrayListStack<DefaultMutableTreeNode>();
        ArrayListStack<ConsListBuilder> stb = new ArrayListStack<ConsListBuilder>();
        ArrayListStack<Integer> stp = new ArrayListStack<Integer>();
        DefaultMutableTreeNode n = null;
        ConsListBuilder b = null;
        int i = -1;
        if (root.isLeaf()) {
            return (Datum)root.getUserObject();
        }
        stk.push(root);
        while (true) {
            if (n == null) {
                n = (DefaultMutableTreeNode)stk.pop();
                b = new ConsListBuilder();
                continue;
            }
            if (i >= n.getChildCount()) {
                if (stk.isEmpty()) break;
                ConsListBuilder c = b;
                n = (DefaultMutableTreeNode)stk.pop();
                b = (ConsListBuilder)stb.pop();
                i = (Integer)stp.pop() + 1;
                b.append(c.get());
                continue;
            }
            if (i < 0) {
                b.append((Datum)n.getUserObject());
                i = 0;
                continue;
            }
            DefaultMutableTreeNode m = (DefaultMutableTreeNode)n.getChildAt(i);
            if (m.isLeaf()) {
                b.append((Datum)m.getUserObject());
                ++i;
                continue;
            }
            stk.push(n);
            stb.push(b);
            stp.push(i);
            n = m;
            b = new ConsListBuilder();
            i = -1;
        }
        return b.get();
    }
}

