/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.text;

import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.Keyword;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.text.LispHtmlElement;

public class HtmlElement
extends Subr {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        if (!this.symbolName.startsWith("html:")) {
            return Nil.NIL;
        }
        LispHtmlElement elm = new LispHtmlElement();
        elm.name = this.symbolName.replaceFirst("html:", "");
        while (itr.hasNext()) {
            Datum d = itr.next();
            if (d instanceof Keyword) {
                if (itr.hasNext()) {
                    elm.attrs.put(((Keyword)d).getName(), LispUtils.print(itr.next()));
                    continue;
                }
                elm.content = Nil.NIL;
                continue;
            }
            if (itr.hasNext()) {
                elm.content = new Cons(d, itr.rest());
                continue;
            }
            elm.content = d;
            break;
        }
        SubrUtils.checkTerminated(itr, body, mesg);
        return elm;
    }
}

