/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.text;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.OutputPort;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Undef;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.text.LispHtmlElement;
import net.morilib.util.ArrayListStack;
import net.morilib.util.Iterators;
import net.morilib.util.Strings;

public class WriteTree
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        PrintStream wr;
        ConsIterator itr = new ConsIterator(body);
        Datum tr = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum p0 = Iterators.nextIf(itr);
        ArrayListStack<Datum> stk = new ArrayListStack<Datum>();
        if (p0 instanceof OutputPort) {
            wr = ((OutputPort)p0).getPrintStream();
        } else if (p0 == null) {
            wr = System.out;
        } else {
            throw mesg.getError("err.require.oport", p0);
        }
        stk.push(tr);
        while (!stk.isEmpty()) {
            Datum d = (Datum)stk.pop();
            if (d instanceof Cons) {
                stk.push(((Cons)d).getCdr());
                stk.push(((Cons)d).getCar());
                continue;
            }
            if (d instanceof LispHtmlElement) {
                LispHtmlElement h = (LispHtmlElement)d;
                wr.print("<");
                wr.print(h.name);
                for (Map.Entry<String, String> e : h.attrs.entrySet()) {
                    String s = e.getValue();
                    wr.print(" ");
                    wr.print(e.getKey());
                    s = s.replaceAll("\"", "&quot;");
                    wr.print("=\"");
                    wr.print(s);
                    wr.print("\"");
                }
                wr.print(">");
                stk.push(new LispString("</" + h.name + "\n>"));
                if (h.content instanceof LispHtmlElement) {
                    stk.push(h.content);
                    continue;
                }
                stk.push(new LispString(Strings.escapeHtml(LispUtils.print(h.content))));
                continue;
            }
            if (d.isNil()) continue;
            wr.print(LispUtils.print(d));
        }
        wr.println();
        return Undef.UNDEF;
    }
}

