/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.topology;

import net.morilib.lisp.Datum;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.topology.AbstractLispTopology;
import net.morilib.lisp.topology.ILispOrderedSet;
import net.morilib.lisp.topology.ILispTopology;
import net.morilib.lisp.topology.LispCardinality;
import net.morilib.lisp.topology.LispNumberClassTopology;
import net.morilib.range.Interval;
import net.morilib.range.Range;

public class LispRealNumberSet
extends AbstractLispTopology
implements ILispOrderedSet {
    public static LispRealNumberSet O = new LispRealNumberSet(Range.O);
    public static LispRealNumberSet U = new LispRealNumberSet(Range.U);
    private Range set;

    public LispRealNumberSet(Range set) {
        this.set = set;
    }

    @Override
    public boolean isNeighborhoodOf(Datum d) {
        return this.set.contains(d);
    }

    @Override
    public boolean isContained(ILispTopology t) {
        if (t instanceof LispRealNumberSet) {
            return this.set.in(((LispRealNumberSet)t).set);
        }
        if (t instanceof LispNumberClassTopology) {
            if (LispNumberClassTopology.R.isContained(t)) {
                return true;
            }
            if (this.set.isFinite()) {
                for (Object o : this.set.getJavaSetIfFinite()) {
                    if (t.isNeighborhoodOf((Datum)o)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return super.isContained(t);
    }

    @Override
    public boolean isIndependent(ILispTopology t) {
        if (t instanceof LispRealNumberSet) {
            return this.set.independentOf(((LispRealNumberSet)t).set);
        }
        if (t instanceof LispNumberClassTopology) {
            return LispNumberClassTopology.contained((LispNumberClassTopology)t, this);
        }
        return super.isIndependent(t);
    }

    @Override
    public ILispTopology unionTopology(ILispTopology t) {
        if (t instanceof LispRealNumberSet) {
            return new LispRealNumberSet(this.set.join(((LispRealNumberSet)t).set));
        }
        return super.unionTopology(t);
    }

    @Override
    public ILispTopology intersectionTopology(ILispTopology t) {
        if (t instanceof LispRealNumberSet) {
            return new LispRealNumberSet(this.set.meet(((LispRealNumberSet)t).set));
        }
        return super.intersectionTopology(t);
    }

    @Override
    public ILispTopology interior() {
        return new LispRealNumberSet(this.set.interior());
    }

    @Override
    public ILispTopology closure() {
        return new LispRealNumberSet(this.set.closure());
    }

    @Override
    public boolean isOpen() {
        return this.set.isOpen();
    }

    @Override
    public boolean isClosed() {
        return this.set.isClosed();
    }

    @Override
    public LispCardinality cardinality() {
        if (this.set.isEmpty()) {
            return LispCardinality.ZERO;
        }
        if (this.set.isFinite()) {
            return LispCardinality.finiteValueOf(this.set.getJavaSetIfFinite().size());
        }
        return LispCardinality.C;
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean isUniverse() {
        return false;
    }

    public Range getRange() {
        return this.set;
    }

    @Override
    public Datum maximum() {
        if (this.set.isEmpty()) {
            return null;
        }
        Interval i = this.set.intervals().last();
        if (!i.isSupremumFinite()) {
            return null;
        }
        if (i.isSupremumClosed()) {
            return (Datum)i.getSupremumBound();
        }
        return null;
    }

    @Override
    public Datum minimum() {
        if (this.set.isEmpty()) {
            return null;
        }
        Interval i = this.set.intervals().first();
        if (!i.isInfimumFinite()) {
            return null;
        }
        if (i.isInfimumClosed()) {
            return (Datum)i.getInfimumBound();
        }
        return null;
    }

    @Override
    public Datum supremum() {
        if (this.set.isEmpty()) {
            return null;
        }
        Interval i = this.set.intervals().last();
        if (!i.isSupremumFinite()) {
            return LispDouble.POSITIVE_INFINITY;
        }
        return (Datum)i.getSupremumBound();
    }

    @Override
    public Datum infimum() {
        if (this.set.isEmpty()) {
            return null;
        }
        Interval i = this.set.intervals().first();
        if (!i.isInfimumFinite()) {
            return LispDouble.NEGATIVE_INFINITY;
        }
        return (Datum)i.getInfimumBound();
    }

    public int hashCode() {
        return this.set.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof LispRealNumberSet) {
            return this.set.equals(((LispRealNumberSet)o).set);
        }
        return false;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<real number set ").append(this.set.toString()).append(">");
    }
}

