/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.unicode;

import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.SubrUtils;

public class DigitToInteger
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        int ch = SubrUtils.nextCharacter(itr, mesg, body);
        int rd = SubrUtils.nextSmallInt((Iterator<Datum>)itr, 10, mesg);
        SubrUtils.checkTerminated(itr, body, mesg);
        if (rd <= 0) {
            throw mesg.getError("err.radix.invalid", String.valueOf(rd));
        }
        if (rd <= 10) {
            if (ch >= 48 && ch < 48 + rd) {
                return LispInteger.valueOf(ch - 48);
            }
            return LispBoolean.FALSE;
        }
        if (rd <= 36) {
            if (ch >= 48 && ch < 48 + rd) {
                return LispInteger.valueOf(ch - 48);
            }
            if (ch >= 65 && ch < 65 + rd) {
                return LispInteger.valueOf(ch - 65 + 10);
            }
            if (ch >= 97 && ch < 97 + rd) {
                return LispInteger.valueOf(ch - 97 + 10);
            }
            return LispBoolean.FALSE;
        }
        throw mesg.getError("err.radix.invalid", String.valueOf(rd));
    }
}

