/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math;

import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.morilib.math.special.GammaFunctions;

public final class Math2 {
    private static final int BASE = 16;
    private static final int LOG2BASE = 4;
    private static final BigInteger LIMIT_NRT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static WeakReference<short[]> shortPrimes = null;
    private static Map<Integer, BigInteger> facmemo = new WeakHashMap<Integer, BigInteger>();
    private static Map<Long, BigInteger> cmbmemo = new WeakHashMap<Long, BigInteger>();
    public static final double EULER_CONSTANT = 0.5772156649015329;
    public static final double GOLDEN_RATIO = 1.618033988749895;
    public static final int HARDY_RAMANUJAN_NUMBER = 1729;

    private Math2() {
    }

    public static final int minus1ToThe(int n) {
        return (n & 1) == 0 ? 1 : -1;
    }

    public static double decimalPart(double x) {
        double r = Math.IEEEremainder(x, 1.0);
        return r < 0.0 ? 1.0 + r : r;
    }

    public static boolean isInteger(double x) {
        return Math2.decimalPart(x) == 0.0;
    }

    private static int toInt(byte b) {
        return b < 0 ? (b & 0x7F) + 128 : b;
    }

    public static BigInteger[] sqrtExact2(BigInteger q) {
        int i = 0;
        BigInteger s = BigInteger.ZERO;
        BigInteger t = BigInteger.ZERO;
        BigInteger r = BigInteger.ZERO;
        if (q.signum() == 0) {
            return new BigInteger[]{BigInteger.ZERO, BigInteger.ZERO};
        }
        if (q.signum() < 0) {
            throw new IllegalArgumentException();
        }
        byte[] a = q.toByteArray();
        while (a[i] == 0) {
        }
        while (i < a.length) {
            int x = 0;
            if (s.signum() == 0) {
                t = BigInteger.valueOf(Math2.toInt(a[i]));
                while (x * x <= t.intValue()) {
                    ++x;
                }
                s = BigInteger.valueOf(--x);
            } else {
                BigInteger s0 = s;
                t = t.shiftLeft(8).add(BigInteger.valueOf(Math2.toInt(a[i])));
                while ((s = s0.shiftLeft(4).add(BigInteger.valueOf(x))).multiply(BigInteger.valueOf(x++)).compareTo(t) <= 0) {
                }
                s = s0.shiftLeft(4).add(BigInteger.valueOf(x -= 2));
            }
            t = t.subtract(s.multiply(BigInteger.valueOf(x)));
            s = s.add(BigInteger.valueOf(x));
            r = r.shiftLeft(4).add(BigInteger.valueOf(x));
            ++i;
        }
        return new BigInteger[]{r, t};
    }

    public static BigInteger sqrtExact(BigInteger q) {
        BigInteger[] r2 = Math2.sqrtExact2(q);
        return r2[1].signum() == 0 ? r2[0] : r2[0].negate();
    }

    private static BigInteger[] split(BigInteger b, int n) {
        BigInteger x;
        byte[] c = b.toByteArray();
        int l = 0;
        while (c[l] == 0) {
            ++l;
        }
        byte[] d = new byte[(c.length - l) * 2];
        int k = l;
        while (k < c.length) {
            d[(k - l) * 2] = (byte)(Math2.toInt(c[k]) >> 4);
            d[(k - l) * 2 + 1] = (byte)(Math2.toInt(c[k]) & 0xF);
            ++k;
        }
        BigInteger[] r = new BigInteger[(d.length + n - 1) / n];
        int i = d.length % n;
        if (i > 0) {
            x = BigInteger.ZERO;
            k = 0;
            while (k < i) {
                x = x.shiftLeft(4).add(BigInteger.valueOf(Math2.toInt(d[k])));
                ++k;
            }
            r[0] = x;
        }
        while (i < d.length) {
            x = BigInteger.ZERO;
            k = 0;
            while (k < n) {
                x = x.shiftLeft(4).add(BigInteger.valueOf(Math2.toInt(d[i + k])));
                ++k;
            }
            r[(i + n - 1) / n] = x;
            i += n;
        }
        return r;
    }

    public static BigInteger nrtExact(BigInteger q, int n) {
        BigInteger r = BigInteger.ZERO;
        BigInteger t = BigInteger.ZERO;
        int i = 0;
        if (q.signum() == 0) {
            return BigInteger.ZERO;
        }
        if (q.signum() < 0) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        BigInteger[] a = Math2.split(q, n);
        while (i < a.length) {
            int b = 0;
            t = t.shiftLeft(4 * n).add(a[i]);
            r = r.shiftLeft(4);
            while (b < 16) {
                BigInteger x = r.add(BigInteger.valueOf(b)).pow(n);
                if (x.compareTo(t) > 0) break;
                ++b;
            }
            r = r.add(BigInteger.valueOf(b - 1));
            ++i;
        }
        return t.subtract(q).signum() == 0 ? r : r.negate();
    }

    public static BigInteger nrtExact(BigInteger q, BigInteger n) {
        if (n.signum() < 0 || n.compareTo(LIMIT_NRT) > 0) {
            throw new IllegalArgumentException();
        }
        return Math2.nrtExact(q, n.intValue());
    }

    public static BigInteger integerLog(BigInteger x, BigInteger b) {
        BigInteger s;
        BigInteger r = BigInteger.valueOf(-1L);
        BigInteger y = x;
        if (x.signum() <= 0) {
            throw new IllegalArgumentException();
        }
        do {
            y = y.divide(b);
            s = y.remainder(b);
            r = r.add(BigInteger.ONE);
        } while (y.signum() > 0);
        return s.signum() == 0 ? r : r.negate();
    }

    /*
     * Unable to fully structure code
     */
    public static BigInteger pow(BigInteger b1, BigInteger b2) {
        a = b2.toByteArray();
        i = 0;
        r = BigInteger.ONE;
        if (b2.signum() < 0) {
            throw new IllegalArgumentException();
        }
        if (b2.signum() == 0) {
            return BigInteger.ONE;
        }
        if (b1.signum() == 0) {
            return BigInteger.ZERO;
        }
        if (b1.equals(BigInteger.ONE)) {
            return BigInteger.ONE;
        }
        if (!b1.equals(BigInteger.valueOf(-1L))) ** GOTO lbl16
        p = b2.remainder(BigInteger.valueOf(2L)).intValue();
        return BigInteger.valueOf(p == 0 ? 1 : -1);
lbl-1000:
        // 1 sources

        {
            ++i;
lbl16:
            // 2 sources

            ** while (a[i] == 0)
        }
lbl17:
        // 2 sources

        while (i < a.length) {
            r = r.pow(256);
            r = r.multiply(b1.pow(Math2.toInt(a[i])));
            ++i;
        }
        return r;
    }

    public static int gcd(int a, int b) {
        int r = Math.abs(a);
        int t = Math.abs(b);
        if (a == 0 && b == 0) {
            return 0;
        }
        int c = r;
        while (t > 0) {
            r = t;
            t = c % t;
        }
        return r;
    }

    public static long gcd(long a, long b) {
        long r = Math.abs(a);
        long t = Math.abs(b);
        if (a == 0L && b == 0L) {
            return 0L;
        }
        long c = r;
        while (t > 0L) {
            r = t;
            t = c % t;
        }
        return r;
    }

    public static int lcm(short a, short b) {
        return a == 0 || b == 0 ? 0 : a * b / Math2.gcd(a, b);
    }

    public static long lcm(int a, int b) {
        long r = a;
        long t = b;
        return r == 0L || t == 0L ? 0L : r * t / Math2.gcd(r, t);
    }

    private static boolean mult(byte[] r, byte[] b, int v, int s, int radix) {
        int carry = 0;
        int i = r.length - 1;
        while (i >= 0) {
            int k = i - (r.length - b.length) + s;
            int x = (k >= 0 && k < b.length ? Math2.toInt(b[k]) : 0) * v + carry;
            carry = x / radix;
            r[i] = (byte)(x % radix);
            --i;
        }
        return carry == 0;
    }

    private static boolean sub0(byte[] r, byte[] b, byte[] c, int radix) {
        int carry = 0;
        int i = b.length - 1;
        while (i >= 0) {
            int x = Math2.toInt(b[i]) - Math2.toInt(c[i]) + carry;
            carry = x > 0 ? x / radix : (x - radix + 1) / radix;
            r[i] = (byte)(x >= 0 ? x % radix : (x + radix) % radix);
            --i;
        }
        return carry == 0;
    }

    private static byte[] split2(BigInteger a, int radix) {
        StringBuilder b = new StringBuilder();
        while (a.signum() > 0) {
            BigInteger[] c = a.divideAndRemainder(BigInteger.valueOf(radix));
            b.append((char)(c[1].byteValue() + 48));
            a = c[0];
        }
        byte[] r = new byte[b.length()];
        int i = 0;
        while (i < b.length()) {
            r[i] = (byte)(b.charAt(b.length() - i - 1) - 48);
            ++i;
        }
        return r;
    }

    private static byte[] ext(byte[] a, int ext) {
        byte[] r = new byte[ext + 1];
        Arrays.fill(r, (byte)0);
        System.arraycopy(a, 0, r, ext - a.length, a.length);
        return r;
    }

    private static String _toDecimalString(BigInteger a, BigInteger b, int radix) {
        StringBuilder buf = new StringBuilder();
        StringBuilder sho0 = new StringBuilder();
        byte[] hou0 = Math2.split2(b, radix);
        byte[] jit0 = Math2.ext(Math2.split2(a, radix), hou0.length);
        byte[] zero = new byte[jit0.length];
        byte[] tmp0 = new byte[jit0.length];
        byte[] tmp1 = new byte[jit0.length];
        LinkedHashSet<T1> mem = new LinkedHashSet<T1>();
        int j0 = 0;
        int sez = 0;
        Arrays.fill(zero, (byte)0);
        int h0 = Math2.toInt(hou0[0]);
        h0 = hou0.length > 1 ? h0 * radix + Math2.toInt(hou0[1]) : (h0 *= radix);
        block0: while (true) {
            j0 = Math2.toInt(jit0[0]) + 1;
            j0 = j0 * radix + (jit0.length > 1 ? Math2.toInt(jit0[1]) : 0);
            int j = (j0 *= radix) / h0;
            while (!Math2.mult(tmp0, hou0, j, 0, radix) || !Math2.sub0(tmp1, jit0, tmp0, radix)) {
                --j;
            }
            sho0.append((char)(j < 10 ? j + 48 : j + 65 - 10));
            System.arraycopy(tmp1, 1, jit0, 0, tmp1.length - 1);
            jit0[tmp1.length - 1] = 0;
            if (Arrays.equals(jit0, zero)) {
                sez = -1;
                break;
            }
            T1 m0 = new T1(jit0);
            if (mem.contains(m0)) {
                Iterator itr = mem.iterator();
                sez = 0;
                while (true) {
                    if (sez >= mem.size()) continue block0;
                    if (((T1)itr.next()).equals(m0)) break block0;
                    ++sez;
                }
            }
            mem.add(m0);
        }
        if (sez < 0) {
            buf = sho0;
        } else {
            buf.append(sho0.substring(0, sez));
            buf.append("{");
            buf.append(sho0.substring(sez, sho0.length() - 1));
            buf.append("}");
        }
        return buf.toString();
    }

    public static String toDecimalString(BigInteger a, BigInteger b, int radix) {
        BigInteger[] rr = a.divideAndRemainder(b);
        if (radix < 2 || radix > 36) {
            throw new IllegalArgumentException();
        }
        if (rr[1].signum() == 0) {
            return rr[0].toString();
        }
        return rr[0] + "." + Math2._toDecimalString(rr[1].abs(), b, radix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void genShortPrimes() {
        if (shortPrimes != null && shortPrimes.get() != null) return;
        Class<Math2> clazz = Math2.class;
        synchronized (Math2.class) {
            LinkedHashSet<Integer> primes = new LinkedHashSet<Integer>();
            primes.add(2);
            int i = 3;
            while (i < 65536) {
                block7: {
                    for (Integer p : primes) {
                        if (i % p != 0) {
                            continue;
                        }
                        break block7;
                    }
                    primes.add(i);
                }
                i += 2;
            }
            short[] a = new short[primes.size()];
            int c = 0;
            for (Integer i2 : primes) {
                a[c++] = i2.shortValue();
            }
            shortPrimes = new WeakReference<short[]>(a);
            // ** MonitorExit[var3] (shouldn't be in output)
            return;
        }
    }

    public static List<Integer> getShortPrimes() {
        Math2.genShortPrimes();
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return ((short[])shortPrimes.get())[index] & 0xFFFF;
            }

            @Override
            public int size() {
                return ((short[])shortPrimes.get()).length;
            }
        };
    }

    public static int[] factorize(int x) {
        int[] r = new int[33];
        int a = x;
        int j = 0;
        Math2.genShortPrimes();
        if (x < 0) {
            r[j++] = -1;
            x = -x;
        } else if (x == 0) {
            return new int[1];
        }
        int i = 0;
        while (a != 0 && i < ((short[])shortPrimes.get()).length) {
            int p = ((short[])shortPrimes.get())[i] & 0xFFFF;
            while (a % p == 0) {
                r[j++] = p;
                a /= p;
            }
            ++i;
        }
        int[] s = new int[j];
        System.arraycopy(r, 0, s, 0, j);
        return s;
    }

    public static BigInteger factorial(int n) {
        if (n < 0) {
            return null;
        }
        if (n == 0 || n == 1) {
            return BigInteger.ONE;
        }
        if (n == 2) {
            return BigInteger.valueOf(n);
        }
        BigInteger r = facmemo.get(n);
        if (r == null) {
            r = BigInteger.ONE;
            int i = 2;
            while (i <= n) {
                r = r.multiply(BigInteger.valueOf(i));
                ++i;
            }
            facmemo.put(n, r);
        }
        return r;
    }

    public static double approximateFactorial(int n) {
        if (n < 0) {
            return Double.NaN;
        }
        if (n < 11) {
            return Math2.factorial(n).doubleValue();
        }
        return Math.sqrt(Math.PI * 2 * (double)n) * Math.pow((double)n / Math.E, n);
    }

    public static double lnApproximateFactorial(int n) {
        if (n < 0) {
            return Double.NaN;
        }
        if (n < 30) {
            return Math.log(Math2.factorial(n).doubleValue());
        }
        return (double)n * (Math.log(n) - 1.0);
    }

    public static BigInteger binomialCoefficient(int n, int k) {
        if (n < 0 || k < 0 || n < k) {
            return null;
        }
        if (k == 0 || k == n) {
            return BigInteger.ONE;
        }
        if (k == 1 || k == n - 1) {
            return BigInteger.valueOf(n);
        }
        long x = (long)n << 32 | (long)k;
        BigInteger r = facmemo.get(x);
        if (r == null) {
            r = BigInteger.ONE;
            int i = Math.max(k, n - k) + 1;
            while (i <= n) {
                r = r.multiply(BigInteger.valueOf(i));
                ++i;
            }
            cmbmemo.put(x, r);
        }
        return r;
    }

    public static double binomialCoefficient(double a, int k) {
        return GammaFunctions.gamma(a + 1.0) / GammaFunctions.gamma(k + 1) / GammaFunctions.gamma(a - (double)k + 1.0);
    }

    /*
     * Exception decompiling
     */
    public static int permutationParity(int[] perm) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static BigInteger[] toContinuedFraction(BigInteger numer, BigInteger denom) {
        ArrayList<BigInteger> l = new ArrayList<BigInteger>();
        BigInteger n = numer;
        BigInteger d = denom;
        while (d.signum() != 0) {
            BigInteger[] x = n.divideAndRemainder(d);
            l.add(x[0]);
            n = d;
            d = x[1];
        }
        return l.toArray(new BigInteger[0]);
    }

    private static class T1 {
        private byte[] arr;

        private T1(byte[] arr) {
            this.arr = new byte[arr.length];
            System.arraycopy(arr, 0, this.arr, 0, arr.length);
        }

        public int hashCode() {
            return Arrays.hashCode(this.arr);
        }

        public boolean equals(Object o) {
            return o instanceof T1 && Arrays.equals(this.arr, ((T1)o).arr);
        }
    }
}

