/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;

public final class Math3 {
    private static final int BASE = 10;
    private static final BigInteger BBASE = BigInteger.TEN;
    private static final BigInteger BBASE2 = BigInteger.valueOf(100L);

    private Math3() {
    }

    private static int toInt(byte b) {
        return b < 0 ? (b & 0x7F) + 128 : b;
    }

    private static BigInteger[] split(BigInteger a, int n) {
        ArrayList<BigInteger> b = new ArrayList<BigInteger>();
        BigInteger nbase = BBASE.pow(n);
        while (a.signum() > 0) {
            BigInteger[] c = a.divideAndRemainder(nbase);
            b.add(c[1]);
            a = c[0];
        }
        BigInteger[] r = new BigInteger[b.size()];
        int i = 0;
        while (i < b.size()) {
            r[i] = (BigInteger)b.get(b.size() - i - 1);
            ++i;
        }
        return r;
    }

    static BigInteger nrt(BigInteger q, int n) {
        BigInteger r = BigInteger.ZERO;
        BigInteger t = BigInteger.ZERO;
        BigInteger nbase = BBASE.pow(n);
        int i = 0;
        BigInteger[] a = Math3.split(q, n);
        while (i < a.length) {
            int b = 0;
            t = t.multiply(nbase).add(a[i]);
            while (b < 10) {
                BigInteger x = r.add(BigInteger.valueOf(b)).pow(n);
                if (x.compareTo(t) > 0) break;
                ++b;
            }
            r = r.add(BigInteger.valueOf(b - 1)).multiply(BBASE);
            ++i;
        }
        return r.divide(BBASE);
    }

    public static BigDecimal nrtDecimal(BigInteger q, int n, int digits) {
        BigInteger q1 = q.multiply(BBASE.pow(n * digits));
        BigInteger q2 = Math3.nrt(q1, n);
        return new BigDecimal(q2, digits);
    }

    public static BigDecimal sqrtDecimal(BigDecimal q, int n, int digits) {
        BigDecimal q1 = q.multiply(new BigDecimal(BBASE.pow(2 * digits)));
        BigInteger q2 = Math3.nrt(q1.toBigInteger(), n);
        return new BigDecimal(q2, digits);
    }

    private static byte[] toDecimal(BigInteger b) {
        BigInteger y;
        byte[] t = new byte[b.toString().length()];
        BigInteger x = b;
        int i = 0;
        while ((y = x.divide(BBASE2)).signum() > 0) {
            t[i++] = x.mod(BBASE2).byteValue();
            x = y;
        }
        t[i++] = x.byteValue();
        byte[] r = new byte[i];
        int j = 0;
        while (j < i) {
            r[i - j - 1] = t[j];
            ++j;
        }
        return r;
    }

    static BigInteger sqrt(BigInteger q) {
        BigInteger r;
        int i = 0;
        int x = 0;
        BigInteger s = r = BigInteger.ZERO;
        BigInteger t = r;
        byte[] a = Math3.toDecimal(q);
        while (a[i] == 0) {
            ++i;
        }
        while (i < a.length) {
            x = 0;
            if (s.signum() == 0) {
                t = BigInteger.valueOf(Math3.toInt(a[i]));
                x = 0;
                while (x < 10) {
                    if (x * x > t.intValue()) break;
                    ++x;
                }
                s = BigInteger.valueOf(--x);
            } else {
                BigInteger v = s;
                t = t.multiply(BBASE2).add(BigInteger.valueOf(Math3.toInt(a[i])));
                while ((s = v.multiply(BBASE).add(BigInteger.valueOf(x))).multiply(BigInteger.valueOf(x++)).compareTo(t) <= 0) {
                }
                s = v.multiply(BBASE).add(BigInteger.valueOf(x -= 2));
            }
            t = t.subtract(s.multiply(BigInteger.valueOf(x)));
            s = s.add(BigInteger.valueOf(x));
            r = r.multiply(BBASE).add(BigInteger.valueOf(x));
            ++i;
        }
        return r;
    }

    public static BigDecimal sqrtDecimal(BigInteger q, int digits) {
        BigInteger q1 = q.multiply(BBASE.pow(2 * digits));
        BigInteger q2 = Math3.sqrt(q1);
        return new BigDecimal(q2, digits);
    }

    public static BigDecimal sqrtDecimal(BigDecimal q, int digits) {
        BigDecimal q1 = q.multiply(new BigDecimal(BBASE.pow(2 * digits)));
        BigInteger q2 = Math3.sqrt(q1.toBigInteger());
        return new BigDecimal(q2, digits);
    }
}

