/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.order;

import java.util.Collections;
import java.util.Set;
import net.morilib.math.order.LogarithmicOrder;
import net.morilib.math.order.OrderElement;
import net.morilib.util.IntMath;

class PolynomialOrder
extends OrderElement {
    int order;

    PolynomialOrder(int order) {
        this.order = order;
    }

    @Override
    public int level() {
        return 74;
    }

    @Override
    public OrderElement multiply(OrderElement o) {
        return new PolynomialOrder(this.order + ((PolynomialOrder)o).order);
    }

    @Override
    public Set<OrderElement> log() {
        if (this.order == 0) {
            throw new ArithmeticException();
        }
        return Collections.singleton(new LogarithmicOrder(1, 1));
    }

    @Override
    public int compareLevel(OrderElement b) {
        return IntMath.compareTo(this.level(), b.level());
    }

    @Override
    public int compareTo(OrderElement o) {
        if (this.level() < o.level()) {
            return -1;
        }
        if (this.level() > o.level()) {
            return 1;
        }
        if (this.order < ((PolynomialOrder)o).order) {
            return -1;
        }
        if (this.order > ((PolynomialOrder)o).order) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isConstant() {
        return this.order == 0;
    }

    public String toString() {
        switch (this.order) {
            case 0: {
                return "1";
            }
            case 1: {
                return "n";
            }
        }
        return "n^" + this.order;
    }
}

