/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.series.decimal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import net.morilib.util.primitive.ByteArrayVector;

public class RationalDecimalSeries
implements Iterator<BigDecimal> {
    private StringBuilder buf = new StringBuilder();
    private byte[] hou0;
    private byte[] jit0;
    private final byte[] zero;
    private transient byte[] tmp0;
    private transient byte[] tmp1;
    private int h0;
    private BigDecimal prev;

    public RationalDecimalSeries(BigInteger a, BigInteger b) {
        this.hou0 = RationalDecimalSeries.split(b);
        this.jit0 = RationalDecimalSeries.ext(RationalDecimalSeries.split(a.mod(b)), this.hou0.length);
        this.zero = new byte[this.jit0.length];
        this.tmp0 = new byte[this.jit0.length];
        this.tmp1 = new byte[this.jit0.length];
        this.buf.append(a.divide(b) + ".");
        Arrays.fill(this.zero, (byte)0);
        this.h0 = RationalDecimalSeries.toInt(this.hou0[0]);
        this.h0 = this.hou0.length > 1 ? this.h0 * 10 + RationalDecimalSeries.toInt(this.hou0[1]) : (this.h0 *= 10);
    }

    private static int toInt(byte b) {
        return b < 0 ? (b & 0x7F) + 128 : b;
    }

    private static boolean mult(byte[] r, byte[] b, int v, int s) {
        int carry = 0;
        int i = r.length - 1;
        while (i >= 0) {
            int k = i - (r.length - b.length) + s;
            int x = (k >= 0 && k < b.length ? RationalDecimalSeries.toInt(b[k]) : 0) * v + carry;
            carry = x / 10;
            r[i] = (byte)(x % 10);
            --i;
        }
        return carry == 0;
    }

    private static boolean sub0(byte[] r, byte[] b, byte[] c) {
        int carry = 0;
        int i = b.length - 1;
        while (i >= 0) {
            int x = RationalDecimalSeries.toInt(b[i]) - RationalDecimalSeries.toInt(c[i]) + carry;
            carry = x > 0 ? x / 10 : (x - 9) / 10;
            r[i] = (byte)(x >= 0 ? x % 10 : (x + 10) % 10);
            --i;
        }
        return carry == 0;
    }

    private static byte[] split(BigInteger a) {
        ByteArrayVector b = new ByteArrayVector();
        while (a.signum() > 0) {
            BigInteger[] c = a.divideAndRemainder(BigInteger.TEN);
            b.add(c[1].byteValue());
            a = c[0];
        }
        byte[] r = new byte[b.size()];
        int i = 0;
        while (i < b.size()) {
            r[i] = (Byte)b.get(b.size() - i - 1);
            ++i;
        }
        return r;
    }

    private static byte[] ext(byte[] a, int ext) {
        byte[] r = new byte[ext + 1];
        Arrays.fill(r, (byte)0);
        System.arraycopy(a, 0, r, ext - a.length, a.length);
        return r;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    BigDecimal _next() {
        if (Arrays.equals(this.jit0, this.zero)) {
            return this.prev;
        }
        int j0 = RationalDecimalSeries.toInt(this.jit0[0]) + 1;
        j0 = j0 * 10 + (this.jit0.length > 1 ? RationalDecimalSeries.toInt(this.jit0[1]) : 0);
        int j = (j0 *= 10) / this.h0;
        while (!RationalDecimalSeries.mult(this.tmp0, this.hou0, j, 0) || !RationalDecimalSeries.sub0(this.tmp1, this.jit0, this.tmp0)) {
            --j;
        }
        this.buf.append((char)(j + 48));
        System.arraycopy(this.tmp1, 1, this.jit0, 0, this.tmp1.length - 1);
        this.jit0[this.tmp1.length - 1] = 0;
        this.prev = new BigDecimal(this.buf.toString());
        return this.prev;
    }

    @Override
    public BigDecimal next() {
        if (Arrays.equals(this.jit0, this.zero)) {
            return this.prev;
        }
        this._next();
        return this._next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

