/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.special;

import net.morilib.math.special.Gamma2;

public class Erf {
    private static final double SQRTPI = Math.sqrt(Math.PI);

    public static double erf(double x) {
        if (Double.isNaN(x)) {
            return x;
        }
        if (Double.isInfinite(x)) {
            return x > 0.0 ? 1.0 : -1.0;
        }
        if (x == 0.0) {
            return 0.0;
        }
        if (x > 0.0) {
            return Gamma2.incompleteGammaLower(0.5, x * x) / SQRTPI;
        }
        return -Erf.erf(-x);
    }

    public static double erfc(double x) {
        return 1.0 - Erf.erf(x);
    }
}

