/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.stat.dist.continuous;

import net.morilib.math.stat.dist.AbstractContinuousDistribution;

public class ExponentialDistribution
extends AbstractContinuousDistribution {
    private static final double LN2 = Math.log(2.0);
    private double lambda;

    public ExponentialDistribution(double lambda) {
        this.lambda = lambda;
    }

    public double getLambda() {
        return this.lambda;
    }

    @Override
    public double expectedValue() {
        return 1.0 / this.lambda;
    }

    @Override
    public double variance() {
        return 1.0 / this.lambda / this.lambda;
    }

    @Override
    public double mode() {
        return 0.0;
    }

    @Override
    public double skewness() {
        return 2.0;
    }

    @Override
    public double kurtosis() {
        return 6.0;
    }

    @Override
    public double f(double x) {
        return x < 0.0 ? Double.NaN : this.lambda * Math.exp(-this.lambda * x);
    }

    @Override
    public boolean isInSupport(double n) {
        return n >= 0.0;
    }

    @Override
    public double cdf(double x) {
        return x < 0.0 ? Double.NaN : 1.0 - Math.exp(-this.lambda * x);
    }

    @Override
    public double supportSupremum() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double supportInfimum() {
        return 0.0;
    }

    @Override
    public double median() {
        return LN2 / this.lambda;
    }

    public int hashCode() {
        int r = 17;
        r = 37 * (r + (int)Double.doubleToLongBits(this.lambda));
        return r;
    }

    public boolean equals(Object o) {
        if (o instanceof ExponentialDistribution) {
            ExponentialDistribution n = (ExponentialDistribution)o;
            return this.lambda == n.lambda;
        }
        return false;
    }
}

