/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.net.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.List;
import net.morilib.net.ftp.FTP;
import net.morilib.net.ftp.FTPClient;

public class FTPActiveClient
extends FTPClient {
    Inet4Address clientAddress = null;

    public FTPActiveClient() {
    }

    public FTPActiveClient(InetAddress address, int port, Inet4Address clientAddress, String username, String password) throws IOException {
        super(address, port, username, password);
        this.clientAddress = clientAddress;
    }

    public FTPActiveClient(InetAddress address, Inet4Address clientAddress, String username, String password) throws IOException {
        this(address, 21, clientAddress, username, password);
    }

    @Override
    public String list() throws IOException {
        if (!this.isConnected()) {
            throw new IllegalStateException();
        }
        return FTP.receiveList(this.pr, this.rd, this.clientAddress);
    }

    @Override
    public List<String> nameList() throws IOException {
        if (!this.isConnected()) {
            throw new IllegalStateException();
        }
        return FTP.receiveNameList(this.pr, this.rd, this.clientAddress);
    }

    @Override
    public void put(String filename, InputStream ins) throws IOException {
        if (!this.isConnected()) {
            throw new IllegalStateException();
        }
        FTP.put(this.pr, this.rd, filename, this.clientAddress, ins);
    }

    @Override
    public void get(String filename, OutputStream ous) throws IOException {
        if (!this.isConnected()) {
            throw new IllegalStateException();
        }
        FTP.get(this.pr, this.rd, filename, this.clientAddress, ous);
    }

    public Inet4Address getClientAddress() {
        return this.clientAddress;
    }
}

