/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.net.mail;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.morilib.net.CRLFPrintStream;
import net.morilib.net.NetUtils;
import net.morilib.util.codec.MIME;

public class SMTP {
    public static final SimpleDateFormat RFC2822_DATE = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US);

    private static List<String> _asList(String[] s) {
        return s == null ? Collections.emptyList() : Arrays.asList(s);
    }

    static void _send(OutputStream pr, InputStream rd, String hostname, String subject, String from, List<String> to, List<String> cc, List<String> bcc, BufferedReader text, String encoding) throws IOException {
        String x;
        String dlm;
        CRLFPrintStream prpr = new CRLFPrintStream(pr);
        NetUtils.getCode(rd, 200);
        SMTP.helo(prpr, rd, hostname);
        SMTP.from(prpr, rd, from);
        for (String s : to) {
            SMTP.rcpt(prpr, rd, s);
        }
        for (String s : cc) {
            SMTP.rcpt(prpr, rd, s);
        }
        for (String s : bcc) {
            SMTP.rcpt(prpr, rd, s);
        }
        SMTP.data(prpr, rd);
        prpr.println("Mime-Version: 1.0");
        if (encoding != null) {
            prpr.print("Content-Type: text/plain; charset=\"");
            prpr.print(encoding);
            prpr.println("\"");
            prpr.println(MIME.encodeBase64(subject, "Subject:", encoding));
            prpr.println("Content-Transfer-Encoding: 7bit");
        } else {
            prpr.println("Content-Type: text/plain");
            prpr.print("Subject: ");
            prpr.println(subject);
        }
        prpr.print("From: ");
        prpr.println(from);
        if (to.size() > 0) {
            prpr.print("To: ");
            dlm = "";
            for (String s : to) {
                prpr.print(dlm);
                prpr.print(s);
                dlm = ", ";
            }
            prpr.println("");
        }
        if (cc.size() > 0) {
            prpr.print("Cc: ");
            dlm = "";
            for (String s : cc) {
                prpr.print(dlm);
                prpr.print(s);
                dlm = ", ";
            }
            prpr.println("");
        }
        if (bcc.size() > 0) {
            prpr.print("Bcc: ");
            dlm = "";
            for (String s : bcc) {
                prpr.print(dlm);
                prpr.print(s);
                dlm = ", ";
            }
            prpr.println("");
        }
        prpr.print("Date: ");
        prpr.println(RFC2822_DATE.format(new Date()));
        while ((x = text.readLine()) != null) {
            if (encoding != null) {
                prpr.write(x.getBytes(encoding));
            } else {
                prpr.write(x.getBytes());
            }
            prpr.write(13);
            prpr.write(10);
        }
        prpr.println(".");
        NetUtils.getCode(rd, 200);
        SMTP.quit(prpr, rd);
    }

    public static void send(String smtpname, int port, String subject, String from, List<String> to, List<String> cc, List<String> bcc, String text, String encoding) throws IOException {
        Socket sok = new Socket(smtpname, port);
        BufferedReader rd = new BufferedReader(new StringReader(text));
        SMTP._send(sok.getOutputStream(), sok.getInputStream(), InetAddress.getLocalHost().getHostName(), subject, from, to, cc, bcc, rd, encoding);
    }

    public static void send(String smtpname, int port, String subject, String from, String[] to, String[] cc, String[] bcc, String text, String encoding) throws IOException {
        Socket sok = new Socket(smtpname, port);
        BufferedReader rd = new BufferedReader(new StringReader(text));
        SMTP._send(sok.getOutputStream(), sok.getInputStream(), InetAddress.getLocalHost().getHostName(), subject, from, SMTP._asList(to), SMTP._asList(cc), SMTP._asList(bcc), rd, encoding);
    }

    public static void send(String smtpname, String subject, String from, List<String> to, List<String> cc, List<String> bcc, String text, String encoding) throws IOException {
        Socket sok = new Socket(smtpname, 25);
        BufferedReader rd = new BufferedReader(new StringReader(text));
        SMTP._send(sok.getOutputStream(), sok.getInputStream(), InetAddress.getLocalHost().getHostName(), subject, from, to, cc, bcc, rd, encoding);
    }

    public static void send(String smtpname, String subject, String from, String[] to, String[] cc, String[] bcc, String text, String encoding) throws IOException {
        Socket sok = new Socket(smtpname, 25);
        BufferedReader rd = new BufferedReader(new StringReader(text));
        SMTP._send(sok.getOutputStream(), sok.getInputStream(), InetAddress.getLocalHost().getHostName(), subject, from, SMTP._asList(to), SMTP._asList(cc), SMTP._asList(bcc), rd, encoding);
    }

    public static void send(InetAddress smtpaddr, int port, String subject, String from, List<String> to, List<String> cc, List<String> bcc, String text, String encoding) throws IOException {
        Socket sok = new Socket(smtpaddr, port);
        BufferedReader rd = new BufferedReader(new StringReader(text));
        SMTP._send(sok.getOutputStream(), sok.getInputStream(), InetAddress.getLocalHost().getHostName(), subject, from, to, cc, bcc, rd, encoding);
    }

    public static void send(InetAddress smtpaddr, int port, String subject, String from, String[] to, String[] cc, String[] bcc, String text, String encoding) throws IOException {
        Socket sok = new Socket(smtpaddr, port);
        BufferedReader rd = new BufferedReader(new StringReader(text));
        SMTP._send(sok.getOutputStream(), sok.getInputStream(), InetAddress.getLocalHost().getHostName(), subject, from, SMTP._asList(to), SMTP._asList(cc), SMTP._asList(bcc), rd, encoding);
    }

    public static void send(InetAddress smtpaddr, String subject, String from, List<String> to, List<String> cc, List<String> bcc, String text, String encoding) throws IOException {
        Socket sok = new Socket(smtpaddr, 25);
        BufferedReader rd = new BufferedReader(new StringReader(text));
        SMTP._send(sok.getOutputStream(), sok.getInputStream(), InetAddress.getLocalHost().getHostName(), subject, from, to, cc, bcc, rd, encoding);
    }

    public static void send(InetAddress smtpaddr, String subject, String from, String[] to, String[] cc, String[] bcc, String text, String encoding) throws IOException {
        Socket sok = new Socket(smtpaddr, 25);
        BufferedReader rd = new BufferedReader(new StringReader(text));
        SMTP._send(sok.getOutputStream(), sok.getInputStream(), InetAddress.getLocalHost().getHostName(), subject, from, SMTP._asList(to), SMTP._asList(cc), SMTP._asList(bcc), rd, encoding);
    }

    public static int helo(CRLFPrintStream pr, InputStream rd, String hostname) throws IOException {
        pr.print("HELO ");
        pr.println(hostname);
        return NetUtils.getCode(rd, 200);
    }

    public static int from(CRLFPrintStream pr, InputStream rd, String from) throws IOException {
        pr.print("MAIL FROM:<");
        pr.print(from);
        pr.println(">");
        return NetUtils.getCode(rd, 200);
    }

    public static int rcpt(CRLFPrintStream pr, InputStream rd, String to) throws IOException {
        pr.print("RCPT TO:<");
        pr.print(to);
        pr.println(">");
        return NetUtils.getCode(rd, 200);
    }

    public static int data(CRLFPrintStream pr, InputStream rd) throws IOException {
        pr.println("DATA");
        return NetUtils.getCode(rd, 300);
    }

    public static int quit(CRLFPrintStream pr, InputStream rd) throws IOException {
        pr.println("QUIT");
        return NetUtils.getCode(rd, 200);
    }
}

