/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.net.misc;

import java.net.ProtocolException;

public class TFTPErrorPacketException
extends ProtocolException {
    private TFTPError code;

    public TFTPErrorPacketException(String str, TFTPError code) {
        super(str);
        this.code = code;
    }

    public TFTPErrorPacketException(String str, int ec) {
        super(str);
        this.code = TFTPErrorPacketException.getErrorCode(ec);
    }

    public static TFTPError getErrorCode(int code) {
        switch (code) {
            case 1: {
                return TFTPError.FILE_NOT_FOUND;
            }
            case 2: {
                return TFTPError.ACCESS_VIOLATION;
            }
            case 3: {
                return TFTPError.OUT_OF_SPACE;
            }
            case 4: {
                return TFTPError.ILLEGAL_OPERATION;
            }
            case 5: {
                return TFTPError.UNKNOWN_TID;
            }
            case 6: {
                return TFTPError.FILE_EXISTS;
            }
            case 7: {
                return TFTPError.NO_SUCH_USER;
            }
            case 8: {
                return TFTPError.OPTION_NEGOTIATION_ERROR;
            }
        }
        return TFTPError.UNDEFINED;
    }

    public TFTPError getErrorCode() {
        return this.code;
    }

    public static enum TFTPError {
        UNDEFINED,
        FILE_NOT_FOUND,
        ACCESS_VIOLATION,
        OUT_OF_SPACE,
        ILLEGAL_OPERATION,
        UNKNOWN_TID,
        FILE_EXISTS,
        NO_SUCH_USER,
        OPTION_NEGOTIATION_ERROR;

    }
}

