/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.net.syslog;

import net.morilib.net.syslog.SyslogFacility;
import net.morilib.net.syslog.SyslogLevel;

public class SyslogPRI {
    private SyslogFacility facility;
    private SyslogLevel level;

    public SyslogPRI(SyslogFacility facility, SyslogLevel level) {
        this.facility = facility;
        this.level = level;
    }

    public SyslogFacility getFacility() {
        return this.facility;
    }

    public SyslogLevel getLevel() {
        return this.level;
    }

    public int getPriorityCode() {
        return this.facility.getCode() * 8 + this.level.getCode();
    }

    public String toSyslogPriority() {
        return "<" + this.getPriorityCode() + ">";
    }

    public int hashCode() {
        return this.getPriorityCode();
    }

    public boolean equals(Object o) {
        if (o instanceof SyslogPRI) {
            SyslogPRI s = (SyslogPRI)o;
            return this.facility.equals((Object)s.facility) && this.level.equals((Object)s.level);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.facility.toString()) + "," + this.level.toString();
    }
}

