/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.morilib.lang.string.ByteString;
import net.morilib.parser.ParsingException;
import net.morilib.util.SimpleMap;
import net.morilib.util.primitive.ByteArrayVector;

public final class ParserUtils {
    private ParserUtils() {
    }

    public static Reader readEncoding(InputStream ins) throws IOException {
        PushbackInputStream ins2 = new PushbackInputStream(ins);
        String enc = null;
        int cb = ins2.read();
        if (cb == 35) {
            ByteArrayVector v = new ByteArrayVector();
            cb = ins2.read();
            if (cb != 63) {
                enc = "US-ASCII";
                ins2.unread(cb);
            }
            while ((cb = ins2.read()) != 10 && cb != 13) {
                if (cb < 0) {
                    throw new ParsingException();
                }
                v.addByte((byte)cb);
            }
            do {
                if ((cb = ins2.read()) >= 0) continue;
                throw new ParsingException();
            } while (cb == 10 || cb == 13);
            enc = enc == null ? new ByteString(v.toByteArray()).toString() : enc;
        } else {
            enc = "US-ASCII";
        }
        ins2.unread(cb);
        return new InputStreamReader((InputStream)ins2, enc);
    }

    public static <T> List<T> parseToList(InputStream ins, String comment, SimpleMap<String, T> map) {
        ArrayList<T> res = new ArrayList<T>();
        try {
            String s;
            BufferedReader rd = new BufferedReader(ParserUtils.readEncoding(ins));
            while ((s = rd.readLine()) != null) {
                if (s.equals("") || s.startsWith(comment)) continue;
                res.add(map.map(s));
            }
            return res;
        }
        catch (IOException e) {
            throw new ParsingException(e);
        }
    }
}

