/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.phys.unit;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.morilib.phys.unit.Units;

public final class Unit
implements Serializable {
    public static final Unit NONDIMENSION = new Unit(false);
    private Map<String, Integer> units;

    private Unit(boolean dummy) {
        this.units = Collections.emptyMap();
    }

    private Unit(String u, int n) {
        this.units = new HashMap<String, Integer>();
        this.units.put(u, n);
    }

    Unit(Map<String, Integer> units) {
        this.units = units;
    }

    public static Unit getUnit(String u, int n) {
        return n == 0 ? NONDIMENSION : new Unit(u, n);
    }

    public int getIndex(String s) {
        Integer i = this.units.get(s);
        return i != null ? i : 0;
    }

    public Map<String, Integer> getIndices() {
        return Collections.unmodifiableMap(this.units);
    }

    public boolean isBaseUnit() {
        if (this.units.size() != 1) {
            return false;
        }
        String s = this.units.keySet().iterator().next();
        return this.units.get(s) == 1;
    }

    public boolean isNondimension() {
        return this.units.isEmpty();
    }

    boolean isSingleDerivedUnit() {
        return this.units.size() == 1;
    }

    int getSingleDerivedIndex() {
        if (this.units.size() != 1) {
            return 0;
        }
        String s = this.units.keySet().iterator().next();
        return this.units.get(s);
    }

    public Unit multiply(Unit u) {
        HashMap<String, Integer> r = new HashMap<String, Integer>(this.units);
        Units.multiply(r, u.units);
        return r.isEmpty() ? NONDIMENSION : new Unit(r);
    }

    public Unit divide(Unit u) {
        HashMap<String, Integer> r = new HashMap<String, Integer>(this.units);
        Units.divide(r, u.units);
        return r.isEmpty() ? NONDIMENSION : new Unit(r);
    }

    public Unit invert() {
        return this.pow(-1);
    }

    public Unit pow(int n) {
        if (n == 0) {
            return NONDIMENSION;
        }
        if (n == 1) {
            return this;
        }
        HashMap<String, Integer> r = new HashMap<String, Integer>(this.units);
        Units.pow(r, n);
        return new Unit(r);
    }

    public int hashCode() {
        return this.units.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof Unit && this.units.equals(((Unit)o).units);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String dlm = "";
        for (String s : this.units.keySet()) {
            b.append(dlm).append(s).append("^").append(this.units.get(s));
            dlm = "*";
        }
        return b.toString();
    }
}

