/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.phys.unit;

import java.util.HashMap;
import java.util.Map;
import net.morilib.phys.unit.Quantity;
import net.morilib.phys.unit.Unit;
import net.morilib.phys.unit.UnitSystem;

public final class Units {
    private static final String PREFIXIES = "YZEPTGMkhcmu\u03bcnpfazy";

    private Units() {
    }

    static void multiply(Map<String, Integer> r, Map<String, Integer> s) {
        for (String x : s.keySet()) {
            int i;
            int n = i = r.containsKey(x) ? r.get(x) + s.get(x) : s.get(x);
            if (i == 0) {
                r.remove(x);
                continue;
            }
            r.put(x, i);
        }
    }

    static void divide(Map<String, Integer> r, Map<String, Integer> s) {
        for (String x : s.keySet()) {
            int i;
            int n = i = r.containsKey(x) ? r.get(x) - s.get(x) : -s.get(x).intValue();
            if (i == 0) {
                r.remove(x);
                continue;
            }
            r.put(x, i);
        }
    }

    static void pow(Map<String, Integer> r, int n) {
        for (String x : r.keySet()) {
            r.put(x, r.get(x) * n);
        }
    }

    public static Quantity parse(UnitSystem sys, String s) {
        HashMap<String, Integer> r = new HashMap<String, Integer>();
        String sx = null;
        double qty = 1.0;
        int state = 100;
        int p = 0;
        int inv = 1;
        int bx1 = 0;
        while (true) {
            char c = p < s.length() ? s.charAt(p++) : (char)'\u0000';
            switch (state) {
                case 100: {
                    if (c == '/') {
                        inv = -inv;
                        state = 1001;
                        break;
                    }
                    if (c == '\u0000') {
                        return new Quantity(qty, new Unit(r));
                    }
                    bx1 = p - 1;
                    state = 101;
                    break;
                }
                case 1001: {
                    if (c == '/' || c == '*' || c == '^') {
                        return null;
                    }
                    state = 101;
                    break;
                }
                case 101: {
                    Quantity q;
                    if (c == '/' || c == '*' || c == '\u0000') {
                        sx = s.substring(bx1, p - (c > '\u0000' ? 1 : 0));
                        q = Units.getSIprefix(sys, sx);
                        if (q == null) {
                            return null;
                        }
                        qty *= q.getValue();
                        if (inv > 0) {
                            Units.multiply(r, q.getUnit().getIndices());
                        } else {
                            Units.divide(r, q.getUnit().getIndices());
                        }
                    }
                    if (c == '/') {
                        inv = -inv;
                        bx1 = p;
                        state = 1001;
                        break;
                    }
                    if (c == '*') {
                        bx1 = p;
                        state = 1001;
                        break;
                    }
                    if (c == '\u0000') {
                        return new Quantity(qty, new Unit(r));
                    }
                    if (c != '^') break;
                    sx = s.substring(bx1, p - 1);
                    bx1 = p;
                    state = 102;
                    break;
                }
                case 102: {
                    if (c == '-') {
                        state = 103;
                        break;
                    }
                    if (c < '0' || c > '9') {
                        return null;
                    }
                    state = 104;
                    break;
                }
                case 103: {
                    if (c < '0' || c > '9') {
                        return null;
                    }
                    state = 104;
                    break;
                }
                case 104: {
                    Quantity q;
                    if (c < '0' || c > '9') {
                        int n = Integer.parseInt(s.substring(bx1, p - (c > '\u0000' ? 1 : 0)));
                        q = Units.getSIprefix(sys, sx);
                        if (q == null) {
                            return null;
                        }
                        q = q.pow(n);
                        Units.multiply(r, q.getUnit().getIndices());
                        qty *= q.getValue();
                    }
                    if (c == '\u0000') {
                        return new Quantity(qty, new Unit(r));
                    }
                    if (c >= '0' && c <= '9') break;
                    if (c == '*') {
                        bx1 = p;
                        state = 1001;
                        break;
                    }
                    if (c != '/') break;
                    inv = -inv;
                    bx1 = p;
                    state = 1001;
                }
            }
        }
    }

    public static Quantity getSIprefix(UnitSystem sys, String u) {
        double x;
        if (u == null) {
            throw new NullPointerException();
        }
        if (u.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (u.length() == 1) {
            return sys.getQuantity(u);
        }
        if (PREFIXIES.indexOf(u.charAt(0)) < 0) {
            return sys.getQuantity(u);
        }
        Quantity q = sys.getQuantity(u.substring(1));
        if (q == null) {
            return sys.getQuantity(u);
        }
        switch (u.charAt(0)) {
            case 'Y': {
                x = 1.0E24;
                break;
            }
            case 'Z': {
                x = 1.0E21;
                break;
            }
            case 'E': {
                x = 1.0E18;
                break;
            }
            case 'P': {
                x = 1.0E15;
                break;
            }
            case 'T': {
                x = 1.0E12;
                break;
            }
            case 'G': {
                x = 1.0E9;
                break;
            }
            case 'M': {
                x = 1000000.0;
                break;
            }
            case 'k': {
                x = 1000.0;
                break;
            }
            case 'h': {
                x = 100.0;
                break;
            }
            case 'c': {
                x = 0.01;
                break;
            }
            case 'm': {
                x = 0.001;
                break;
            }
            case 'u': 
            case '\u03bc': {
                x = 1.0E-6;
                break;
            }
            case 'n': {
                x = 1.0E-9;
                break;
            }
            case 'p': {
                x = 1.0E-12;
                break;
            }
            case 'f': {
                x = 1.0E-15;
                break;
            }
            case 'a': {
                x = 1.0E-18;
                break;
            }
            case 'z': {
                x = 1.0E-21;
                break;
            }
            case 'y': {
                x = 1.0E-24;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return q.multiply(x);
    }
}

