/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.text.number;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public final class EnglishNumber {
    private static final String[] NUMERAL1 = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine"};
    private static final String[] NUMERALTEEN = new String[]{"ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
    private static final String[] NUMERAL10;
    private static final String[] NUMERAL1000;
    static final Map<String, BigInteger> DICTIONARY9;
    static final Map<String, BigInteger> DICTIONARY99;
    static final Map<String, BigInteger> DICTIONARY1000;
    static final BigInteger HUNDRED;

    static {
        String[] stringArray = new String[10];
        stringArray[1] = "ten";
        stringArray[2] = "twenty";
        stringArray[3] = "thirty";
        stringArray[4] = "forty";
        stringArray[5] = "fifty";
        stringArray[6] = "sixty";
        stringArray[7] = "seventy";
        stringArray[8] = "eighty";
        stringArray[9] = "ninety";
        NUMERAL10 = stringArray;
        NUMERAL1000 = new String[]{"", " thousand", " million", " billion", " trillion", " quadrillion", " quintillion", " sextillion", " septillion"};
        HUNDRED = BigInteger.valueOf(100L);
        DICTIONARY9 = EnglishNumber.init9();
        DICTIONARY99 = EnglishNumber.init99();
        DICTIONARY1000 = EnglishNumber.init1000();
    }

    static void putnum(Map<String, BigInteger> m, String s, int i) {
        m.put(s, BigInteger.valueOf(i));
    }

    static Map<String, BigInteger> init9() {
        HashMap<String, BigInteger> m = new HashMap<String, BigInteger>();
        EnglishNumber.putnum(m, "one", 1);
        EnglishNumber.putnum(m, "two", 2);
        EnglishNumber.putnum(m, "three", 3);
        EnglishNumber.putnum(m, "four", 4);
        EnglishNumber.putnum(m, "five", 5);
        EnglishNumber.putnum(m, "six", 6);
        EnglishNumber.putnum(m, "seven", 7);
        EnglishNumber.putnum(m, "eight", 8);
        EnglishNumber.putnum(m, "nine", 9);
        return m;
    }

    static Map<String, BigInteger> init99() {
        Map<String, BigInteger> m = EnglishNumber.init9();
        HashMap<String, BigInteger> n = new HashMap<String, BigInteger>();
        HashMap<String, BigInteger> r = new HashMap<String, BigInteger>();
        EnglishNumber.putnum(n, "twenty", 20);
        EnglishNumber.putnum(n, "thirty", 30);
        EnglishNumber.putnum(n, "forty", 40);
        EnglishNumber.putnum(n, "fifty", 50);
        EnglishNumber.putnum(n, "sixty", 60);
        EnglishNumber.putnum(n, "seventy", 70);
        EnglishNumber.putnum(n, "eighty", 80);
        EnglishNumber.putnum(n, "ninety", 90);
        for (Map.Entry<String, BigInteger> em : m.entrySet()) {
            for (Map.Entry en : n.entrySet()) {
                r.put(String.valueOf((String)en.getKey()) + "-" + em.getKey(), ((BigInteger)en.getValue()).add(em.getValue()));
            }
        }
        r.putAll(m);
        r.putAll(n);
        EnglishNumber.putnum(r, "ten", 10);
        EnglishNumber.putnum(r, "eleven", 11);
        EnglishNumber.putnum(r, "twelve", 12);
        EnglishNumber.putnum(r, "thirteen", 13);
        EnglishNumber.putnum(r, "fourteen", 14);
        EnglishNumber.putnum(r, "fifteen", 15);
        EnglishNumber.putnum(r, "sixteen", 16);
        EnglishNumber.putnum(r, "seventeen", 17);
        EnglishNumber.putnum(r, "eighteen", 18);
        EnglishNumber.putnum(r, "nineteen", 19);
        return r;
    }

    static Map<String, BigInteger> init1000() {
        HashMap<String, BigInteger> m = new HashMap<String, BigInteger>();
        m.put("thousand", new BigInteger("1000"));
        m.put("million", new BigInteger("1000000"));
        m.put("billion", new BigInteger("1000000000"));
        m.put("trillion", new BigInteger("1000000000000"));
        m.put("quadrillion", new BigInteger("1000000000000000"));
        m.put("quintillion", new BigInteger("1000000000000000000"));
        m.put("sextillion", new BigInteger("1000000000000000000000"));
        m.put("septillion", new BigInteger("1000000000000000000000000"));
        return m;
    }

    static int toDigit(char c) {
        if (c < '0' || c > '9') {
            throw new NumberFormatException();
        }
        return c - 48;
    }

    static boolean describeBelowThousand(StringBuilder buf, String s, int b) {
        int c1 = EnglishNumber.toDigit(s.charAt(b));
        int c2 = EnglishNumber.toDigit(s.charAt(b + 1));
        int c3 = EnglishNumber.toDigit(s.charAt(b + 2));
        String dlm = "";
        if (c1 == 0 && c2 == 0 && c3 == 0) {
            return false;
        }
        if (c1 > 0) {
            buf.append(NUMERAL1[c1]).append(" hundred");
            dlm = " ";
        }
        if (c2 >= 2) {
            buf.append(dlm).append(NUMERAL10[c2]);
            if (c3 > 0) {
                buf.append("-").append(NUMERAL1[c3]);
            }
        } else if (c2 == 1) {
            buf.append(dlm).append(NUMERALTEEN[c3]);
        } else if (c3 > 0) {
            buf.append(dlm).append(NUMERAL1[c3]);
        }
        return true;
    }

    public static String toString(BigInteger n) {
        String s0;
        StringBuilder buf = new StringBuilder();
        String dlm = "";
        if (n.signum() < 0) {
            buf.append("minus ");
            s0 = n.negate().toString();
        } else {
            if (n.signum() == 0) {
                return "zero";
            }
            s0 = n.toString();
        }
        switch (s0.length() % 3) {
            case 1: {
                s0 = "00" + s0;
                break;
            }
            case 2: {
                s0 = "0" + s0;
            }
        }
        int i = 0;
        while (i < s0.length()) {
            buf.append(dlm);
            if (EnglishNumber.describeBelowThousand(buf, s0, i)) {
                buf.append(NUMERAL1000[(s0.length() - i) / 3 - 1]);
                dlm = " ";
            }
            i += 3;
        }
        return buf.toString();
    }

    public static String toString(long n) {
        return EnglishNumber.toString(BigInteger.valueOf(n));
    }

    public static BigInteger parseNumber(String s) {
        BigInteger bf = null;
        BigInteger bi = null;
        BigInteger br = BigInteger.ZERO;
        int stat = 100;
        if (s == null) {
            throw new NullPointerException();
        }
        String[] sp = s.split("[ \t]+");
        if (sp.length == 0) {
            throw new NumberFormatException();
        }
        if (s.equals("zero")) {
            return BigInteger.ZERO;
        }
        int i = 0;
        while (true) {
            switch (stat) {
                case 100: {
                    if (i == sp.length) {
                        return br;
                    }
                    bi = DICTIONARY9.get(sp[i]);
                    if (bi != null) {
                        stat = 111;
                        break;
                    }
                    bi = DICTIONARY99.get(sp[i]);
                    if (bi != null) {
                        stat = 131;
                        break;
                    }
                    throw new NumberFormatException();
                }
                case 111: {
                    if (i == sp.length) {
                        return br.add(bi);
                    }
                    if (sp[i].equals("hundred")) {
                        bi = bi.multiply(HUNDRED);
                        stat = 121;
                        break;
                    }
                    BigInteger bj = DICTIONARY1000.get(sp[i]);
                    if (bj != null) {
                        if (bf != null && bf.compareTo(bj) < 0) {
                            throw new NumberFormatException();
                        }
                        br = br.add(bi.multiply(bj));
                        bf = bj;
                        stat = 100;
                        break;
                    }
                    throw new NumberFormatException();
                }
                case 121: {
                    if (i == sp.length) {
                        return br.add(bi);
                    }
                    BigInteger bj = DICTIONARY99.get(sp[i]);
                    if (bj != null) {
                        bi = bi.add(bj);
                        stat = 131;
                        break;
                    }
                    bj = DICTIONARY1000.get(sp[i]);
                    if (bj != null) {
                        if (bf != null && bf.compareTo(bj) < 0) {
                            throw new NumberFormatException();
                        }
                        br = br.add(bi.multiply(bj));
                        bf = bj;
                        stat = 100;
                        break;
                    }
                    throw new NumberFormatException();
                }
                case 131: {
                    if (i == sp.length) {
                        return br.add(bi);
                    }
                    BigInteger bj = DICTIONARY1000.get(sp[i]);
                    if (bj != null) {
                        if (bf != null && bf.compareTo(bj) < 0) {
                            throw new NumberFormatException();
                        }
                        br = br.add(bi.multiply(bj));
                        bf = bj;
                        stat = 100;
                        break;
                    }
                    throw new NumberFormatException();
                }
            }
            ++i;
        }
    }
}

