/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Stack;

public final class IOs {
    public static final InputStream NULL_INPUT = new InputStream(){

        @Override
        public int read() throws IOException {
            return -1;
        }

        @Override
        public int available() throws IOException {
            return 0;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public synchronized void mark(int readlimit) {
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return -1;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return -1;
        }

        @Override
        public synchronized void reset() throws IOException {
        }

        @Override
        public long skip(long n) throws IOException {
            return 0L;
        }
    };
    public static final OutputStream NULL_OUTPUT = new OutputStream(){

        @Override
        public void write(byte[] b, int off, int len) {
        }

        @Override
        public void write(byte[] b) {
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }
    };
    private static final int BUFFER_SIZE = 4096;
    private static Stack<PrintStream> outstack = new Stack();
    private static Stack<PrintStream> errstack = new Stack();
    private static Stack<InputStream> instack = new Stack();

    private IOs() {
    }

    public static void close(Closeable ins) {
        if (ins != null) {
            try {
                ins.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void close(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void close(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void close(Reader stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void close(Writer stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static BufferedReader newBufferedReader(InputStream ins, String encoding) throws IOException {
        return new BufferedReader(new InputStreamReader(ins, encoding));
    }

    public static BufferedReader newBufferedReader(File file, String encoding) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
    }

    public static BufferedReader newBufferedReader(File file) throws IOException {
        return new BufferedReader(new FileReader(file));
    }

    public static BufferedReader newBufferedReader(String filename, String encoding) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), encoding));
    }

    public static BufferedReader newBufferedReader(String filename) throws IOException {
        return new BufferedReader(new FileReader(filename));
    }

    public static PrintWriter newPrintWriter(String filename, String encoding) throws IOException {
        return new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), encoding)));
    }

    public static PrintWriter newPrintWriter(String filename) throws IOException {
        return new PrintWriter(new BufferedWriter(new FileWriter(filename)));
    }

    public static String readUntil(Reader rd, int ch) throws IOException {
        StringBuffer buf = new StringBuffer();
        int c = rd.read();
        while (c > 0 && c != ch) {
            buf.append(c);
        }
        return buf.toString();
    }

    public static void checkSupported(String encoding) throws UnsupportedEncodingException {
        new InputStreamReader(NULL_INPUT, encoding);
    }

    public static void pushOut(PrintStream ps) {
        outstack.push(System.out);
        System.setOut(ps);
    }

    public static PrintStream peekOut() {
        return outstack.peek();
    }

    public static PrintStream popOut() {
        PrintStream r = outstack.pop();
        System.setOut(r);
        return r;
    }

    public static void pushErr(PrintStream ps) {
        errstack.push(System.err);
        System.setOut(ps);
    }

    public static PrintStream peekErr() {
        return errstack.peek();
    }

    public static PrintStream popErr() {
        PrintStream r = errstack.pop();
        System.setErr(r);
        return r;
    }

    public static void pushIn(InputStream ps) {
        instack.push(System.in);
        System.setIn(ps);
    }

    public static InputStream peekIn() {
        return instack.peek();
    }

    public static InputStream popIn() {
        InputStream r = instack.pop();
        System.setIn(r);
        return r;
    }

    public static void copy(InputStream ins, OutputStream ous) throws IOException {
        int l;
        BufferedInputStream bi = new BufferedInputStream(ins);
        BufferedOutputStream bo = new BufferedOutputStream(ous);
        byte[] cs = new byte[4096];
        while ((l = bi.read(cs)) >= 0) {
            bo.write(cs, 0, l);
        }
        bo.flush();
    }

    public static void copy(Reader rd, Writer wr) throws IOException {
        int l;
        BufferedReader bi = new BufferedReader(rd);
        BufferedWriter bo = new BufferedWriter(wr);
        char[] cs = new char[4096];
        while ((l = bi.read(cs)) >= 0) {
            bo.write(cs, 0, l);
        }
        bo.flush();
    }

    public static void copy(File fs, File fd) throws IOException {
        FileInputStream ins = null;
        FileOutputStream ous = null;
        try {
            ins = new FileInputStream(fs);
            ous = new FileOutputStream(fd);
            IOs.copy(ins, ous);
        }
        catch (Throwable throwable) {
            IOs.close(ins);
            IOs.close(ous);
            throw throwable;
        }
        IOs.close(ins);
        IOs.close(ous);
    }

    public static String toString(File f, String enc) throws IOException {
        String string;
        FileInputStream ins = null;
        BufferedReader rd = null;
        StringBuilder b = new StringBuilder();
        String dlm = "";
        try {
            String s;
            ins = new FileInputStream(f);
            rd = enc != null ? new BufferedReader(new InputStreamReader((InputStream)ins, enc)) : new BufferedReader(new InputStreamReader(ins));
            while ((s = rd.readLine()) != null) {
                b.append(dlm).append(s);
                dlm = "\n";
            }
            string = b.toString();
        }
        catch (Throwable throwable) {
            IOs.close(ins);
            throw throwable;
        }
        IOs.close(ins);
        return string;
    }

    public static void fromString(File f, String s, String enc) throws IOException {
        FileOutputStream ous = null;
        OutputStreamWriter wr = null;
        StringReader rd = new StringReader(s);
        try {
            ous = new FileOutputStream(f);
            wr = enc != null ? new OutputStreamWriter((OutputStream)ous, enc) : new OutputStreamWriter(ous);
            IOs.copy(rd, wr);
        }
        catch (Throwable throwable) {
            IOs.close(ous);
            throw throwable;
        }
        IOs.close(ous);
    }

    public static boolean isStreamSerialized(InputStream ins, byte[] buf) throws IOException {
        return ins.read(buf, 0, 2) == 2 && buf[0] == -84 && buf[1] == -19;
    }
}

