/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.codec;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import net.morilib.util.codec.Base64Decoder;
import net.morilib.util.codec.Base64Encoder;
import net.morilib.util.codec.DecodeException;
import net.morilib.util.codec.Decoder;
import net.morilib.util.codec.MIMEException;
import net.morilib.util.codec.QuotedPrintable;

public class MIME {
    private static final int _MAXLENGTH = 76;

    public static String decode(String src) throws MIMEException {
        int p = -1;
        int state = 0;
        StringBuilder b = null;
        StringBuilder r = new StringBuilder();
        StringBuilder x = new StringBuilder();
        Decoder dec = null;
        while (++p < src.length()) {
            char c = src.charAt(p);
            if (c < '\u0000' || c > '\u007f') {
                throw new MIMEException();
            }
            switch (state) {
                case 0: {
                    if (c != '=') break;
                    state = 1;
                    break;
                }
                case 1: {
                    state = c == '?' ? 2 : 0;
                    b = new StringBuilder();
                    break;
                }
                case 2: {
                    if (c == '?') {
                        state = 3;
                        break;
                    }
                    b.append(c);
                    break;
                }
                case 3: {
                    switch (c) {
                        case 'Q': {
                            dec = QuotedPrintable.STANDARD;
                            break;
                        }
                        case 'B': {
                            dec = Base64Decoder.STANDARD;
                            break;
                        }
                        default: {
                            throw new MIMEException();
                        }
                    }
                    state = 4;
                    break;
                }
                case 4: {
                    if (c == '?') {
                        state = 5;
                        break;
                    }
                    throw new MIMEException();
                }
                case 5: {
                    if (c == '?') {
                        state = 6;
                        break;
                    }
                    x.append(c);
                    break;
                }
                case 6: {
                    if (c == '=') {
                        try {
                            r.append(new String(dec.decode(x.toString()), b.toString()));
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new MIMEException(e);
                        }
                        catch (DecodeException e) {
                            throw new MIMEException(e);
                        }
                        x = new StringBuilder();
                        state = 7;
                        break;
                    }
                    throw new MIMEException();
                }
                case 7: {
                    if (c == '\r') {
                        state = 8;
                        break;
                    }
                    throw new MIMEException();
                }
                case 8: {
                    if (c == '\n') {
                        state = 0;
                        break;
                    }
                    throw new MIMEException();
                }
            }
        }
        if (state != 7 && state != 0) {
            throw new MIMEException();
        }
        return r.toString();
    }

    public static String encodeBase64(String src, String header, String encoding) throws UnsupportedEncodingException {
        int l;
        byte[] z;
        char[] s0 = new char[1];
        char[] ss = new char[2];
        byte[] b = null;
        int p = 0;
        int m = 0;
        ByteArrayOutputStream r = new ByteArrayOutputStream();
        ByteArrayOutputStream t = new ByteArrayOutputStream();
        boolean jis = false;
        boolean dir = false;
        boolean ini = false;
        if (header != null) {
            z = header.getBytes();
            l = header.length();
            r.write(z, 0, z.length);
        } else {
            l = 0;
        }
        l += 4;
        while (p < src.length()) {
            int c = src.codePointAt(p);
            if (c > 65535) {
                int x1 = c & 0x3FF;
                int x2 = c >> 10 & 0x3F;
                int x3 = (c >> 16 & 0x1F) - 1 & 0xF;
                ss[0] = (char)(0xD800 | x3 << 6 | x2);
                ss[1] = (char)(0xDC00 | x1);
                b = new String(ss).getBytes(encoding);
                p += 2;
            } else {
                s0[0] = (char)(c & 0xFFFF);
                b = new String(s0).getBytes(encoding);
                ++p;
            }
            if (!dir) {
                if (ini) {
                    r.write(13);
                    r.write(10);
                }
                z = (" =?" + encoding + "?B?").getBytes();
                r.write(z, 0, z.length);
                l += encoding.length() + 6;
                ini = true;
            }
            if (!encoding.equalsIgnoreCase("ISO-2022-JP")) {
                t.write(b, 0, b.length);
                m += b.length;
            } else if (b.length == 1) {
                if (jis) {
                    t.write(27);
                    t.write(40);
                    t.write(66);
                    jis = false;
                    m += 3;
                }
                t.write(b, 0, b.length);
                m += b.length;
            } else {
                if (!jis) {
                    t.write(27);
                    t.write(36);
                    t.write(66);
                    jis = true;
                    m += 3;
                }
                t.write(b, 3, b.length - 6);
                m += b.length - 6;
            }
            l += m / 3 * 4;
            m %= 3;
            if (l + (jis ? 10 : 6) > 76) {
                if (jis) {
                    t.write(27);
                    t.write(40);
                    t.write(66);
                    jis = false;
                    m += 3;
                }
                z = Base64Encoder.STANDARD.encode(t.toByteArray()).getBytes();
                r.write(z, 0, z.length);
                r.write(63);
                r.write(61);
                l = 0;
                t = new ByteArrayOutputStream();
                dir = false;
                continue;
            }
            dir = true;
        }
        if (dir) {
            if (jis) {
                t.write(27);
                t.write(40);
                t.write(66);
            }
            z = Base64Encoder.STANDARD.encode(t.toByteArray()).getBytes();
            r.write(z, 0, z.length);
            r.write(63);
            r.write(61);
        }
        return new String(r.toByteArray());
    }
}

