/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import net.morilib.lang.Hashes;
import net.morilib.util.primitive.AbstractCharacterCollection;
import net.morilib.util.primitive.CharacterArrayVector;
import net.morilib.util.primitive.CharacterCollection;
import net.morilib.util.primitive.CharacterCollections;
import net.morilib.util.primitive.CharacterList;
import net.morilib.util.primitive.CharacterVector;
import net.morilib.util.primitive.iterator.CharacterIterator;
import net.morilib.util.primitive.iterator.CharacterVectorIterator;

public abstract class AbstractCharacterVector
extends AbstractCharacterCollection
implements CharacterVector,
RandomAccess {
    protected transient int modCount = 0;

    @Override
    public boolean addAllChar(int index, CharacterCollection a) {
        int i2 = index;
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        ++this.modCount;
        if (a.isEmpty()) {
            return false;
        }
        CharacterIterator i = a.charIterator();
        while (i.hasNext()) {
            this.addChar(i2++, i.next());
        }
        return true;
    }

    @Override
    public char first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getChar(0);
    }

    @Override
    public int indexOfChar(char v) {
        if (this instanceof RandomAccess) {
            int i = 0;
            while (i < this.size()) {
                if (this.getChar(i) == v) {
                    return i;
                }
                ++i;
            }
        } else {
            CharacterVectorIterator i = this.charVectorIterator();
            int j = 0;
            while (i.hasNext()) {
                if (i.next() == v) {
                    return j;
                }
                ++j;
            }
        }
        return -1;
    }

    @Override
    public CharacterList rest() {
        return this.subVector(1, this.size());
    }

    @Override
    public CharacterList rest(int index) {
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this.size()) {
            return CharacterCollections.EMPTY_VECTOR;
        }
        return this.subVector(index, this.size());
    }

    @Override
    public boolean addChar(char v) {
        ++this.modCount;
        this.addChar(this.size(), v);
        return true;
    }

    @Override
    public boolean addAllChar(CharacterCollection a) {
        return this.addAllChar(this.size(), a);
    }

    @Override
    public boolean addAllChar(CharacterCollection ... as) {
        int nsize = 0;
        CharacterCollection[] characterCollectionArray = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            CharacterCollection a = characterCollectionArray[n2];
            nsize += a.size();
            ++n2;
        }
        if (nsize > 0) {
            boolean r = false;
            ++this.modCount;
            CharacterCollection[] characterCollectionArray2 = as;
            int n3 = as.length;
            n = 0;
            while (n < n3) {
                CharacterCollection a = characterCollectionArray2[n];
                r = this.addAllChar(a) | r;
                ++n;
            }
            return r;
        }
        return false;
    }

    @Override
    public boolean addAllChar(Collection<? extends CharacterCollection> as) {
        int nsize = 0;
        for (CharacterCollection characterCollection : as) {
            nsize += characterCollection.size();
        }
        if (nsize > 0) {
            int n;
            boolean bl = false;
            ++this.modCount;
            for (CharacterCollection characterCollection : as) {
                n = this.addAllChar(characterCollection) | n;
            }
            return n != 0;
        }
        return false;
    }

    @Override
    public boolean containsChar(char v) {
        return this.indexOfChar(v) >= 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean addAllChar(char[] a) {
        return this.addAllChar(this.size(), (CharacterCollection)new CharacterArrayVector(a));
    }

    @Override
    public boolean addAllChar(int ptr, char[] a) {
        return this.addAllChar(ptr, (CharacterCollection)new CharacterArrayVector(a));
    }

    @Override
    public CharacterIterator charIterator() {
        return new Itr(null, null);
    }

    @Override
    public boolean removeChar(char v) {
        int ind = this.indexOfChar(v);
        ++this.modCount;
        if (ind < 0) {
            return false;
        }
        this.removeAt(ind);
        return true;
    }

    @Override
    public boolean remove(Object v) {
        int ind = this.indexOf(v);
        ++this.modCount;
        if (ind < 0) {
            return false;
        }
        this.removeAt(ind);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Character> a) {
        ++this.modCount;
        return this.addAll(this.size(), a);
    }

    @Override
    public boolean contains(Object v) {
        return this.indexOf(v) >= 0;
    }

    @Override
    public int lastIndexOfChar(char v) {
        if (this instanceof RandomAccess) {
            int i = this.size() - 1;
            while (i >= 0) {
                if (this.getChar(i) == v) {
                    return i;
                }
                --i;
            }
        } else {
            CharacterVectorIterator i = this.charVectorIterator();
            while (i.hasNext()) {
                i.next();
            }
            int j = this.size() - 1;
            while (i.hasPrevious()) {
                if (i.previous() == v) {
                    return j;
                }
                --j;
            }
        }
        return -1;
    }

    @Override
    public CharacterVectorIterator charVectorIterator() {
        return this.charVectorIterator(0);
    }

    @Override
    public CharacterVectorIterator charVectorIterator(int index) {
        return new VItr();
    }

    @Override
    public CharacterVector subVector(int start, int end) {
        if (start < 0 || start >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (end < 0 || end > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (end < start) {
            throw new IndexOutOfBoundsException();
        }
        return new SubV(this, start, end);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Character> c) {
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int i2 = index;
        ++this.modCount;
        if (c.isEmpty()) {
            return false;
        }
        Iterator<? extends Character> i = c.iterator();
        while (i.hasNext()) {
            this.add(i2++, i.next());
        }
        return true;
    }

    @Override
    public Character get(int index) {
        return Character.valueOf(this.getChar(index));
    }

    @Override
    public Character set(int index, Character element) {
        return Character.valueOf(this.setChar(index, element.charValue()));
    }

    @Override
    public void add(int index, Character element) {
        this.addChar(index, element.charValue());
    }

    @Override
    public Character remove(int index) {
        return Character.valueOf(this.removeAt(index));
    }

    @Override
    public int indexOf(Object o) {
        if (o instanceof Character) {
            return this.indexOfChar(((Character)o).charValue());
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o instanceof Character) {
            return this.lastIndexOfChar(((Character)o).charValue());
        }
        return -1;
    }

    @Override
    public ListIterator<Character> listIterator() {
        final CharacterVectorIterator i = this.charVectorIterator();
        return new ListIterator<Character>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public Character next() {
                return Character.valueOf(i.next());
            }

            @Override
            public boolean hasPrevious() {
                return i.hasPrevious();
            }

            @Override
            public Character previous() {
                return Character.valueOf(i.previous());
            }

            @Override
            public int nextIndex() {
                return i.nextIndex();
            }

            @Override
            public int previousIndex() {
                return i.previousIndex();
            }

            @Override
            public void remove() {
                i.remove();
            }

            @Override
            public void set(Character e) {
                i.setChar(e.charValue());
            }

            @Override
            public void add(Character e) {
                i.addChar(e.charValue());
            }
        };
    }

    @Override
    public ListIterator<Character> listIterator(int index) {
        return this.listIterator(0);
    }

    @Override
    public List<Character> subList(int fromIndex, int toIndex) {
        final CharacterVector v = this.subVector(fromIndex, toIndex);
        return new AbstractList<Character>(){

            @Override
            public Character get(int index) {
                return (Character)v.get(index);
            }

            @Override
            public int size() {
                return AbstractCharacterVector.this.size();
            }

            @Override
            public Character set(int index, Character element) {
                return v.set(index, element);
            }

            @Override
            public void add(int index, Character element) {
                v.add(index, element);
            }

            @Override
            public Character remove(int index) {
                return (Character)v.remove(index);
            }
        };
    }

    @Override
    public void add(int index, int v) {
        if (v < 0 || v > 65535) {
            throw new IllegalArgumentException();
        }
        this.addChar(index, (char)v);
    }

    @Override
    public char set(int index, int v) {
        if (v < 0 || v > 65535) {
            throw new IllegalArgumentException();
        }
        return this.setChar(index, (char)v);
    }

    @Override
    public int indexOf(int v) {
        if (v < 0 || v > 65535) {
            return -1;
        }
        return this.indexOfChar((char)v);
    }

    @Override
    public int hashCode() {
        return Hashes.sumHashCode(this.toCharArray());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CharacterVector) {
            CharacterVector v = (CharacterVector)obj;
            if (this.size() != v.size()) {
                return false;
            }
            int i = 0;
            while (i < this.size()) {
                if (this.getChar(i) != v.getChar(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (obj instanceof CharacterList) {
            CharacterIterator i = this.charIterator();
            CharacterIterator j = ((CharacterList)obj).charIterator();
            while (i.hasNext() && j.hasNext()) {
                if (i.next() == j.next()) continue;
                return false;
            }
            return !i.hasNext() && !j.hasNext();
        }
        return false;
    }

    private class Itr
    implements CharacterIterator {
        int ptr = 0;
        int ptrrem = -1;
        int exModCount;

        private Itr() {
            this.exModCount = AbstractCharacterVector.this.modCount;
        }

        void checks() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.exModCount != AbstractCharacterVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        void checks2() {
            if (this.ptrrem < 0) {
                throw new IllegalStateException();
            }
            if (this.ptrrem >= AbstractCharacterVector.this.size()) {
                throw new NoSuchElementException();
            }
            if (this.exModCount != AbstractCharacterVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.ptr < AbstractCharacterVector.this.size();
        }

        @Override
        public char next() {
            this.checks();
            this.ptrrem = this.ptr;
            return AbstractCharacterVector.this.getChar(this.ptr++);
        }

        @Override
        public void remove() {
            this.checks2();
            try {
                AbstractCharacterVector.this.removeAt(this.ptrrem);
                this.exModCount = AbstractCharacterVector.this.modCount;
                --this.ptr;
                this.ptrrem = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        /* synthetic */ Itr(Itr itr, Itr itr2) {
            this();
        }
    }

    private static class SubV
    extends AbstractCharacterVector {
        private CharacterVector vector;
        private int bindex;
        private int eindex;

        private SubV(CharacterVector vector, int b, int e) {
            this.vector = vector;
            this.bindex = b;
            this.eindex = e;
        }

        @Override
        public void addChar(int index, char v) {
            if (index < 0 || index > this.size()) {
                throw new IndexOutOfBoundsException();
            }
            ++this.eindex;
            this.vector.addChar(index + this.bindex, v);
        }

        @Override
        public char getChar(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return this.vector.getChar(index + this.bindex);
        }

        @Override
        public char removeAt(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            --this.eindex;
            return this.vector.removeAt(index + this.bindex);
        }

        @Override
        public char setChar(int index, char v) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return this.vector.setChar(index + this.bindex, v);
        }

        @Override
        public int size() {
            return this.eindex - this.bindex;
        }
    }

    private class VItr
    extends Itr
    implements CharacterVectorIterator {
        private VItr() {
        }

        @Override
        public void addChar(char v) {
            if (this.exModCount != AbstractCharacterVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                this.ptrrem = -1;
                AbstractCharacterVector.this.addChar(this.ptr++, v);
                this.exModCount = AbstractCharacterVector.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasPrevious() {
            return this.ptr > 0;
        }

        @Override
        public int nextIndex() {
            return this.ptr;
        }

        @Override
        public char previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            if (this.exModCount != AbstractCharacterVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                char res = AbstractCharacterVector.this.getChar(this.ptr);
                this.ptrrem = --this.ptr;
                return res;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public int previousIndex() {
            return this.ptr - 1;
        }

        @Override
        public void setChar(char v) {
            if (!this.hasNext()) {
                throw new IllegalArgumentException();
            }
            if (this.exModCount != AbstractCharacterVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.ptrrem < 0) {
                throw new IllegalStateException();
            }
            try {
                AbstractCharacterVector.this.setChar(this.ptr, v);
                this.ptrrem = -1;
                this.exModCount = AbstractCharacterVector.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(int v) {
            if (v < 0 || v > 65535) {
                throw new IllegalArgumentException();
            }
            this.addChar((char)v);
        }

        @Override
        public void set(int v) {
            if (v < 0 || v > 65535) {
                throw new IllegalArgumentException();
            }
            this.setChar((char)v);
        }
    }
}

