/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import net.morilib.lang.Hashes;
import net.morilib.util.primitive.AbstractFloatCollection;
import net.morilib.util.primitive.FloatArrayVector;
import net.morilib.util.primitive.FloatCollection;
import net.morilib.util.primitive.FloatCollections;
import net.morilib.util.primitive.FloatList;
import net.morilib.util.primitive.FloatVector;
import net.morilib.util.primitive.iterator.FloatIterator;
import net.morilib.util.primitive.iterator.FloatVectorIterator;

public abstract class AbstractFloatVector
extends AbstractFloatCollection
implements FloatVector,
RandomAccess {
    protected transient int modCount = 0;

    @Override
    public boolean addAllFloat(int index, FloatCollection a) {
        int i2 = index;
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        ++this.modCount;
        if (a.isEmpty()) {
            return false;
        }
        FloatIterator i = a.floatIterator();
        while (i.hasNext()) {
            this.addFloat(i2++, i.next());
        }
        return true;
    }

    @Override
    public float first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getFloat(0);
    }

    @Override
    public int indexOfFloat(float v) {
        if (this instanceof RandomAccess) {
            int i = 0;
            while (i < this.size()) {
                if (this.getFloat(i) == v) {
                    return i;
                }
                ++i;
            }
        } else {
            FloatVectorIterator i = this.floatVectorIterator();
            int j = 0;
            while (i.hasNext()) {
                if (i.next() == v) {
                    return j;
                }
                ++j;
            }
        }
        return -1;
    }

    @Override
    public FloatList rest() {
        return this.subVector(1, this.size());
    }

    @Override
    public FloatList rest(int index) {
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this.size()) {
            return FloatCollections.EMPTY_VECTOR;
        }
        return this.subVector(index, this.size());
    }

    @Override
    public boolean addFloat(float v) {
        ++this.modCount;
        this.addFloat(this.size(), v);
        return true;
    }

    @Override
    public boolean addAllFloat(FloatCollection a) {
        return this.addAllFloat(this.size(), a);
    }

    @Override
    public boolean addAllFloat(FloatCollection ... as) {
        int nsize = 0;
        FloatCollection[] floatCollectionArray = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            FloatCollection a = floatCollectionArray[n2];
            nsize += a.size();
            ++n2;
        }
        if (nsize > 0) {
            boolean r = false;
            ++this.modCount;
            FloatCollection[] floatCollectionArray2 = as;
            int n3 = as.length;
            n = 0;
            while (n < n3) {
                FloatCollection a = floatCollectionArray2[n];
                r = this.addAllFloat(a) | r;
                ++n;
            }
            return r;
        }
        return false;
    }

    @Override
    public boolean addAllFloat(Collection<? extends FloatCollection> as) {
        int nsize = 0;
        for (FloatCollection floatCollection : as) {
            nsize += floatCollection.size();
        }
        if (nsize > 0) {
            int n;
            boolean bl = false;
            ++this.modCount;
            for (FloatCollection floatCollection : as) {
                n = this.addAllFloat(floatCollection) | n;
            }
            return n != 0;
        }
        return false;
    }

    @Override
    public boolean containsFloat(float v) {
        return this.indexOfFloat(v) >= 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean addAllFloat(float[] a) {
        return this.addAllFloat(this.size(), (FloatCollection)new FloatArrayVector(a));
    }

    @Override
    public boolean addAllFloat(int ptr, float[] a) {
        return this.addAllFloat(ptr, (FloatCollection)new FloatArrayVector(a));
    }

    @Override
    public FloatIterator floatIterator() {
        return new Itr(null, null);
    }

    @Override
    public boolean removeFloat(float v) {
        int ind = this.indexOfFloat(v);
        ++this.modCount;
        if (ind < 0) {
            return false;
        }
        this.removeAt(ind);
        return true;
    }

    @Override
    public boolean remove(Object v) {
        int ind = this.indexOf(v);
        ++this.modCount;
        if (ind < 0) {
            return false;
        }
        this.removeAt(ind);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Float> a) {
        ++this.modCount;
        return this.addAll(this.size(), a);
    }

    @Override
    public boolean contains(Object v) {
        return this.indexOf(v) >= 0;
    }

    @Override
    public int lastIndexOfFloat(float v) {
        if (this instanceof RandomAccess) {
            int i = this.size() - 1;
            while (i >= 0) {
                if (this.getFloat(i) == v) {
                    return i;
                }
                --i;
            }
        } else {
            FloatVectorIterator i = this.floatVectorIterator();
            while (i.hasNext()) {
                i.next();
            }
            int j = this.size() - 1;
            while (i.hasPrevious()) {
                if (i.previous() == v) {
                    return j;
                }
                --j;
            }
        }
        return -1;
    }

    @Override
    public FloatVectorIterator floatVectorIterator() {
        return this.floatVectorIterator(0);
    }

    @Override
    public FloatVectorIterator floatVectorIterator(int index) {
        return new VItr();
    }

    @Override
    public FloatVector subVector(int start, int end) {
        if (start < 0 || start >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (end < 0 || end > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (end < start) {
            throw new IndexOutOfBoundsException();
        }
        return new SubV(this, start, end);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Float> c) {
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int i2 = index;
        ++this.modCount;
        if (c.isEmpty()) {
            return false;
        }
        Iterator<? extends Float> i = c.iterator();
        while (i.hasNext()) {
            this.add(i2++, i.next());
        }
        return true;
    }

    @Override
    public Float get(int index) {
        return Float.valueOf(this.getFloat(index));
    }

    @Override
    public Float set(int index, Float element) {
        return Float.valueOf(this.setFloat(index, element.floatValue()));
    }

    @Override
    public void add(int index, Float element) {
        this.addFloat(index, element.floatValue());
    }

    @Override
    public Float remove(int index) {
        return Float.valueOf(this.removeAt(index));
    }

    @Override
    public int indexOf(Object o) {
        if (o instanceof Float) {
            return this.indexOfFloat(((Float)o).floatValue());
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o instanceof Float) {
            return this.lastIndexOfFloat(((Float)o).floatValue());
        }
        return -1;
    }

    @Override
    public ListIterator<Float> listIterator() {
        final FloatVectorIterator i = this.floatVectorIterator();
        return new ListIterator<Float>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public Float next() {
                return Float.valueOf(i.next());
            }

            @Override
            public boolean hasPrevious() {
                return i.hasPrevious();
            }

            @Override
            public Float previous() {
                return Float.valueOf(i.previous());
            }

            @Override
            public int nextIndex() {
                return i.nextIndex();
            }

            @Override
            public int previousIndex() {
                return i.previousIndex();
            }

            @Override
            public void remove() {
                i.remove();
            }

            @Override
            public void set(Float e) {
                i.setFloat(e.floatValue());
            }

            @Override
            public void add(Float e) {
                i.addFloat(e.floatValue());
            }
        };
    }

    @Override
    public ListIterator<Float> listIterator(int index) {
        return this.listIterator(0);
    }

    @Override
    public List<Float> subList(int fromIndex, int toIndex) {
        final FloatVector v = this.subVector(fromIndex, toIndex);
        return new AbstractList<Float>(){

            @Override
            public Float get(int index) {
                return (Float)v.get(index);
            }

            @Override
            public int size() {
                return AbstractFloatVector.this.size();
            }

            @Override
            public Float set(int index, Float element) {
                return v.set(index, element);
            }

            @Override
            public void add(int index, Float element) {
                v.add(index, element);
            }

            @Override
            public Float remove(int index) {
                return (Float)v.remove(index);
            }
        };
    }

    @Override
    public void add(int index, int v) {
        if ((float)v < Float.MIN_VALUE || (float)v > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.addFloat(index, v);
    }

    @Override
    public float set(int index, int v) {
        if ((float)v < Float.MIN_VALUE || (float)v > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.setFloat(index, v);
    }

    @Override
    public int indexOf(int v) {
        if ((float)v < Float.MIN_VALUE || (float)v > Float.MAX_VALUE) {
            return -1;
        }
        return this.indexOfFloat(v);
    }

    @Override
    public int hashCode() {
        return Hashes.sumHashCode(this.toFloatArray());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FloatVector) {
            FloatVector v = (FloatVector)obj;
            if (this.size() != v.size()) {
                return false;
            }
            int i = 0;
            while (i < this.size()) {
                if (this.getFloat(i) != v.getFloat(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (obj instanceof FloatList) {
            FloatIterator i = this.floatIterator();
            FloatIterator j = ((FloatList)obj).floatIterator();
            while (i.hasNext() && j.hasNext()) {
                if (i.next() == j.next()) continue;
                return false;
            }
            return !i.hasNext() && !j.hasNext();
        }
        return false;
    }

    private class Itr
    implements FloatIterator {
        int ptr = 0;
        int ptrrem = -1;
        int exModCount;

        private Itr() {
            this.exModCount = AbstractFloatVector.this.modCount;
        }

        void checks() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.exModCount != AbstractFloatVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        void checks2() {
            if (this.ptrrem < 0) {
                throw new IllegalStateException();
            }
            if (this.ptrrem >= AbstractFloatVector.this.size()) {
                throw new NoSuchElementException();
            }
            if (this.exModCount != AbstractFloatVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.ptr < AbstractFloatVector.this.size();
        }

        @Override
        public float next() {
            this.checks();
            this.ptrrem = this.ptr;
            return AbstractFloatVector.this.getFloat(this.ptr++);
        }

        @Override
        public void remove() {
            this.checks2();
            try {
                AbstractFloatVector.this.removeAt(this.ptrrem);
                this.exModCount = AbstractFloatVector.this.modCount;
                --this.ptr;
                this.ptrrem = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        /* synthetic */ Itr(Itr itr, Itr itr2) {
            this();
        }
    }

    private static class SubV
    extends AbstractFloatVector {
        private FloatVector vector;
        private int bindex;
        private int eindex;

        private SubV(FloatVector vector, int b, int e) {
            this.vector = vector;
            this.bindex = b;
            this.eindex = e;
        }

        @Override
        public void addFloat(int index, float v) {
            if (index < 0 || index > this.size()) {
                throw new IndexOutOfBoundsException();
            }
            ++this.eindex;
            this.vector.addFloat(index + this.bindex, v);
        }

        @Override
        public float getFloat(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return this.vector.getFloat(index + this.bindex);
        }

        @Override
        public float removeAt(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            --this.eindex;
            return this.vector.removeAt(index + this.bindex);
        }

        @Override
        public float setFloat(int index, float v) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return this.vector.setFloat(index + this.bindex, v);
        }

        @Override
        public int size() {
            return this.eindex - this.bindex;
        }
    }

    private class VItr
    extends Itr
    implements FloatVectorIterator {
        private VItr() {
        }

        @Override
        public void addFloat(float v) {
            if (this.exModCount != AbstractFloatVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                this.ptrrem = -1;
                AbstractFloatVector.this.addFloat(this.ptr++, v);
                this.exModCount = AbstractFloatVector.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasPrevious() {
            return this.ptr > 0;
        }

        @Override
        public int nextIndex() {
            return this.ptr;
        }

        @Override
        public float previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            if (this.exModCount != AbstractFloatVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                float res = AbstractFloatVector.this.getFloat(this.ptr);
                this.ptrrem = --this.ptr;
                return res;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public int previousIndex() {
            return this.ptr - 1;
        }

        @Override
        public void setFloat(float v) {
            if (!this.hasNext()) {
                throw new IllegalArgumentException();
            }
            if (this.exModCount != AbstractFloatVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.ptrrem < 0) {
                throw new IllegalStateException();
            }
            try {
                AbstractFloatVector.this.setFloat(this.ptr, v);
                this.ptrrem = -1;
                this.exModCount = AbstractFloatVector.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(int v) {
            if ((float)v < Float.MIN_VALUE || (float)v > Float.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            this.addFloat(v);
        }

        @Override
        public void set(int v) {
            if ((float)v < Float.MIN_VALUE || (float)v > Float.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            this.setFloat(v);
        }
    }
}

