/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import net.morilib.lang.Hashes;
import net.morilib.util.primitive.AbstractShortCollection;
import net.morilib.util.primitive.ShortArrayVector;
import net.morilib.util.primitive.ShortCollection;
import net.morilib.util.primitive.ShortCollections;
import net.morilib.util.primitive.ShortList;
import net.morilib.util.primitive.ShortVector;
import net.morilib.util.primitive.iterator.ShortIterator;
import net.morilib.util.primitive.iterator.ShortVectorIterator;

public abstract class AbstractShortVector
extends AbstractShortCollection
implements ShortVector,
RandomAccess {
    protected transient int modCount = 0;

    @Override
    public boolean addAllShort(int index, ShortCollection a) {
        int i2 = index;
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        ++this.modCount;
        if (a.isEmpty()) {
            return false;
        }
        ShortIterator i = a.shortIterator();
        while (i.hasNext()) {
            this.addShort(i2++, i.next());
        }
        return true;
    }

    @Override
    public short first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getShort(0);
    }

    @Override
    public int indexOfShort(short v) {
        if (this instanceof RandomAccess) {
            int i = 0;
            while (i < this.size()) {
                if (this.getShort(i) == v) {
                    return i;
                }
                ++i;
            }
        } else {
            ShortVectorIterator i = this.shortVectorIterator();
            int j = 0;
            while (i.hasNext()) {
                if (i.next() == v) {
                    return j;
                }
                ++j;
            }
        }
        return -1;
    }

    @Override
    public ShortList rest() {
        return this.subVector(1, this.size());
    }

    @Override
    public ShortList rest(int index) {
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this.size()) {
            return ShortCollections.EMPTY_VECTOR;
        }
        return this.subVector(index, this.size());
    }

    @Override
    public boolean addShort(short v) {
        ++this.modCount;
        this.addShort(this.size(), v);
        return true;
    }

    @Override
    public boolean addAllShort(ShortCollection a) {
        return this.addAllShort(this.size(), a);
    }

    @Override
    public boolean addAllShort(ShortCollection ... as) {
        int nsize = 0;
        ShortCollection[] shortCollectionArray = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            ShortCollection a = shortCollectionArray[n2];
            nsize += a.size();
            ++n2;
        }
        if (nsize > 0) {
            boolean r = false;
            ++this.modCount;
            ShortCollection[] shortCollectionArray2 = as;
            int n3 = as.length;
            n = 0;
            while (n < n3) {
                ShortCollection a = shortCollectionArray2[n];
                r = this.addAllShort(a) | r;
                ++n;
            }
            return r;
        }
        return false;
    }

    @Override
    public boolean addAllShort(Collection<? extends ShortCollection> as) {
        int nsize = 0;
        for (ShortCollection shortCollection : as) {
            nsize += shortCollection.size();
        }
        if (nsize > 0) {
            int n;
            boolean bl = false;
            ++this.modCount;
            for (ShortCollection shortCollection : as) {
                n = this.addAllShort(shortCollection) | n;
            }
            return n != 0;
        }
        return false;
    }

    @Override
    public boolean containsShort(short v) {
        return this.indexOfShort(v) >= 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean addAllShort(short[] a) {
        return this.addAllShort(this.size(), (ShortCollection)new ShortArrayVector(a));
    }

    @Override
    public boolean addAllShort(int ptr, short[] a) {
        return this.addAllShort(ptr, (ShortCollection)new ShortArrayVector(a));
    }

    @Override
    public ShortIterator shortIterator() {
        return new Itr(null, null);
    }

    @Override
    public boolean removeShort(short v) {
        int ind = this.indexOfShort(v);
        ++this.modCount;
        if (ind < 0) {
            return false;
        }
        this.removeAt(ind);
        return true;
    }

    @Override
    public boolean remove(Object v) {
        int ind = this.indexOf(v);
        ++this.modCount;
        if (ind < 0) {
            return false;
        }
        this.removeAt(ind);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Short> a) {
        ++this.modCount;
        return this.addAll(this.size(), a);
    }

    @Override
    public boolean contains(Object v) {
        return this.indexOf(v) >= 0;
    }

    @Override
    public int lastIndexOfShort(short v) {
        if (this instanceof RandomAccess) {
            int i = this.size() - 1;
            while (i >= 0) {
                if (this.getShort(i) == v) {
                    return i;
                }
                --i;
            }
        } else {
            ShortVectorIterator i = this.shortVectorIterator();
            while (i.hasNext()) {
                i.next();
            }
            int j = this.size() - 1;
            while (i.hasPrevious()) {
                if (i.previous() == v) {
                    return j;
                }
                --j;
            }
        }
        return -1;
    }

    @Override
    public ShortVectorIterator shortVectorIterator() {
        return this.shortVectorIterator(0);
    }

    @Override
    public ShortVectorIterator shortVectorIterator(int index) {
        return new VItr();
    }

    @Override
    public ShortVector subVector(int start, int end) {
        if (start < 0 || start >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (end < 0 || end > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (end < start) {
            throw new IndexOutOfBoundsException();
        }
        return new SubV(this, start, end);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Short> c) {
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int i2 = index;
        ++this.modCount;
        if (c.isEmpty()) {
            return false;
        }
        Iterator<? extends Short> i = c.iterator();
        while (i.hasNext()) {
            this.add(i2++, i.next());
        }
        return true;
    }

    @Override
    public Short get(int index) {
        return this.getShort(index);
    }

    @Override
    public Short set(int index, Short element) {
        return this.setShort(index, element);
    }

    @Override
    public void add(int index, Short element) {
        this.addShort(index, element);
    }

    @Override
    public Short remove(int index) {
        return this.removeAt(index);
    }

    @Override
    public int indexOf(Object o) {
        if (o instanceof Short) {
            return this.indexOfShort((Short)o);
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o instanceof Short) {
            return this.lastIndexOfShort((Short)o);
        }
        return -1;
    }

    @Override
    public ListIterator<Short> listIterator() {
        final ShortVectorIterator i = this.shortVectorIterator();
        return new ListIterator<Short>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public Short next() {
                return i.next();
            }

            @Override
            public boolean hasPrevious() {
                return i.hasPrevious();
            }

            @Override
            public Short previous() {
                return i.previous();
            }

            @Override
            public int nextIndex() {
                return i.nextIndex();
            }

            @Override
            public int previousIndex() {
                return i.previousIndex();
            }

            @Override
            public void remove() {
                i.remove();
            }

            @Override
            public void set(Short e) {
                i.setShort(e);
            }

            @Override
            public void add(Short e) {
                i.addShort(e);
            }
        };
    }

    @Override
    public ListIterator<Short> listIterator(int index) {
        return this.listIterator(0);
    }

    @Override
    public List<Short> subList(int fromIndex, int toIndex) {
        final ShortVector v = this.subVector(fromIndex, toIndex);
        return new AbstractList<Short>(){

            @Override
            public Short get(int index) {
                return (Short)v.get(index);
            }

            @Override
            public int size() {
                return AbstractShortVector.this.size();
            }

            @Override
            public Short set(int index, Short element) {
                return v.set(index, element);
            }

            @Override
            public void add(int index, Short element) {
                v.add(index, element);
            }

            @Override
            public Short remove(int index) {
                return (Short)v.remove(index);
            }
        };
    }

    @Override
    public void add(int index, int v) {
        if (v < Short.MIN_VALUE || v > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.addShort(index, (short)v);
    }

    @Override
    public short set(int index, int v) {
        if (v < Short.MIN_VALUE || v > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.setShort(index, (short)v);
    }

    @Override
    public int indexOf(int v) {
        if (v < Short.MIN_VALUE || v > Short.MAX_VALUE) {
            return -1;
        }
        return this.indexOfShort((short)v);
    }

    @Override
    public int hashCode() {
        return Hashes.sumHashCode(this.toShortArray());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ShortVector) {
            ShortVector v = (ShortVector)obj;
            if (this.size() != v.size()) {
                return false;
            }
            int i = 0;
            while (i < this.size()) {
                if (this.getShort(i) != v.getShort(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (obj instanceof ShortList) {
            ShortIterator i = this.shortIterator();
            ShortIterator j = ((ShortList)obj).shortIterator();
            while (i.hasNext() && j.hasNext()) {
                if (i.next() == j.next()) continue;
                return false;
            }
            return !i.hasNext() && !j.hasNext();
        }
        return false;
    }

    private class Itr
    implements ShortIterator {
        int ptr = 0;
        int ptrrem = -1;
        int exModCount;

        private Itr() {
            this.exModCount = AbstractShortVector.this.modCount;
        }

        void checks() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.exModCount != AbstractShortVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        void checks2() {
            if (this.ptrrem < 0) {
                throw new IllegalStateException();
            }
            if (this.ptrrem >= AbstractShortVector.this.size()) {
                throw new NoSuchElementException();
            }
            if (this.exModCount != AbstractShortVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.ptr < AbstractShortVector.this.size();
        }

        @Override
        public short next() {
            this.checks();
            this.ptrrem = this.ptr;
            return AbstractShortVector.this.getShort(this.ptr++);
        }

        @Override
        public void remove() {
            this.checks2();
            try {
                AbstractShortVector.this.removeAt(this.ptrrem);
                this.exModCount = AbstractShortVector.this.modCount;
                --this.ptr;
                this.ptrrem = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        /* synthetic */ Itr(Itr itr, Itr itr2) {
            this();
        }
    }

    private static class SubV
    extends AbstractShortVector {
        private ShortVector vector;
        private int bindex;
        private int eindex;

        private SubV(ShortVector vector, int b, int e) {
            this.vector = vector;
            this.bindex = b;
            this.eindex = e;
        }

        @Override
        public void addShort(int index, short v) {
            if (index < 0 || index > this.size()) {
                throw new IndexOutOfBoundsException();
            }
            ++this.eindex;
            this.vector.addShort(index + this.bindex, v);
        }

        @Override
        public short getShort(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return this.vector.getShort(index + this.bindex);
        }

        @Override
        public short removeAt(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            --this.eindex;
            return this.vector.removeAt(index + this.bindex);
        }

        @Override
        public short setShort(int index, short v) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return this.vector.setShort(index + this.bindex, v);
        }

        @Override
        public int size() {
            return this.eindex - this.bindex;
        }
    }

    private class VItr
    extends Itr
    implements ShortVectorIterator {
        private VItr() {
        }

        @Override
        public void addShort(short v) {
            if (this.exModCount != AbstractShortVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                this.ptrrem = -1;
                AbstractShortVector.this.addShort(this.ptr++, v);
                this.exModCount = AbstractShortVector.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasPrevious() {
            return this.ptr > 0;
        }

        @Override
        public int nextIndex() {
            return this.ptr;
        }

        @Override
        public short previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            if (this.exModCount != AbstractShortVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                short res = AbstractShortVector.this.getShort(this.ptr);
                this.ptrrem = --this.ptr;
                return res;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public int previousIndex() {
            return this.ptr - 1;
        }

        @Override
        public void setShort(short v) {
            if (!this.hasNext()) {
                throw new IllegalArgumentException();
            }
            if (this.exModCount != AbstractShortVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.ptrrem < 0) {
                throw new IllegalStateException();
            }
            try {
                AbstractShortVector.this.setShort(this.ptr, v);
                this.ptrrem = -1;
                this.exModCount = AbstractShortVector.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(int v) {
            if (v < Short.MIN_VALUE || v > Short.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            this.addShort((short)v);
        }

        @Override
        public void set(int v) {
            if (v < Short.MIN_VALUE || v > Short.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            this.setShort((short)v);
        }
    }
}

