/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.po;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.morilib.util.primitive.AbstractLongSet;
import net.morilib.util.primitive.LongSet;
import net.morilib.util.primitive.iterator.LongIterator;
import net.morilib.util.primitive.map.po.LongMap;

public abstract class AbstractLongMap<V>
implements LongMap<V> {
    private transient LongSet keySet = null;
    private transient Collection<V> values = null;

    @Override
    public void clear() {
        Iterator i = this.longKeyEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValue(Object v) {
        for (LongMap.PrimitiveEntryK e : this.longKeyEntrySet()) {
            Object p = e.getValue();
            if ((v != null || p != null) && (v == null || !v.equals(p))) continue;
            return true;
        }
        return false;
    }

    @Override
    public V getElement(long k) {
        for (LongMap.PrimitiveEntryK e : this.longKeyEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public LongSet longKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.longKeyEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(LongMap<V> map) {
        for (LongMap.PrimitiveEntryK<V> e : map.longKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public Collection<V> values() {
        return this.values == null ? (this.values = new VCol(this.longKeyEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Long) {
            return this.containsKeyElement((Long)key);
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (key instanceof Long) {
            return this.getElement((Long)key);
        }
        return null;
    }

    @Override
    public V put(Long key, V value) {
        return this.putElement(key, value);
    }

    @Override
    public V remove(Object key) {
        if (key instanceof Long) {
            return this.removeElement((Long)key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Long, ? extends V> m) {
        for (Map.Entry<Long, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Set<Long> keySet() {
        return this.longKeySet();
    }

    @Override
    public Set<Map.Entry<Long, V>> entrySet() {
        final Set e = this.longKeyEntrySet();
        return new AbstractSet<Map.Entry<Long, V>>(){

            @Override
            public Iterator<Map.Entry<Long, V>> iterator() {
                final Iterator i = e.iterator();
                return new Iterator<Map.Entry<Long, V>>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public Map.Entry<Long, V> next() {
                        final LongMap.PrimitiveEntryK o = (LongMap.PrimitiveEntryK)i.next();
                        return new Map.Entry<Long, V>(){

                            @Override
                            public Long getKey() {
                                return o.getKey();
                            }

                            @Override
                            public V getValue() {
                                return o.getValue();
                            }

                            @Override
                            public V setValue(V value) {
                                return o.setValue(value);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        i.remove();
                    }
                };
            }

            @Override
            public int size() {
                return e.size();
            }
        };
    }

    @Override
    public boolean containsKey(int k) {
        if ((long)k < Long.MIN_VALUE || (long)k > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement(k);
    }

    @Override
    public boolean containsKeyElement(long k) {
        for (LongMap.PrimitiveEntryK e : this.longKeyEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(int k) {
        if ((long)k < Long.MIN_VALUE || (long)k > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.getElement(k);
    }

    @Override
    public V put(int k, V v) {
        if ((long)k < Long.MIN_VALUE || (long)k > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.putElement(k, v);
    }

    @Override
    public V removeElement(long k) {
        Iterator i = this.longKeyEntrySet().iterator();
        while (i.hasNext()) {
            LongMap.PrimitiveEntryK e = i.next();
            if (e.getKey() != k) continue;
            Object r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public V remove(int k) {
        if ((long)k < Long.MIN_VALUE || (long)k > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.removeElement(k);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (LongMap.PrimitiveEntryK e : this.longKeyEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof LongMap)) break block1;
            m = (LongMap)obj;
            i = this.longKeyEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && (v == null && p == null || v != null && v.equals(p))) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (LongMap.PrimitiveEntryK e : this.longKeyEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    private class KSet
    extends AbstractLongSet {
        private Set<LongMap.PrimitiveEntryK<V>> eset;

        private KSet(Set<LongMap.PrimitiveEntryK<V>> eset) {
            this.eset = eset;
        }

        @Override
        public LongIterator longIterator() {
            final Iterator ei = this.eset.iterator();
            return new LongIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public long next() {
                    return ((LongMap.PrimitiveEntryK)ei.next()).getKey();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractLongMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return AbstractLongMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractLongMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractLongMap.this.clear();
        }

        @Override
        public boolean addLong(long v) {
            throw new UnsupportedOperationException();
        }
    }

    private class VCol
    extends AbstractCollection<V> {
        private Set<LongMap.PrimitiveEntryK<V>> eset;

        private VCol(Set<LongMap.PrimitiveEntryK<V>> eset) {
            this.eset = eset;
        }

        @Override
        public Iterator<V> iterator() {
            final Iterator ei = this.eset.iterator();
            return new Iterator<V>(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public V next() {
                    return ((LongMap.PrimitiveEntryK)ei.next()).getValue();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractLongMap.this.size();
        }
    }
}

