/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.map.pp.AbstractByteLongMap;
import net.morilib.util.primitive.map.pp.ByteLongMap;

public class ByteLongHashMap
extends AbstractByteLongMap
implements Serializable {
    private static final long serialVersionUID = -2524637876889987554L;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final Object MARK_A = new Object();
    private transient Ent[] ent;
    private transient int size;
    private final float loadFactor;
    private int threshold;
    private volatile transient int modCount;
    private transient Set<ByteLongMap.PrimitiveEntry> entrySet;

    /*
     * Unable to fully structure code
     */
    public ByteLongHashMap(int initialCapacity, float loadFactor) {
        block3: {
            super();
            this.modCount = 0;
            this.entrySet = null;
            cp = 1;
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
            }
            if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
                throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
            }
            if (initialCapacity < 0x40000000) ** GOTO lbl13
            cp = 0x40000000;
            break block3;
lbl-1000:
            // 1 sources

            {
                cp <<= 1;
lbl13:
                // 2 sources

                ** while (cp < initialCapacity)
            }
        }
        this.ent = new Ent[cp];
        this.size = 0;
        this.threshold = (int)((float)cp * loadFactor + 1.0f);
        this.loadFactor = loadFactor;
    }

    public ByteLongHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ByteLongHashMap(float loadFactor) {
        this(16, loadFactor);
    }

    public ByteLongHashMap() {
        this(16, 0.75f);
    }

    public ByteLongHashMap(ByteLongMap mp) {
        this(16, 0.75f);
        this.putAllElement(mp);
    }

    private Iterator<ByteLongMap.PrimitiveEntry> entrySetIterator() {
        return new Iterator<ByteLongMap.PrimitiveEntry>(){
            private int ptr = -1;
            private Ent e = this._next();
            private Ent remove = null;
            private int exModCount;
            {
                this.exModCount = ByteLongHashMap.this.modCount;
            }

            /*
             * Unable to fully structure code
             */
            private Ent _next() {
                v0 = this.e = this.ptr < 0 ? null : Ent.access$0(this.e);
                if (this.e == null) ** GOTO lbl6
                return this.e;
lbl-1000:
                // 1 sources

                {
                    if (ByteLongHashMap.access$2(ByteLongHashMap.this)[this.ptr] == null) continue;
                    return ByteLongHashMap.access$2(ByteLongHashMap.this)[this.ptr];
lbl6:
                    // 2 sources

                    ** while (++this.ptr < ByteLongHashMap.access$2((ByteLongHashMap)ByteLongHashMap.this).length)
                }
lbl7:
                // 1 sources

                return null;
            }

            @Override
            public boolean hasNext() {
                return this.e != null;
            }

            @Override
            public ByteLongMap.PrimitiveEntry next() {
                this.remove = this.e;
                if (this.e == null) {
                    throw new NoSuchElementException();
                }
                if (this.exModCount != ByteLongHashMap.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                this.e = this._next();
                return this.remove;
            }

            @Override
            public void remove() {
                if (this.remove == null) {
                    throw new IllegalStateException();
                }
                ByteLongHashMap.this._remove(this.remove.key);
                this.exModCount = ByteLongHashMap.this.modCount;
                this.remove = null;
            }
        };
    }

    @Override
    public Set<ByteLongMap.PrimitiveEntry> primitiveEntrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<ByteLongMap.PrimitiveEntry>(){

                @Override
                public Iterator<ByteLongMap.PrimitiveEntry> iterator() {
                    return ByteLongHashMap.this.entrySetIterator();
                }

                @Override
                public int size() {
                    return ByteLongHashMap.this.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        int i = 0;
        while (i < this.ent.length) {
            this.ent[i] = null;
            ++i;
        }
    }

    protected int getHash(byte k) {
        return k;
    }

    private Ent _get(byte k) {
        int h = this.getHash(k) % this.ent.length;
        return this.ent[h] != null ? this.ent[h].searchEntry(k) : null;
    }

    @Override
    public boolean containsKeyElement(byte k) {
        return this._get(k) != null;
    }

    @Override
    public long f(byte k) {
        return this._get(k).value;
    }

    private void resize() {
        if (this.size > this.threshold && this.ent.length < 0x40000000) {
            int ns = this.ent.length;
            while (this.size > this.threshold) {
                this.threshold = (int)((float)(ns <<= 1) * this.loadFactor + 1.0f);
            }
            Ent[] ne = new Ent[ns];
            for (ByteLongMap.PrimitiveEntry e : this.primitiveEntrySet()) {
                byte b = e.getKey();
                int h = this.getHash(b) % ns;
                if (ne[h] == null) {
                    ne[h] = new Ent(b, e.getValue());
                    continue;
                }
                ne[h].putEntry(b, e.getValue());
            }
        }
    }

    @Override
    public Long putElement(byte k, long v) {
        int h = this.getHash(k) % this.ent.length;
        ++this.modCount;
        if (this.ent[h] == null) {
            ++this.size;
            this.resize();
            this.ent[h] = new Ent(k, v);
            return null;
        }
        Object r = this.ent[h].putEntry(k, v);
        if (r == MARK_A) {
            ++this.size;
            this.resize();
            return null;
        }
        return (Long)r;
    }

    private boolean _putEntry(byte k, Long v) {
        int h = this.getHash(k) % this.ent.length;
        if (this.ent[h] == null) {
            this.ent[h] = new Ent(k, v);
            return true;
        }
        return this.ent[h].putEntry(k, v) != MARK_A;
    }

    private Ent _remove(byte k) {
        int h = this.getHash(k) % this.ent.length;
        if (this.ent[h] == null) {
            return null;
        }
        if (k == this.ent[h].key) {
            Ent r = this.ent[h];
            --this.size;
            this.ent[h] = r.next;
            return r;
        }
        --this.size;
        return this.ent[h].removeEntry(k);
    }

    @Override
    public Long removeElement(byte k) {
        Ent r = this._remove(k);
        return r != null ? Long.valueOf(r.value) : null;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.ent.length);
        s.writeInt(this.size);
        for (ByteLongMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            s.writeByte(e.getKey());
            s.writeObject(e.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int cp = s.readInt();
        this.ent = new Ent[cp];
        this.size = s.readInt();
        int i = 0;
        while (i < this.size) {
            byte k = s.readByte();
            Long v = (Long)s.readObject();
            this._putEntry(k, v);
            ++i;
        }
    }

    static /* synthetic */ Ent[] access$2(ByteLongHashMap byteLongHashMap) {
        return byteLongHashMap.ent;
    }

    private static class Ent
    implements ByteLongMap.PrimitiveEntry {
        private byte key;
        private long value;
        private Ent next;

        private Ent(byte key, long value) {
            this.key = key;
            this.value = value;
        }

        public int hashCode() {
            return this.key;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Ent) {
                Ent e = (Ent)obj;
                return this.key == e.key;
            }
            return false;
        }

        public String toString() {
            return String.valueOf(Byte.toString(this.key)) + "=" + this.value;
        }

        private Ent searchEntry(byte k) {
            Ent f = this;
            while (f != null) {
                if (k == f.key) {
                    return f;
                }
                f = f.next;
            }
            return null;
        }

        private Ent removeEntry(byte k) {
            Ent g = this;
            Ent f = this.next;
            while (f != null) {
                if (k == f.key) {
                    g.next = f.next;
                    return f;
                }
                g = f;
                f = f.next;
            }
            return null;
        }

        private Object putEntry(byte k, Long v) {
            Ent g = this;
            Ent f = this.next;
            while (f != null) {
                if (k == f.key) {
                    Long r = f.value;
                    f.value = v;
                    return r;
                }
                g = f;
                f = f.next;
            }
            g.next = new Ent(k, v);
            return MARK_A;
        }

        @Override
        public byte getKey() {
            return this.key;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public long setValue(long v) {
            long r = this.value;
            this.value = v;
            return r;
        }
    }
}

