/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.swing;

import java.io.File;
import java.util.Arrays;
import javax.swing.filechooser.FileFilter;

public class ExtensionFileFilter
extends FileFilter {
    private String[] extensions;
    private String description;

    public ExtensionFileFilter(String extension, String description) {
        this.extensions = extension.split(",");
        this.description = description;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        int i = 0;
        while (i < this.extensions.length) {
            if (f.getName().endsWith("." + this.extensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] getExtensions() {
        return Arrays.copyOf(this.extensions, this.extensions.length);
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

