/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.table;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.morilib.util.table.AbstractTable;
import net.morilib.util.table.Table;

public class ArrayTable<E>
extends AbstractTable<E>
implements Serializable {
    private static final long serialVersionUID = 4486229552291087150L;
    private Object[][] table;

    public ArrayTable(E[] ... table) {
        if (table == null) {
            throw new NullPointerException();
        }
        if (table.length == 0) {
            this.table = new Object[0][];
        }
        int len = table[0].length;
        this.table = new Object[table.length][len];
        int i = 0;
        while (i < table.length) {
            E[] e = table[i];
            if (e.length != len) {
                throw new IllegalArgumentException("length must be equal" + e.length);
            }
            System.arraycopy(e, 0, this.table[i], 0, len);
            ++i;
        }
    }

    public ArrayTable(int rows, int cols) {
        if (rows < 0) {
            throw new IllegalArgumentException("rows" + rows);
        }
        if (cols < 0) {
            throw new IllegalArgumentException("columns" + cols);
        }
        this.table = new Object[rows][cols];
    }

    public ArrayTable(Table<E> table) {
        if (table == null) {
            throw new NullPointerException();
        }
        this.table = new Object[table.rowSize()][table.columnSize()];
        int i = 0;
        while (i < table.rowSize()) {
            int j = 0;
            while (j < table.columnSize()) {
                this.table[i][j] = table.get(i, j);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public E get(int r, int c) {
        if (r < 0 || r >= this.rowSize()) {
            throw new IndexOutOfBoundsException("row " + r);
        }
        if (c < 0 || c >= this.columnSize()) {
            throw new IndexOutOfBoundsException("column " + c);
        }
        return (E)this.table[r][c];
    }

    @Override
    public int rowSize() {
        return this.table.length;
    }

    @Override
    public int columnSize() {
        return this.table.length > 0 ? this.table[0].length : 0;
    }

    @Override
    public E set(int r, int c, E o) {
        if (r < 0 || r >= this.rowSize()) {
            throw new IndexOutOfBoundsException("row " + r);
        }
        if (c < 0 || c >= this.columnSize()) {
            throw new IndexOutOfBoundsException("column " + c);
        }
        Object res = this.table[r][c];
        this.table[r][c] = o;
        return (E)res;
    }

    @Override
    protected void addColumn(int col) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void addRow(int row) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<E> getRow(int row) {
        return Collections.unmodifiableList(Arrays.asList(this.table[row]));
    }
}

