/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.atto;

import net.morilib.lisp.atto.AttoParser;
import net.morilib.lisp.atto.AttoUtils;
import net.morilib.lisp.atto.Callback;
import net.morilib.lisp.atto.Cell;
import net.morilib.lisp.atto.Environment;
import net.morilib.lisp.atto.Symbol;

public final class AttoTraverser {
    public static Object traverse(Callback b, Environment v, Object o) {
        if (o instanceof Symbol) {
            return b.find(v, o);
        }
        if (o instanceof AttoParser.StringWrapper) {
            return b.value(v, ((AttoParser.StringWrapper)o).wrap);
        }
        if (!(o instanceof Cell) || o == Cell.NIL) {
            return b.value(v, o);
        }
        Object[] a = AttoUtils.toArray(o);
        if (a[0] == Symbol.IF) {
            if (a.length == 3) {
                return b.doIf(v, a[1], a[2]);
            }
            if (a.length == 4) {
                return b.doIf(v, a[1], a[2], a[3]);
            }
            throw new IllegalArgumentException();
        }
        if (a[0] == Symbol.LAMBDA) {
            Object[] z = new Object[a.length - 2];
            int k = 2;
            while (k < a.length) {
                z[k - 2] = a[k];
                ++k;
            }
            return b.doLambda(v, a[1], z);
        }
        if (a[0] == Symbol.QUOTE) {
            if (a.length == 2) {
                return b.value(v, a[1]);
            }
            throw new IllegalArgumentException();
        }
        if (a[0] == Symbol.BEGIN) {
            Object[] z = new Object[a.length - 1];
            int k = 1;
            while (k < a.length) {
                z[k - 1] = a[k];
                ++k;
            }
            return b.doBegin(v, z);
        }
        if (a[0] == Symbol.DEFINE) {
            if (a.length == 3) {
                return b.doDefine(v, a[1], a[2]);
            }
            throw new IllegalArgumentException();
        }
        if (a[0] == Symbol.SET) {
            if (a.length == 3) {
                return b.doSet(v, a[1], a[2]);
            }
            throw new IllegalArgumentException();
        }
        if (a[0] == Symbol.DELAY) {
            if (a.length == 2) {
                return b.doDelay(v, a[1]);
            }
            throw new IllegalArgumentException();
        }
        Object[] z = new Object[a.length - 1];
        int k = 1;
        while (k < a.length) {
            z[k - 1] = a[k];
            ++k;
        }
        return b.apply(v, a[0], z);
    }
}

