/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.atto;

import java.math.BigInteger;
import java.util.List;
import net.morilib.lisp.atto.Appliable;
import net.morilib.lisp.atto.AttoTraverser;
import net.morilib.lisp.atto.AttoUtils;
import net.morilib.lisp.atto.Builtin;
import net.morilib.lisp.atto.CPSWrapper;
import net.morilib.lisp.atto.Callback;
import net.morilib.lisp.atto.Cell;
import net.morilib.lisp.atto.Closure;
import net.morilib.lisp.atto.Environment;
import net.morilib.lisp.atto.LispAtto;
import net.morilib.lisp.atto.Symbol;

public class SimpleEngine
implements Callback {
    private static final BigInteger MAXINT_1 = BigInteger.valueOf(0x80000000L);
    private static final BigInteger MININT_1 = BigInteger.valueOf(-2147483649L);
    static final SimpleEngine INSTANCE = new SimpleEngine();
    static final Builtin CONS = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args[0] == null || args[1] == null) {
                throw new NullPointerException();
            }
            if (args.length == 2) {
                return new Cell(args[0], args[1]);
            }
            throw new IllegalArgumentException();
        }
    };
    static final Builtin EQ = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            Object p = null;
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (p != null && p != o) {
                    return Boolean.FALSE;
                }
                p = o;
                ++n2;
            }
            return Boolean.TRUE;
        }
    };
    static final Builtin EQV = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            Object p = null;
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (p != null && !p.equals(o)) {
                    return Boolean.FALSE;
                }
                p = o;
                ++n2;
            }
            return Boolean.TRUE;
        }
    };
    static final Builtin CAR = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length != 1) {
                throw new IllegalArgumentException();
            }
            if (args[0].equals(Cell.NIL)) {
                throw new IllegalArgumentException();
            }
            if (args[0] instanceof Cell) {
                return ((Cell)args[0]).car;
            }
            throw new IllegalArgumentException();
        }
    };
    static final Builtin CDR = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length != 1) {
                throw new IllegalArgumentException();
            }
            if (args[0].equals(Cell.NIL)) {
                throw new IllegalArgumentException();
            }
            if (args[0] instanceof Cell) {
                return ((Cell)args[0]).cdr;
            }
            throw new IllegalArgumentException();
        }
    };
    static final Builtin ATOM = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length == 1) {
                return new Boolean(!(args[0] instanceof Cell));
            }
            throw new IllegalArgumentException();
        }
    };
    static final Builtin NULL = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length == 1) {
                return new Boolean(args[0] == Cell.NIL);
            }
            throw new IllegalArgumentException();
        }
    };
    static final Builtin SYMBOL = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length == 1) {
                return new Boolean(args[0] instanceof Symbol);
            }
            throw new IllegalArgumentException();
        }
    };
    static final Builtin ERROR = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length == 1) {
                throw new IllegalArgumentException(args[0].toString());
            }
            throw new IllegalArgumentException();
        }
    };
    static final Builtin SET_CAR = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length != 2) {
                throw new IllegalArgumentException();
            }
            if (args[0] instanceof Cell) {
                ((Cell)args[0]).car = args[1];
                return LispAtto.UNDEF;
            }
            throw new IllegalArgumentException();
        }
    };
    static final Builtin SET_CDR = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length != 2) {
                throw new IllegalArgumentException();
            }
            if (args[0] instanceof Cell) {
                ((Cell)args[0]).cdr = args[1];
                return LispAtto.UNDEF;
            }
            throw new IllegalArgumentException();
        }
    };
    static final Builtin APPLY = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length != 2) {
                throw new IllegalArgumentException();
            }
            if (args[0] instanceof Appliable) {
                Object[] a = AttoUtils.toArray(args[1]);
                return ((Builtin)args[0]).apply(b, a);
            }
            throw new IllegalArgumentException();
        }
    };
    static final Builtin INC = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length != 1) {
                throw new IllegalArgumentException();
            }
            if (args[0] instanceof Integer) {
                int x = (Integer)args[0];
                return x < Integer.MAX_VALUE ? Integer.valueOf(x + 1) : MAXINT_1;
            }
            if (args[0] instanceof BigInteger) {
                return ((BigInteger)args[0]).add(BigInteger.ONE);
            }
            if (args[0] instanceof Number) {
                return new Double(((Number)args[0]).doubleValue() + 1.0);
            }
            throw new IllegalArgumentException(args[0].toString());
        }
    };
    static final Builtin DEC = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length != 1) {
                throw new IllegalArgumentException();
            }
            if (args[0] instanceof Integer) {
                int x = (Integer)args[0];
                return x > Integer.MIN_VALUE ? Integer.valueOf(x - 1) : MININT_1;
            }
            if (args[0] instanceof BigInteger) {
                return ((BigInteger)args[0]).subtract(BigInteger.ONE);
            }
            if (args[0] instanceof Number) {
                return new Double(((Number)args[0]).doubleValue() - 1.0);
            }
            throw new IllegalArgumentException();
        }
    };
    static final Builtin GT = new Builtin(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object apply(Callback b, Object ... args) {
            Integer pi = null;
            BigInteger pb = null;
            Double pd = null;
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (pi != null) {
                    if (o instanceof Integer) {
                        if (pi.compareTo((Integer)o) <= 0) return Boolean.FALSE;
                        pi = (Integer)o;
                    } else {
                        if (o instanceof BigInteger) {
                            return Boolean.FALSE;
                        }
                        if (!(o instanceof Double)) throw new IllegalArgumentException();
                        if (!(pi.doubleValue() > (Double)o)) return Boolean.FALSE;
                        pd = (Double)o;
                        pi = null;
                    }
                } else if (pb != null) {
                    if (o instanceof Integer) {
                        pi = (Integer)o;
                        pb = null;
                    } else if (o instanceof BigInteger) {
                        if (pb.compareTo((BigInteger)o) <= 0) return Boolean.FALSE;
                        pb = (BigInteger)o;
                    } else {
                        if (!(o instanceof Double)) throw new IllegalArgumentException();
                        if (!(pb.doubleValue() > (Double)o)) return Boolean.FALSE;
                        pd = (Double)o;
                        pb = null;
                    }
                } else if (pd != null) {
                    double d = pd;
                    if (!(o instanceof Number)) {
                        throw new IllegalArgumentException();
                    }
                    if (!(d > ((Number)o).doubleValue())) return Boolean.FALSE;
                    pd = new Double(((Number)o).doubleValue());
                    pb = null;
                    pi = null;
                } else if (o instanceof Integer) {
                    pi = (Integer)o;
                } else if (o instanceof BigInteger) {
                    pb = (BigInteger)o;
                } else {
                    if (!(o instanceof Double)) throw new IllegalArgumentException();
                    pd = (Double)o;
                }
                ++n2;
            }
            return Boolean.TRUE;
        }
    };
    static final Builtin LT = new Builtin(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object apply(Callback b, Object ... args) {
            Integer pi = null;
            BigInteger pb = null;
            Double pd = null;
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (pi != null) {
                    if (o instanceof Integer) {
                        if (pi.compareTo((Integer)o) >= 0) return Boolean.FALSE;
                        pi = (Integer)o;
                    } else if (o instanceof BigInteger) {
                        pb = BigInteger.valueOf(pi.intValue());
                        if (pb.compareTo((BigInteger)o) >= 0) return Boolean.FALSE;
                        pb = (BigInteger)o;
                        pi = null;
                    } else {
                        if (!(o instanceof Double)) throw new IllegalArgumentException();
                        if (!(pi.doubleValue() < (Double)o)) return Boolean.FALSE;
                        pd = (Double)o;
                        pi = null;
                    }
                } else if (pb != null) {
                    if (o instanceof Integer) {
                        return Boolean.FALSE;
                    }
                    if (o instanceof BigInteger) {
                        if (pb.compareTo((BigInteger)o) >= 0) return Boolean.FALSE;
                        pb = (BigInteger)o;
                    } else {
                        if (!(o instanceof Double)) throw new IllegalArgumentException();
                        if (!(pb.doubleValue() < (Double)o)) return Boolean.FALSE;
                        pd = (Double)o;
                        pb = null;
                    }
                } else if (pd != null) {
                    double d = pd;
                    if (!(o instanceof Number)) {
                        throw new IllegalArgumentException();
                    }
                    if (!(d < ((Number)o).doubleValue())) return Boolean.FALSE;
                    pd = new Double(((Number)o).doubleValue());
                    pb = null;
                    pi = null;
                } else if (o instanceof Integer) {
                    pi = (Integer)o;
                } else if (o instanceof BigInteger) {
                    pb = (BigInteger)o;
                } else {
                    if (!(o instanceof Double)) throw new IllegalArgumentException();
                    pd = (Double)o;
                }
                ++n2;
            }
            return Boolean.TRUE;
        }
    };
    static final Builtin EQN = new Builtin(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Object apply(Callback b, Object ... args) {
            Integer pi = null;
            BigInteger pb = null;
            Double pd = null;
            Number pn = null;
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                block23: {
                    Object o = objectArray[n2];
                    if (o instanceof Double) {
                        if (pn.doubleValue() != ((Number)o).doubleValue()) {
                            return Boolean.FALSE;
                        }
                    } else {
                        if (pi != null) {
                            if (o instanceof Integer) {
                                if (pi.compareTo((Integer)o) != 0) {
                                    return Boolean.FALSE;
                                }
                                break block23;
                            } else {
                                if (o instanceof BigInteger) {
                                    return Boolean.FALSE;
                                }
                                throw new IllegalArgumentException();
                            }
                        }
                        if (pb != null) {
                            if (o instanceof Integer) {
                                return Boolean.FALSE;
                            }
                            if (!(o instanceof BigInteger)) {
                                throw new IllegalArgumentException();
                            }
                            if (pb.compareTo((BigInteger)o) != 0) {
                                return Boolean.FALSE;
                            }
                        } else if (pd != null) {
                            double d = pd;
                            if (!(o instanceof Number)) {
                                throw new IllegalArgumentException();
                            }
                            if (d != ((Number)o).doubleValue()) {
                                return Boolean.FALSE;
                            }
                        } else {
                            if (o instanceof Integer) {
                                pi = (Integer)o;
                            } else if (o instanceof BigInteger) {
                                pb = (BigInteger)o;
                            } else {
                                if (!(o instanceof Double)) {
                                    throw new IllegalArgumentException();
                                }
                                pd = (Double)o;
                            }
                            pn = (Number)o;
                        }
                    }
                }
                ++n2;
            }
            return Boolean.TRUE;
        }
    };
    static final Builtin PLUS = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            BigInteger pb = null;
            Object pd = null;
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                BigInteger a;
                Object o = objectArray[n2];
                if (pb != null) {
                    a = AttoUtils.toBigInteger(o);
                    if (a != null) {
                        pb = pb.add(a);
                    } else {
                        pd = pb.doubleValue() + ((Number)o).doubleValue();
                        pb = null;
                    }
                } else if (pd != null) {
                    a = AttoUtils.toBigInteger(o);
                    pd = a != null ? Double.valueOf((Double)pd + a.doubleValue()) : Double.valueOf((Double)pd + ((Number)o).doubleValue());
                } else {
                    a = AttoUtils.toBigInteger(o);
                    if (a != null) {
                        pb = a;
                    } else {
                        pd = (Double)o;
                    }
                }
                ++n2;
            }
            return pd != null ? pd : (pb != null ? AttoUtils.toObject(pb) : new Integer(0));
        }
    };
    static final Builtin MINUS = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            BigInteger pb = null;
            Double pd = null;
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                BigInteger a;
                Object o = objectArray[n2];
                if (pb != null) {
                    a = AttoUtils.toBigInteger(o);
                    if (a != null) {
                        pb = pb.subtract(a);
                    } else {
                        pd = pb.doubleValue() - ((Number)o).doubleValue();
                        pb = null;
                    }
                } else if (pd != null) {
                    a = AttoUtils.toBigInteger(o);
                    pd = a != null ? Double.valueOf(pd - a.doubleValue()) : Double.valueOf(pd - ((Number)o).doubleValue());
                } else {
                    a = AttoUtils.toBigInteger(o);
                    if (a != null) {
                        pb = a;
                    } else {
                        pd = (Double)o;
                    }
                }
                ++n2;
            }
            if (args.length != 1) {
                return pd != null ? pd : (pb != null ? AttoUtils.toObject(pb) : new Integer(0));
            }
            if (pd != null) {
                return -pd.doubleValue();
            }
            return AttoUtils.toObject(pb.negate());
        }
    };
    static final Builtin MUL = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            BigInteger pb = null;
            Object pd = null;
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                BigInteger a;
                Object o = objectArray[n2];
                if (pb != null) {
                    a = AttoUtils.toBigInteger(o);
                    if (a != null) {
                        pb = pb.multiply(a);
                    } else {
                        pd = pb.doubleValue() * ((Number)o).doubleValue();
                        pb = null;
                    }
                } else if (pd != null) {
                    a = AttoUtils.toBigInteger(o);
                    pd = a != null ? Double.valueOf((Double)pd * a.doubleValue()) : Double.valueOf((Double)pd * ((Number)o).doubleValue());
                } else {
                    a = AttoUtils.toBigInteger(o);
                    if (a != null) {
                        pb = a;
                    } else {
                        pd = (Double)o;
                    }
                }
                ++n2;
            }
            return pd != null ? pd : (pb != null ? AttoUtils.toObject(pb) : new Integer(1));
        }
    };
    static final Builtin DIV = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            BigInteger pb = null;
            Double pd = null;
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                BigInteger a;
                Object o = objectArray[n2];
                if (pb != null) {
                    a = AttoUtils.toBigInteger(o);
                    if (a != null) {
                        pb = pb.divide(a);
                    } else {
                        pd = pb.doubleValue() / ((Number)o).doubleValue();
                        pb = null;
                    }
                } else if (pd != null) {
                    a = AttoUtils.toBigInteger(o);
                    pd = a != null ? Double.valueOf(pd / a.doubleValue()) : Double.valueOf(pd / ((Number)o).doubleValue());
                } else {
                    a = AttoUtils.toBigInteger(o);
                    if (a != null) {
                        pb = a;
                    } else {
                        pd = (Double)o;
                    }
                }
                ++n2;
            }
            if (args.length != 1) {
                return pd != null ? pd : (pb != null ? AttoUtils.toObject(pb) : new Integer(0));
            }
            if (pd != null) {
                return 1.0 / pd;
            }
            return 1.0 / pb.doubleValue();
        }
    };
    static final Builtin STRING = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length == 1) {
                return new Boolean(args[0] instanceof String);
            }
            throw new IllegalArgumentException();
        }
    };
    static final Builtin SUBSTRING = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length != 3) {
                throw new IllegalArgumentException();
            }
            if (args[1] instanceof Integer && args[2] instanceof Integer) {
                return args[0].toString().substring((Integer)args[1], (Integer)args[2]);
            }
            throw new IllegalArgumentException();
        }
    };
    static final Builtin STRING_REF = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length != 2) {
                throw new IllegalArgumentException();
            }
            if (args[1] instanceof Integer) {
                return new Character(args[0].toString().charAt((Integer)args[1]));
            }
            throw new IllegalArgumentException();
        }
    };
    static final Builtin STRING_LENGTH = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length != 1) {
                throw new IllegalArgumentException();
            }
            if (args[0] instanceof String) {
                return new Integer(args[0].toString().length());
            }
            throw new IllegalArgumentException();
        }
    };
    static final Builtin STRING_APPEND = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            StringBuffer a = new StringBuffer();
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                a.append(o.toString());
                ++n2;
            }
            return a.toString();
        }
    };
    static final Builtin STRING_SYMBOL = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length == 1) {
                return Symbol.get(args[0].toString());
            }
            throw new IllegalArgumentException();
        }
    };
    static final Builtin SYMBOL_STRING = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length != 1) {
                throw new IllegalArgumentException();
            }
            if (args[0] instanceof Symbol) {
                return ((Symbol)args[0]).getName();
            }
            throw new IllegalArgumentException();
        }
    };
    static final Builtin VECTOR = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length == 1) {
                return new Boolean(args[0] instanceof List);
            }
            throw new IllegalArgumentException();
        }
    };
    static final Builtin NUMBER_STRING = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length != 1) {
                throw new IllegalArgumentException();
            }
            if (args[0] instanceof Number) {
                return args[0].toString();
            }
            throw new IllegalArgumentException();
        }
    };
    static final Builtin PRINT = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length == 1) {
                System.out.println(args[0]);
                return LispAtto.UNDEF;
            }
            throw new IllegalArgumentException();
        }
    };
    static final Builtin DEBUG = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length == 1) {
                System.out.println(args[0]);
                return args[0];
            }
            throw new IllegalArgumentException();
        }
    };
    static final Builtin IDENTITY = new Builtin(){

        @Override
        public Object apply(Callback b, Object ... as) {
            if (as.length != 1) {
                throw new IllegalArgumentException();
            }
            return as[0];
        }
    };
    static final Appliable CALLCC = new Appliable(){

        @Override
        public Object apply(Callback b, Environment e, Object ... as) {
            if (as.length != 2) {
                throw new IllegalArgumentException();
            }
            if (as[1] instanceof Builtin) {
                return b.apply(e, as[0], as[1]);
            }
            if (as[1] instanceof Appliable) {
                final Appliable a = (Appliable)as[0];
                return b.apply(e, as[1], IDENTITY, new Appliable(){

                    @Override
                    public Object apply(Callback b, Environment e, Object ... args) {
                        if (args.length == 2) {
                            return b.apply(e, a, args[1]);
                        }
                        throw new IllegalArgumentException();
                    }
                });
            }
            throw new IllegalArgumentException();
        }
    };

    public static SimpleEngine getInstance() {
        return INSTANCE;
    }

    @Override
    public void init(Environment env) {
        env.binds.put(Symbol.get("cons"), CONS);
        env.binds.put(Symbol.get("eq?"), EQ);
        env.binds.put(Symbol.get("car"), CAR);
        env.binds.put(Symbol.get("cdr"), CDR);
        env.binds.put(Symbol.get("atom?"), ATOM);
        env.binds.put(Symbol.get("null?"), NULL);
        env.binds.put(Symbol.get("symbol?"), SYMBOL);
        env.binds.put(Symbol.get("error"), ERROR);
        env.binds.put(Symbol.get("eqv?"), EQV);
        env.binds.put(Symbol.get("set-car!"), SET_CAR);
        env.binds.put(Symbol.get("set-cdr!"), SET_CDR);
        env.binds.put(Symbol.get("apply"), APPLY);
        env.binds.put(Symbol.get("1+"), INC);
        env.binds.put(Symbol.get("1-"), DEC);
        env.binds.put(Symbol.get(">"), GT);
        env.binds.put(Symbol.get("<"), LT);
        env.binds.put(Symbol.get("="), EQN);
        env.binds.put(Symbol.get("+"), PLUS);
        env.binds.put(Symbol.get("-"), MINUS);
        env.binds.put(Symbol.get("*"), MUL);
        env.binds.put(Symbol.get("/"), DIV);
        env.binds.put(Symbol.get("string?"), STRING);
        env.binds.put(Symbol.get("substring"), SUBSTRING);
        env.binds.put(Symbol.get("string-ref"), STRING_REF);
        env.binds.put(Symbol.get("string-length"), STRING_LENGTH);
        env.binds.put(Symbol.get("string-append"), STRING_APPEND);
        env.binds.put(Symbol.get("string->symbol"), STRING_SYMBOL);
        env.binds.put(Symbol.get("symbol->string"), SYMBOL_STRING);
        env.binds.put(Symbol.get("vector?"), VECTOR);
        env.binds.put(Symbol.get("number->string"), NUMBER_STRING);
        env.binds.put(Symbol.get("print"), PRINT);
        env.binds.put(Symbol.get("debug"), DEBUG);
        env.binds.put(Symbol.get("call/cc"), CALLCC);
    }

    private void cpsbind(Environment env, String s, Appliable a) {
        env.binds.put(Symbol.get(s), new CPSWrapper(a));
    }

    @Override
    public void initCPS(Environment env) {
        this.cpsbind(env, "cons", CONS);
        this.cpsbind(env, "eq?", EQ);
        this.cpsbind(env, "car", CAR);
        this.cpsbind(env, "cdr", CDR);
        this.cpsbind(env, "atom?", ATOM);
        this.cpsbind(env, "null?", NULL);
        this.cpsbind(env, "symbol?", SYMBOL);
        this.cpsbind(env, "error", ERROR);
        this.cpsbind(env, "eqv?", EQV);
        this.cpsbind(env, "set-car!", SET_CAR);
        this.cpsbind(env, "set-cdr!", SET_CDR);
        this.cpsbind(env, "apply", APPLY);
        this.cpsbind(env, "1+", INC);
        this.cpsbind(env, "1-", DEC);
        this.cpsbind(env, ">", GT);
        this.cpsbind(env, "<", LT);
        this.cpsbind(env, "=", EQN);
        this.cpsbind(env, "+", PLUS);
        this.cpsbind(env, "-", MINUS);
        this.cpsbind(env, "*", MUL);
        this.cpsbind(env, "/", DIV);
        this.cpsbind(env, "string?", STRING);
        this.cpsbind(env, "substring", SUBSTRING);
        this.cpsbind(env, "string-ref", STRING_REF);
        this.cpsbind(env, "string-length", STRING_LENGTH);
        this.cpsbind(env, "string-append", STRING_APPEND);
        this.cpsbind(env, "string->symbol", STRING_SYMBOL);
        this.cpsbind(env, "symbol->string", SYMBOL_STRING);
        this.cpsbind(env, "vector?", VECTOR);
        this.cpsbind(env, "number->string", NUMBER_STRING);
        this.cpsbind(env, "print", PRINT);
        this.cpsbind(env, "debug", DEBUG);
        env.binds.put(Symbol.get("call/cc"), CALLCC);
    }

    @Override
    public Object find(Environment env, Object o) {
        Object p = env.find(o);
        if (p == null) {
            throw new IllegalArgumentException("unbound symbol: " + o);
        }
        return this.value(env, p);
    }

    @Override
    public Object value(Environment env, Object o) {
        return o;
    }

    @Override
    public Object apply(Environment v, Object g, Object ... args) {
        Object f = AttoTraverser.traverse(this, v, g);
        if (f instanceof Appliable) {
            Object[] z = new Object[args.length];
            int k = 0;
            while (k < args.length) {
                z[k] = AttoTraverser.traverse(this, v, args[k]);
                ++k;
            }
            return ((Appliable)f).apply(this, v, z);
        }
        throw new IllegalArgumentException(f.toString());
    }

    @Override
    public Object doIf(Environment v, Object cond, Object dotrue) {
        Object c = AttoTraverser.traverse(this, v, cond);
        return c.equals(Boolean.FALSE) ? LispAtto.UNDEF : AttoTraverser.traverse(this, v, dotrue);
    }

    @Override
    public Object doIf(Environment v, Object cond, Object dotrue, Object dofalse) {
        Object c = AttoTraverser.traverse(this, v, cond);
        return c.equals(Boolean.FALSE) ? AttoTraverser.traverse(this, v, dofalse) : AttoTraverser.traverse(this, v, dotrue);
    }

    @Override
    public Object doDefine(Environment v, Object sym, Object tobound) {
        if (sym instanceof Symbol) {
            v.binds.put((Symbol)sym, AttoTraverser.traverse(this, v, tobound));
            return LispAtto.UNDEF;
        }
        throw new IllegalArgumentException(sym.toString());
    }

    @Override
    public Object doLambda(Environment v, Object args, Object ... body) {
        return new Closure(v, args, body);
    }

    @Override
    public Object doSet(Environment v, Object sym, Object toset) {
        if (sym instanceof Symbol) {
            if (!v.set((Symbol)sym, AttoTraverser.traverse(this, v, toset))) {
                throw new IllegalArgumentException();
            }
            return LispAtto.UNDEF;
        }
        throw new IllegalArgumentException(sym.toString());
    }

    @Override
    public Object doBegin(Environment v, Object ... body) {
        Object r = LispAtto.UNDEF;
        Object[] objectArray = body;
        int n = body.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            r = AttoTraverser.traverse(this, v, o);
            ++n2;
        }
        return r;
    }

    @Override
    public Object doDelay(Environment env, Object a) {
        throw new UnsupportedOperationException();
    }
}

