package net.morilib.lisp.milia.web;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.Tag;

import net.morilib.lisp.atto.js.LispAttoJS;

public class LispTag implements BodyTag {

	//
//	private PageContext pageContext = null;
	private BodyContent bodyContent = null;
	private Tag parentTag = null;

	@Override
	public int doEndTag() throws JspException {
		return EVAL_PAGE;
	}

	@Override
	public int doStartTag() throws JspException {
		return EVAL_BODY_BUFFERED;
	}

	@Override
	public Tag getParent() {
		return parentTag;
	}

	@Override
	public void release() {
	}

	@Override
	public void setPageContext(PageContext p) {
//		this.pageContext = p;
	}

	@Override
	public void setParent(Tag parentTag) {
		this.parentTag = parentTag;
	}

	@Override
	public int doAfterBody() throws JspException {
		try{
			JspWriter jo = bodyContent.getEnclosingWriter();
			PrintWriter out = new PrintWriter(jo, true);

			out.println("<script type=\"text/javascript\">");
			LispAttoJS.outputJS(bodyContent.getReader(), out);
			out.println("</script>");
			out.flush();
		} catch(IOException e) {
			throw new JspException(e.getMessage());
		}
		return SKIP_BODY;
	}

	@Override
	public void doInitBody() throws JspException {
	}

	@Override
	public void setBodyContent(BodyContent b) {
		bodyContent = b;
	}

}
