/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

static data_1_1_t<float, float> g_exp2f_intel_data[] = {
  { // Entry 0
    0x1.ffffffffffffffffffffffffffffffffp-1,
    -0x1.p-149
  },
  { // Entry 1
    0x1.p-128,
    -0x1.p7
  },
  { // Entry 2
    0x1.fffe9d1c4b0f37f413d44c66c0481834p-129,
    -0x1.000002p7
  },
  { // Entry 3
    0x1.ae89930028efb7886635034db7054020p-1,
    -0x1.000160p-2
  },
  { // Entry 4
    0x1.ffa72300006e20fa0359c57f1b36a8e6p-1,
    -0x1.007ep-10
  },
  { // Entry 5
    0x1.f4f5d8ffcfec5e7b589aa48f5b5d9017p-1,
    -0x1.019ep-5
  },
  { // Entry 6
    0x1.1c0df9b94df3cdb41628976927bf54e5p-129,
    -0x1.01b330p7
  },
  { // Entry 7
    0x1.e9f0bd0139ec689f72fb67c4e2ca601cp-1,
    -0x1.0440p-4
  },
  { // Entry 8
    0x1.5effb0fffd19b4376d4e6ae2b16b3a21p-1,
    -0x1.16e0p-1
  },
  { // Entry 9
    0x1.d737a7fa4dbf2cfb6dba6ec6817ed03bp-2,
    -0x1.1ea8p0
  },
  { // Entry 10
    0x1.a4e5b30000f59daf40326c212c5a2fcbp-1,
    -0x1.2175bcp-2
  },
  { // Entry 11
    0x1.9f7f16feb25f3000d062055413068a97p-19,
    -0x1.24d228p4
  },
  { // Entry 12
    0x1.00063d164d3512a13946a9d4477d594fp-149,
    -0x1.29ffeep7
  },
  { // Entry 13
    0.0f,
    -0x1.2a0002p7
  },
  { // Entry 14
    0.0f,
    -0x1.2a0004p7
  },
  { // Entry 15
    0.0f,
    -0x1.2a14c0p7
  },
  { // Entry 16
    0.0f,
    -0x1.2c000ap7
  },
  { // Entry 17
    0x1.a0d9ecffff19d4152b82c660dc209a77p-1,
    -0x1.2fbad0p-2
  },
  { // Entry 18
    0x1.c6052f00589d4f803738f8fcf36fa00bp-1,
    -0x1.6318d0p-3
  },
  { // Entry 19
    0x1.f7cbf0fffe32af4dda01fb5554e5bdd5p-1,
    -0x1.7dc8e6p-6
  },
  { // Entry 20
    0x1.994b4f09b6ee04bdf5b421d4e95dd38ep-107,
    -0x1.a94ac2p6
  },
  { // Entry 21
    0x1.9768dd0bafc9d9b1a97a54711d499b74p-4,
    -0x1.aa326cp1
  },
  { // Entry 22
    0x1.d58197fb38fa3c1fe12e7ad59c08ff21p-8,
    -0x1.c7fffep2
  },
  { // Entry 23
    0x1.6d7a68b2e47d3110712df2595c91f23cp-1,
    -0x1.f207fep-2
  },
  { // Entry 24
    0x1.be9e93477301949016bc2c2b50bfe2cap-126,
    -0x1.f4c9d4p6
  },
  { // Entry 25
    0x1.d61027f7bae9f1964c205dfcbe3f4679p-1,
    -0x1.f8fe40p-4
  },
  { // Entry 26
    0x1.4c6fea0579dc794e989c3505e39be48fp-127,
    -0x1.fa7e04p6
  },
  { // Entry 27
    0x1.d5da00fff7fc53eb4fff78cd7d1f080bp-1,
    -0x1.fba72ap-4
  },
  { // Entry 28
    0x1.05c9d13b70cff2cde5f75b870dacca62p-127,
    -0x1.fbdef8p6
  },
  { // Entry 29
    0x1.d5d2f0fa1f23ba0b7a06c89cc0128f77p-1,
    -0x1.fbfffep-4
  },
  { // Entry 30
    0x1.ea5a64f56a7ba762fe38fe8eb4a9dd03p-1,
    -0x1.fe8c64p-5
  },
  { // Entry 31
    0x1.ea4cccf5323b8c4405f1a736e586738fp-1,
    -0x1.ffd40cp-5
  },
  { // Entry 32
    0x1.0026deff8e53c240976d296b38100d8ap-16,
    -0x1.fff8fep3
  },
  { // Entry 33
    0x1.ea4b39f81ba66804ecab3d71073e27b3p-1,
    -0x1.fff9fep-5
  },
  { // Entry 34
    0x1.007969bfdcbdfb3e58bdf333f53a3c1dp-128,
    -0x1.fffd44p6
  },
  { // Entry 35
    0x1.0056b360e5a2dfe9ee49875dd529e33bp-128,
    -0x1.fffe0cp6
  },
  { // Entry 36
    0x1.fff4e90010d7f0f5d5e88ed4851d1542p-1,
    -0x1.ffff7ep-14
  },
  { // Entry 37
    0x1.001154ba7ed485fbf804cd8280d4ca0fp-128,
    -0x1.ffff9cp6
  },
  { // Entry 38
    0x1.d58194f64f579173d9ee5d3c576ef523p-1,
    -0x1.ffffa6p-4
  },
  { // Entry 39
    0x1.f50767075372b29c5577b7a9610f8d69p-1,
    -0x1.ffffc2p-6
  },
  { // Entry 40
    0x1.6a09f2a8c76a7a3cfef0de81f2b79d8ep-1,
    -0x1.ffffcep-2
  },
  { // Entry 41
    0x1.ae89fed49903eff01fb8da20ee306a5ep-1,
    -0x1.ffffdcp-3
  },
  { // Entry 42
    0x1.00533afff5eeac6d2dc9023c0b872bdap1,
    0x1.0078p0
  },
  { // Entry 43
    0x1.6a4a9ea1370039bb654a21a808d42ea9p0,
    0x1.0084p-1
  },
  { // Entry 44
    0x1.6c0213db20e12d00b593e21b41ec6f7bp0,
    0x1.0401e0p-1
  },
  { // Entry 45
    0x1.6d7c62dea2f8a79892ffb0a423c8312dp0,
    0x1.07p-1
  },
  { // Entry 46
    0x1.02ea9d000ca7a3d1c9f2feff1d75d9e8p0,
    0x1.0bc2f0p-6
  },
  { // Entry 47
    0x1.78d0620424ed2002d0f36cb6012c092cp0,
    0x1.1d8cp-1
  },
  { // Entry 48
    0x1.8fbcc30b8a9d1ea185426ae7254fa29ap4,
    0x1.29256ap2
  },
  { // Entry 49
    0x1.39e44cfffffe38aff28704c732b540fdp0,
    0x1.2d2eb8p-2
  },
  { // Entry 50
    0x1.9394c50a159080ad377f98e1d382d21ap0,
    0x1.503cf0p-1
  },
  { // Entry 51
    0x1.96718703f6190777431ca8e9c8d1e441p0,
    0x1.557558p-1
  },
  { // Entry 52
    0x1.be25dcfffffde8b04e7c7b1baec7abdbp2,
    0x1.669390p1
  },
  { // Entry 53
    0x1.7ca40f0c7bdc8b5683fc0560c6159f18p24,
    0x1.892816p4
  },
  { // Entry 54
    0x1.2536aaffff141c8870e8d4c2352e92eap0,
    0x1.9103c2p-3
  },
  { // Entry 55
    0x1.7ca44ef297d9c32fe00db5598642e868p1,
    0x1.92819ep0
  },
  { // Entry 56
    0x1.000008ff47d7ee2ce82ae0bdaaa55772p0,
    0x1.9f5dc8p-21
  },
  { // Entry 57
    0x1.93cdf30bca3f1ccc6eeb23eb6545f0fdp6,
    0x1.aa14b2p2
  },
  { // Entry 58
    0x1.13252d0000f4b53775393a04dbee6cd3p0,
    0x1.aa2fc0p-4
  },
  { // Entry 59
    0x1.28eb540000c5e726057f3ee56612a843p0,
    0x1.b61f44p-3
  },
  { // Entry 60
    0x1.b5fead000022a86ec9bc4232da47f2fbp1,
    0x1.c65754p0
  },
  { // Entry 61
    0x1.de844cffff0b21e0a471e9d560a514cbp0,
    0x1.ce0ac0p-1
  },
  { // Entry 62
    0x1.000504ffff072985d71458d5d453850ep0,
    0x1.cf72b2p-14
  },
  { // Entry 63
    0x1.c1c278fffb6bc7da81e20c43aeb9ce92p1,
    0x1.d02174p0
  },
  { // Entry 64
    0x1.e1ae78ffff0000b5ca88867f54dcc891p0,
    0x1.d2e940p-1
  },
  { // Entry 65
    0x1.1535d3000000cd03211e77e8de4eb7d2p0,
    0x1.d65f1cp-4
  },
  { // Entry 66
    0x1.00051c0000007f998be0d45ef35f3d57p0,
    0x1.d7be2ep-14
  },
  { // Entry 67
    0x1.f294d4fffeba9ad4fe553bc197fac243p0,
    0x1.ec62p-1
  },
  { // Entry 68
    0x1.f294d4fffeba9ad4fe553bc197fac243p30,
    0x1.ef6310p4
  },
  { // Entry 69
    0x1.ea3cb509a95f60a5d4162ea7e476f787p3,
    0x1.f7faa0p1
  },
  { // Entry 70
    0x1.03343b47502c1f28eb63e7f42392c024p127,
    0x1.fc1260p6
  },
  { // Entry 71
    0x1.16fc8b0000c873958ce77b558bb04b77p0,
    0x1.fc1d68p-4
  },
  { // Entry 72
    0x1.69ea89000a943cbb444fe33ef6484b14p0,
    0x1.ff7ffep-2
  },
  { // Entry 73
    0x1.69f25d08c9bdef92b155047e4e2700f8p0,
    0x1.ff9ff2p-2
  },
  { // Entry 74
    0x1.ffef58078cd6d0d5f1fe65744c616496p3,
    0x1.fff9fep1
  },
  { // Entry 75
    0x1.fff37b0a5ebca011d756edb4d62e7666p7,
    0x1.fffdbep2
  },
  { // Entry 76
    0x1.fffe180726a04201907cd73f88488d80p31,
    0x1.ffffeap4
  },
  { // Entry 77
    0x1.00000000000000000000000000000b17p0,
    0x1.fffffcp-117
  },
  { // Entry 78
    0x1.6a09e667f3bcc908b2fb1366ea957d3ep-1,
    -0x1.p-1
  },
  { // Entry 79
    0x1.7b29357bbc48d2953781228b2e9ba474p-1,
    -0x1.bbbbbcp-2
  },
  { // Entry 80
    0x1.8d17d292bd084f608099344c40ba156ap-1,
    -0x1.777778p-2
  },
  { // Entry 81
    0x1.9fdf8b933e38a099e8b275aa655d720dp-1,
    -0x1.333334p-2
  },
  { // Entry 82
    0x1.b38aa517a000872460ce450b415297eep-1,
    -0x1.dddde0p-3
  },
  { // Entry 83
    0x1.c823e00b880a561008d5c1556a842a74p-1,
    -0x1.555558p-3
  },
  { // Entry 84
    0x1.ddb67fb66b77c35102ce41874e657eb6p-1,
    -0x1.99999ep-4
  },
  { // Entry 85
    0x1.f44e4f6ba2528a510e8a7cb8e11930bdp-1,
    -0x1.111118p-5
  },
  { // Entry 86
    0x1.05fbd4b8f440f2c1ccdb5cddeff66b41p0,
    0x1.11110cp-5
  },
  { // Entry 87
    0x1.125fbecf4bc054e03912db82366b6cb5p0,
    0x1.999998p-4
  },
  { // Entry 88
    0x1.1f59ac1b4b3e82b6e5a66ac50a8857dbp0,
    0x1.555554p-3
  },
  { // Entry 89
    0x1.2cf0b4f3b26e63c9d3cb40b4bae31586p0,
    0x1.dddddcp-3
  },
  { // Entry 90
    0x1.3b2c477e6e5f87fea4b02ead824f269ap0,
    0x1.333332p-2
  },
  { // Entry 91
    0x1.4a142bd74a641ce0ee908779b7d214fcp0,
    0x1.777776p-2
  },
  { // Entry 92
    0x1.59b088511d77ab47295346cb3a773b28p0,
    0x1.bbbbbap-2
  },
  { // Entry 93
    0x1.6a09e5ea7aa390dbf868b7278b744829p0,
    0x1.fffffep-2
  },
  { // Entry 94
    0x1.p48,
    0x1.80p5
  },
  { // Entry 95
    0x1.51cb5ca59853a1e54593c77e7eb8db83p48,
    0x1.833334p5
  },
  { // Entry 96
    0x1.bdb90b780b33357a359a52b9f7ce88d2p48,
    0x1.866668p5
  },
  { // Entry 97
    0x1.26115591f845278abb13016348ac2f38p49,
    0x1.89999cp5
  },
  { // Entry 98
    0x1.84066bd07579e097880a08553b47167ap49,
    0x1.8cccd0p5
  },
  { // Entry 99
    0x1.000058b91b5bc9ae2eed81e9b7d4cfacp50,
    0x1.900004p5
  },
  { // Entry 100
    0x1.51cbd1b7c03c121b017b7a63e5e7df2cp50,
    0x1.933338p5
  },
  { // Entry 101
    0x1.bdb9a5f1f180173634542f42d5122e11p50,
    0x1.96666cp5
  },
  { // Entry 102
    0x1.2611bb7c8fa36f3a6c96868064ca2d31p51,
    0x1.9999a0p5
  },
  { // Entry 103
    0x1.8406f24b3ca53ff6aff423c41ab06efap51,
    0x1.9cccd4p5
  },
  { // Entry 104
    0x1.p52,
    0x1.a0p5
  },
  { // Entry 105
    0x1.p-52,
    -0x1.a0p5
  },
  { // Entry 106
    0x1.51cb5ca59853a1e54593c77e7eb8db83p-52,
    -0x1.9cccccp5
  },
  { // Entry 107
    0x1.bdb90b780b33357a359a52b9f7ce88d2p-52,
    -0x1.999998p5
  },
  { // Entry 108
    0x1.26115591f845278abb13016348ac2f38p-51,
    -0x1.966664p5
  },
  { // Entry 109
    0x1.84066bd07579e097880a08553b47167ap-51,
    -0x1.933330p5
  },
  { // Entry 110
    0x1.000058b91b5bc9ae2eed81e9b7d4cfacp-50,
    -0x1.8ffffcp5
  },
  { // Entry 111
    0x1.51cbd1b7c03c121b017b7a63e5e7df2cp-50,
    -0x1.8cccc8p5
  },
  { // Entry 112
    0x1.bdb9a5f1f180173634542f42d5122e11p-50,
    -0x1.899994p5
  },
  { // Entry 113
    0x1.2611bb7c8fa36f3a6c96868064ca2d31p-49,
    -0x1.866660p5
  },
  { // Entry 114
    0x1.8406f24b3ca53ff6aff423c41ab06efap-49,
    -0x1.83332cp5
  },
  { // Entry 115
    0x1.p-48,
    -0x1.80p5
  },
  { // Entry 116
    HUGE_VALF,
    0x1.80p9
  },
  { // Entry 117
    0.0f,
    -0x1.c0p9
  },
  { // Entry 118
    HUGE_VALF,
    0x1.40p12
  },
  { // Entry 119
    0.0f,
    -0x1.60p12
  },
  { // Entry 120
    0x1.ffff4e8e06c7e8a2a84daed8ec56d6c3p127,
    0x1.fffffep6
  },
  { // Entry 121
    0x1.p-149,
    -0x1.2ap7
  },
  { // Entry 122
    0x1.fffe9d1c4b0f37f413d44c66c0481834p-129,
    -0x1.000002p7
  },
  { // Entry 123
    0x1.p-128,
    -0x1.p7
  },
  { // Entry 124
    0x1.000058b91b5bc9ae2eed81e9b7d4cfacp-128,
    -0x1.fffffep6
  },
  { // Entry 125
    0x1.ffff4e8e06c7e8a2a84daed8ec56d6c3p-65,
    -0x1.000002p6
  },
  { // Entry 126
    0x1.p-64,
    -0x1.p6
  },
  { // Entry 127
    0x1.00002c5c89d5ec6ca4d7c8acc017b7c9p-64,
    -0x1.fffffep5
  },
  { // Entry 128
    0x1.ffffa746fbb4062677bd0f506f391265p-33,
    -0x1.000002p5
  },
  { // Entry 129
    0x1.p-32,
    -0x1.p5
  },
  { // Entry 130
    0x1.0000162e43f4f831060e02d839a9d16dp-32,
    -0x1.fffffep4
  },
  { // Entry 131
    0x1.ffffd3a37bee075de43d49b9f60d05b0p-17,
    -0x1.000002p4
  },
  { // Entry 132
    0x1.p-16,
    -0x1.p4
  },
  { // Entry 133
    0x1.00000b1721bcfc99d9f890ea06911763p-16,
    -0x1.fffffep3
  },
  { // Entry 134
    0x1.ffffe9d1bd7c04bc4825147a8c0e63e3p-9,
    -0x1.000002p3
  },
  { // Entry 135
    0x1.p-8,
    -0x1.p3
  },
  { // Entry 136
    0x1.0000058b90cf1e6d97f9ca14dbcc1628p-8,
    -0x1.fffffep2
  },
  { // Entry 137
    0x1.fffff4e8de9f42a0cf11f7912ea17ee2p-5,
    -0x1.000002p2
  },
  { // Entry 138
    0x1.p-4,
    -0x1.p2
  },
  { // Entry 139
    0x1.000002c5c863b73f016468f6bac5ca2cp-4,
    -0x1.fffffep1
  },
  { // Entry 140
    0x1.fffffa746f47f160fcf890e3b801aeddp-3,
    -0x1.000002p1
  },
  { // Entry 141
    0x1.p-2,
    -0x1.p1
  },
  { // Entry 142
    0x1.00000162e430e5a18f6119e3c02282a5p-2,
    -0x1.fffffep0
  },
  { // Entry 143
    0x1.fffffd3a37a20cb4a12e24eaf25e3907p-2,
    -0x1.000002p0
  },
  { // Entry 144
    0x1.p-1,
    -0x1.p0
  },
  { // Entry 145
    0x1.000000b1721835514b86e6d96efd1bffp-1,
    -0x1.fffffep-1
  },
  { // Entry 146
    0x1.ffffa746fbb4062677bd0f506f391265p63,
    0x1.fffffep5
  },
  { // Entry 147
    0x1.p64,
    0x1.p6
  },
  { // Entry 148
    0x1.000058b91b5bc9ae2eed81e9b7d4cfacp64,
    0x1.000002p6
  },
  { // Entry 149
    0x1.ffffd3a37bee075de43d49b9f60d05b0p31,
    0x1.fffffep4
  },
  { // Entry 150
    0x1.p32,
    0x1.p5
  },
  { // Entry 151
    0x1.00002c5c89d5ec6ca4d7c8acc017b7c9p32,
    0x1.000002p5
  },
  { // Entry 152
    0x1.ffffe9d1bd7c04bc4825147a8c0e63e3p15,
    0x1.fffffep3
  },
  { // Entry 153
    0x1.p16,
    0x1.p4
  },
  { // Entry 154
    0x1.0000162e43f4f831060e02d839a9d16dp16,
    0x1.000002p4
  },
  { // Entry 155
    0x1.fffff4e8de9f42a0cf11f7912ea17ee2p7,
    0x1.fffffep2
  },
  { // Entry 156
    0x1.p8,
    0x1.p3
  },
  { // Entry 157
    0x1.00000b1721bcfc99d9f890ea06911763p8,
    0x1.000002p3
  },
  { // Entry 158
    0x1.fffffa746f47f160fcf890e3b801aeddp3,
    0x1.fffffep1
  },
  { // Entry 159
    0x1.p4,
    0x1.p2
  },
  { // Entry 160
    0x1.0000058b90cf1e6d97f9ca14dbcc1628p4,
    0x1.000002p2
  },
  { // Entry 161
    0x1.fffffd3a37a20cb4a12e24eaf25e3907p1,
    0x1.fffffep0
  },
  { // Entry 162
    0x1.p2,
    0x1.p1
  },
  { // Entry 163
    0x1.000002c5c863b73f016468f6bac5ca2cp2,
    0x1.000002p1
  },
  { // Entry 164
    0x1.fffffe9d1bd08b5b58ee4879a122966ep0,
    0x1.fffffep-1
  },
  { // Entry 165
    0x1.p1,
    0x1.p0
  },
  { // Entry 166
    0x1.00000162e430e5a18f6119e3c02282a5p1,
    0x1.000002p0
  },
  { // Entry 167
    0x1.6a09e56d018a842b90dd06c362fef7adp-1,
    -0x1.000002p-1
  },
  { // Entry 168
    0x1.6a09e667f3bcc908b2fb1366ea957d3ep-1,
    -0x1.p-1
  },
  { // Entry 169
    0x1.6a09e6e56cd62cb1c0a32dacee6c1513p-1,
    -0x1.fffffep-2
  },
  { // Entry 170
    0x1.ae89f9007697475c5ad3c1ca20c5ef35p-1,
    -0x1.000002p-2
  },
  { // Entry 171
    0x1.ae89f995ad3ad5e8734d1773205a7fbcp-1,
    -0x1.p-2
  },
  { // Entry 172
    0x1.ae89f9e0488cb092fcee839efbf3fc4cp-1,
    -0x1.fffffep-3
  },
  { // Entry 173
    0x1.d5818d7e5e53ccaf85be04f92de7e9bfp-1,
    -0x1.000002p-3
  },
  { // Entry 174
    0x1.d5818dcfba48725da05aeb66e0dca9f5p-1,
    -0x1.p-3
  },
  { // Entry 175
    0x1.d5818df86842ca7e21cae1385c97eb97p-1,
    -0x1.fffffep-4
  },
  { // Entry 176
    0x1.ea4af9ffce0251f017bdb97010c11824p-1,
    -0x1.000002p-4
  },
  { // Entry 177
    0x1.ea4afa2a490d9858f73a18f5db301f86p-1,
    -0x1.p-4
  },
  { // Entry 178
    0x1.ea4afa3f86933ceebf0b1d7e2966b3fbp-1,
    -0x1.fffffep-5
  },
  { // Entry 179
    0x1.f50765a12fbd6e767118fa02bcb3a0d1p-1,
    -0x1.000002p-5
  },
  { // Entry 180
    0x1.f50765b6e4540674f84b762862baff99p-1,
    -0x1.p-5
  },
  { // Entry 181
    0x1.f50765c1be9f52ce811823dc464b40d5p-1,
    -0x1.fffffep-6
  },
  { // Entry 182
    0x1.fa7c180ef0814846b01522e83717ad71p-1,
    -0x1.000002p-6
  },
  { // Entry 183
    0x1.fa7c1819e90d82e90a7e74b263c1dc06p-1,
    -0x1.p-6
  },
  { // Entry 184
    0x1.fa7c181f6553a05107e91b90eea42d9dp-1,
    -0x1.fffffep-7
  },
  { // Entry 185
    0x1.fd3c22b37338eec4260da36a7b7f5bf3p-1,
    -0x1.000002p-7
  },
  { // Entry 186
    0x1.fd3c22b8f71f10975ba4b32bcf3a5e12p-1,
    -0x1.p-7
  },
  { // Entry 187
    0x1.fd3c22bbb9122186b26b482799ce40c7p-1,
    -0x1.fffffep-8
  },
  { // Entry 188
    0x1.fe9d96afde6082f2254715efc5f6ad7ep-1,
    -0x1.000002p-8
  },
  { // Entry 189
    0x1.fe9d96b2a23d914a6037442fde31baf8p-1,
    -0x1.p-8
  },
  { // Entry 190
    0x1.fe9d96b4042c1877edacd889b36d1cd5p-1,
    -0x1.fffffep-9
  },
  { // Entry 191
    0x1.ff4eaca2d6b2175e4332494fb1c24589p-1,
    -0x1.000002p-9
  },
  { // Entry 192
    0x1.ff4eaca4391b5da33e743691f7298b12p-1,
    -0x1.p-9
  },
  { // Entry 193
    0x1.ff4eaca4ea5000c618347451421210cbp-1,
    -0x1.fffffep-10
  },
  { // Entry 194
    0x1.ffa74ea2d09c67341271213869921167p-1,
    -0x1.000002p-10
  },
  { // Entry 195
    0x1.ffa74ea381efc217a773f15c025f7c0dp-1,
    -0x1.p-10
  },
  { // Entry 196
    0x1.ffa74ea3da996f8989012938d02dddfep-1,
    -0x1.fffffep-11
  },
  { // Entry 197
    0x1.fff4e8fd29da44c6f05c4a5baf1c2bedp-1,
    -0x1.000002p-13
  },
  { // Entry 198
    0x1.fff4e8fd40080cc8471f25ef2480b00bp-1,
    -0x1.p-13
  },
  { // Entry 199
    0x1.fff4e8fd4b1ef0c8f2dcd0f35ca5afeep-1,
    -0x1.fffffep-14
  },
  { // Entry 200
    0x1.6a09e5ea7aa390dbf868b7278b744829p0,
    0x1.fffffep-2
  },
  { // Entry 201
    0x1.6a09e667f3bcc908b2fb1366ea957d3ep0,
    0x1.p-1
  },
  { // Entry 202
    0x1.6a09e762e5efbbd7217018250a3ab194p0,
    0x1.000002p-1
  },
  { // Entry 203
    0x1.306fe06e5a2f2e8c620f7e55cc803dbap0,
    0x1.fffffep-3
  },
  { // Entry 204
    0x1.306fe0a31b7152de8d5a46305c85edecp0,
    0x1.p-2
  },
  { // Entry 205
    0x1.306fe10c9df5b6efbd400b7806005fa9p0,
    0x1.000002p-2
  },
  { // Entry 206
    0x1.172b83afa4e77ab9fb14ed6d59000b58p0,
    0x1.fffffep-4
  },
  { // Entry 207
    0x1.172b83c7d517adcdf7c8c50eb14a7920p0,
    0x1.p-3
  },
  { // Entry 208
    0x1.172b83f835781a3f7a959adc6f517010p0,
    0x1.000002p-3
  },
  { // Entry 209
    0x1.0b5586c403bc8139197ebf6ce09ca7f8p0,
    0x1.fffffep-5
  },
  { // Entry 210
    0x1.0b5586cf9890f6298b92b71842a98364p0,
    0x1.p-4
  },
  { // Entry 211
    0x1.0b5586e6c239e18bc2c6e6800e1a354ep0,
    0x1.000002p-4
  },
  { // Entry 212
    0x1.059b0d2badb0e674d86f3abe58578c7dp0,
    0x1.fffffep-6
  },
  { // Entry 213
    0x1.059b0d31585743ae7c548eb68ca417fep0,
    0x1.p-5
  },
  { // Entry 214
    0x1.059b0d3cada3fe80087460f12b3f85d7p0,
    0x1.000002p-5
  },
  { // Entry 215
    0x1.02c9a3e4aa830d8834bdc95da605d425p0,
    0x1.fffffep-7
  },
  { // Entry 216
    0x1.02c9a3e778060ee6f7caca4f7a29bde9p0,
    0x1.p-6
  },
  { // Entry 217
    0x1.02c9a3ed130c11bbcdfd15f6cb45777ap0,
    0x1.000002p-6
  },
  { // Entry 218
    0x1.0163da9e4e61d5676fd32618f2719b20p0,
    0x1.fffffep-8
  },
  { // Entry 219
    0x1.0163da9fb33356d84a66ae336dcdfa40p0,
    0x1.p-7
  },
  { // Entry 220
    0x1.0163daa27cd659bfcb8505a08a66849ap0,
    0x1.000002p-7
  },
  { // Entry 221
    0x1.00b1afa4f9deabc72f2d49f63a281424p0,
    0x1.fffffep-9
  },
  { // Entry 222
    0x1.00b1afa5abcbed6129ab13ec11dc9544p0,
    0x1.p-8
  },
  { // Entry 223
    0x1.00b1afa70fa6709690a3abda4929ec25p0,
    0x1.000002p-8
  },
  { // Entry 224
    0x1.0058c86d48e8cd9376c92f8fe93335b6p0,
    0x1.fffffep-10
  },
  { // Entry 225
    0x1.0058c86da1c09ea1ff19d294cf2f679cp0,
    0x1.p-9
  },
  { // Entry 226
    0x1.0058c86e537040bf6c1a50920426e07fp0,
    0x1.000002p-9
  },
  { // Entry 227
    0x1.002c605e0228b5b870970538ff3283dcp0,
    0x1.fffffep-11
  },
  { // Entry 228
    0x1.002c605e2e8cec506d21bfc89a23a010p0,
    0x1.p-10
  },
  { // Entry 229
    0x1.002c605e875559807d4b02cd5ace5723p0,
    0x1.000002p-10
  },
  { // Entry 230
    0x1.00058ba01a2e49ed9aec7e37918c1a4ap0,
    0x1.fffffep-14
  },
  { // Entry 231
    0x1.00058ba01fb9f96d6cacd4b180917c3ep0,
    0x1.p-13
  },
  { // Entry 232
    0x1.00058ba02ad1586d1089c2dee94ea420p0,
    0x1.000002p-13
  },
  { // Entry 233
    0.0f,
    -0x1.2a0002p7
  },
  { // Entry 234
    0x1.p-149,
    -0x1.2ap7
  },
  { // Entry 235
    0x1.0000b17255775c040618bf4a4ade83fcp-149,
    -0x1.29fffep7
  },
  { // Entry 236
    0.0f,
    -0x1.2c0002p7
  },
  { // Entry 237
    0.0f,
    -0x1.2cp7
  },
  { // Entry 238
    0.0f,
    -0x1.2bfffep7
  },
  { // Entry 239
    HUGE_VALF,
    HUGE_VALF
  },
  { // Entry 240
    0.0,
    -HUGE_VALF
  },
  { // Entry 241
    HUGE_VALF,
    0x1.fffffep127
  },
  { // Entry 242
    0.0f,
    -0x1.fffffep127
  },
  { // Entry 243
    0x1.1a66390580a2c585f3de207decb2766dp3,
    0x1.921fb6p1
  },
  { // Entry 244
    0x1.d02319fe0cc8c798aae9bec1c301fce2p-4,
    -0x1.921fb6p1
  },
  { // Entry 245
    0x1.7c3f74a733d032aa52d1a81682e9aa9cp1,
    0x1.921fb6p0
  },
  { // Entry 246
    0x1.58b3935bc68e5b61b8988445da3312edp-2,
    -0x1.921fb6p0
  },
  { // Entry 247
    0x1.00000162e430e5a18f6119e3c02282a5p1,
    0x1.000002p0
  },
  { // Entry 248
    0x1.fffffd3a37a20cb4a12e24eaf25e3907p-2,
    -0x1.000002p0
  },
  { // Entry 249
    0x1.p1,
    0x1.p0
  },
  { // Entry 250
    0x1.p-1,
    -0x1.p0
  },
  { // Entry 251
    0x1.fffffe9d1bd08b5b58ee4879a122966ep0,
    0x1.fffffep-1
  },
  { // Entry 252
    0x1.000000b1721835514b86e6d96efd1bffp-1,
    -0x1.fffffep-1
  },
  { // Entry 253
    0x1.b93bbff5a7e572bcd51227c9b33976f0p0,
    0x1.921fb6p-1
  },
  { // Entry 254
    0x1.290ee65a6808cb3ac67a086b51909f9dp-1,
    -0x1.921fb6p-1
  },
  { // Entry 255
    0x1.00000000000000000000000000000002p0,
    0x1.p-126
  },
  { // Entry 256
    0x1.fffffffffffffffffffffffffffffffap-1,
    -0x1.p-126
  },
  { // Entry 257
    0x1.00000000000000000000000000000002p0,
    0x1.000002p-126
  },
  { // Entry 258
    0x1.fffffffffffffffffffffffffffffffap-1,
    -0x1.000002p-126
  },
  { // Entry 259
    0x1.00000000000000000000000000000002p0,
    0x1.fffffcp-127
  },
  { // Entry 260
    0x1.fffffffffffffffffffffffffffffffap-1,
    -0x1.fffffcp-127
  },
  { // Entry 261
    0x1.00000000000000000000000000000002p0,
    0x1.fffff8p-127
  },
  { // Entry 262
    0x1.fffffffffffffffffffffffffffffffap-1,
    -0x1.fffff8p-127
  },
  { // Entry 263
    0x1.p0,
    0x1.p-148
  },
  { // Entry 264
    0x1.ffffffffffffffffffffffffffffffffp-1,
    -0x1.p-148
  },
  { // Entry 265
    0x1.p0,
    0x1.p-149
  },
  { // Entry 266
    0x1.ffffffffffffffffffffffffffffffffp-1,
    -0x1.p-149
  },
  { // Entry 267
    0x1.p0,
    0.0f
  },
  { // Entry 268
    0x1.p0,
    -0.0f
  },
  { // Entry 269
    0x1.ffff4e8e06c7e8a2a84daed8ec56d6c3p127,
    0x1.fffffep6
  },
  { // Entry 270
    HUGE_VALF,
    0x1.p7
  },
  { // Entry 271
    0x1.p-126,
    -0x1.f8p6
  },
  { // Entry 272
    0x1.ffff4e8e06c7e8a2a84daed8ec56d6c3p-127,
    -0x1.f80002p6
  },
  { // Entry 273
    0x1.p125,
    0x1.f4p6
  },
  { // Entry 274
    0x1.p-125,
    -0x1.f4p6
  },
  { // Entry 275
    0x1.p2,
    0x1.p1
  },
  { // Entry 276
    0x1.p-2,
    -0x1.p1
  }
};
