/*
**  bif7b_a.c
**  bif-c
**
**  Created by Joel Rees on 2009/07/27.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIF7B/A, as mechanically as possible.
*/


#include "bif_m.h"
#include "bif_io.h" /* temporary, while we're patching things together. */
//#include "bif_vm.h"
//#include "bifst_a.h"
#include "bif7b_a.h"


/*
00010 * Include file for BIF
00020 * BIF Copyright 1989 Joel Matthew Rees (see BIF/ASM)
00030 *
04500 	FCC 'BIF'
04510 	FCB MIMM.OR.3
04520 	FCB MFORE
04530 	FDB QUIT-CFAOFF
04540 	FDB BIF+2 (PFA)
04550 	FDB COLON-CFAOFF
04560 	FDB IF-CFAOFF
*/
static character_t sBIF[] = "\x3" "BIF";
definition_header_s hBIF =
{	{ (natural_t) sBIF },
	{ MIMM },
	{ (natural_t) &hPHQUIT },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hCOLON },
	{ (natural_t) &hIF },
	{ (natural_t) XVOC }, 
	{	{ (natural_t) &hBIF }	}	/* &hBIF-CFAOFF (NFA) */
};
/*
04570 BIF	DOVOC
04580 	FDB BIF-CFAOFF (NFA)
04590 *
04600 	FCC 'ASSEMBLER'
04610 	FCB MIMM.OR.9 immediate?
04620 	FCB MFORE
04630 	FDB BIF-CFAOFF
04640 	FDB BIF+2 parent voc
04650 	FDB 0
04660 	FDB 0
*/
static character_t sASMBLR[] = "\x9" "ASSEMBLER";
definition_header_s hASMBLR = 
{	{ (natural_t) sASMBLR },
	{ MIMM },	/* immediate? */
	{ (natural_t) &hBIF },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XVOC },
	{	{ 0 }	}	/* Will be written to later. */
};
/*
04670 ASMBLR	DOVOC
04680 	FDB 0 (NFA)
04690 *
04700 	FCC 'DEFINITIONS'
04710 	FCB 11
04720 	FCB MFORE
04730 	FDB ASMBLR-CFAOFF
04740 	FDB BIF+2
04750 	FDB 0
04760 	FDB 0
*/
static character_t sDEFS[] = "\xb" "DEFINITIONS";
definition_header_s hDEFS = 
{	{ (natural_t) sDEFS },
	{ 0 },
	{ (natural_t) &hASMBLR },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) DEFS }
};
/*
04770 DEFS	LDX <UP
04780 	LDD UROOT,X
04790 	STD UDROOT,X
04800 	NEXT
04890 *
*/
void DEFS( void )
{	UP.task->definitionContextRoot = UP.task->searchContextRoot;
}


jmp_buf	abortBuffer;

static character_t sBIF_VERSION[] = "\x15" "(nee-6809) BIF-C V0.0" /* "\xd" "6809 BIF V1.0" */;
/*
04900 	FCC 'ABORT'
04910 	FCB 5
04920 	FCB MFORE
04930 	FDB DEFS-CFAOFF
04940 	FDB BIF+2
04950 	FDB 0
04960 	FDB 0
*/
static character_t sABORT[] = "\x5" "ABORT";
definition_header_s hABORT = 
{	{ (natural_t) sABORT },
	{ 0 },
	{ (natural_t) &hDEFS },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) ABORT },
/*
	{ (natural_t) XCOL },
04970 ABORT	DOCOL	see fig-FORTH model
04975 	FDB INULL
04980 	FDB SPSTO
04990 	FDB DEC
05000 	FDB ZERO
05010 	FDB DRIVE
05020 	FDB CR
05030 	FDB XDOTQ
05040 	FCB 13
05050 	FCC '6809 BIF V1.0'
05060 	FDB BIF
05070 	FDB DEFS
05080 	FDB QUIT
05090 *
	{
		{ (natural_t) &hINULL	},
		{ (natural_t) &hSPSTO	},
		{ (natural_t) &hDEC	},
		{ (natural_t) &hZERO	},
		{ (natural_t) &hDRIVE	},
		{ (natural_t) &hCR	},
		/ * Again, the in-line string problem tangled up with byte-order.
		{ (natural_t) &hXDOTQ	},
		{ '\xf\x36\x38\x30'	},
		{ '9 BI'	},
		{ 'F V1'	},
		{ '.0  '	}, 
		// Can't depend on where those end up, either, low justified or high,
		// meaning you have to pad, even if the byte order is right.
		* /
		{ (natural_t) &hLIT	},
		{ (natural_t) &sBIF_VERSION	},
		{ (natural_t) &hCOUNT	},
		{ (natural_t) &hTYPE	},
		{ (natural_t) &hBIF	},
		{ (natural_t) &hDEFS	},
		{ (natural_t) &hQUIT	}
	}
*/
};
void ABORT(void)	/* So that the real ABORT can be hidden and accessible "only" via longjmp(). */
{	longjmp( abortBuffer, ABORT_JMP_FLAG );
}
/* And this is the real ABORT:
*/
static character_t sPHABORT[] = "\x8" "(HABORT)";
definition_header_s hPHABORT = 
{	{ (natural_t) sPHABORT },
	{ MHID },
	{ (natural_t) &hABORT },
	{ MFORE },
	{ (natural_t) &hUTIL },
	{ (natural_t) 0 },
	{ (natural_t) &hPHQUIT },
	{ (natural_t) PHABORT }
};
void PHABORT(void)
{
#if defined DBG_TRACE_NEXT
if ( isTracing() )
{	dumpState( (char *) sPHABORT + 1 );
}
#endif
	setjmp( abortBuffer );	/* Do we care whether we came here via WARM or longjmp() ? Sort of, but how? */
	INULL();
	SPSTO();
	DEC();
	( * --SP ).integer = 0L;
	DRIVE();
	CR();
	( * --SP ).chString = sBIF_VERSION;
	COUNT();
	TYPE();
	mCALLdef( hBIF );
	DEFS();
	mCALLdef( hPHQUIT );	/* This should be the only "normal" call to QUIT, I think. */
}


/*
05100 	FCC 'VOCABULARY'
05110 	FCB 10
05120 	FCB MFORE
05130 	FDB ABORT-CFAOFF
05140 	FDB BIF+2
05150 	FDB 0
05160 	FDB 0
*/
static character_t sVOCAB[] = "\xa" "VOCABULARY";
definition_header_s hVOCAB = 
{	{ (natural_t) sVOCAB },
	{ 0 },
	{ (natural_t) &hPHABORT },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hVLIST },
	{ (natural_t) &hWARN },
	{ (natural_t) XCOL },
/*
05170 VOCAB	DOCOL
05180 	FDB CREATE
05190 	FDB IPCOM
05200 	DOVOC
05210 	FDB ZERO
05220 	FDB COMMA local
05255 	FDB SMUDGE
05260 	FDB SEMIS
05290 *
*/
	{
		{ (natural_t) &hCREATE	},
		{ (natural_t) &hIPCOM	},
		{ (natural_t) XVOC	},
		{ (natural_t) &hZERO	},
		{ (natural_t) &hCOMMA	},	/* local */
		{ (natural_t) &hSMUDGE	},
		{ (natural_t) &hSEMIS	},
	}
};


/*
05300 	FCC '('
05301 	FCB MIMM.OR.1
05302 	FCB 0
05303 	FDB VOCAB-CFAOFF
05304 	FDB BIF+2
05305 	FDB ENDHSH-CFAOFF
05306 	FDB STAR-CFAOFF
*/
static character_t sPAREN[] = "\x1" "(";
definition_header_s hPAREN = 
{	{ (natural_t) sPAREN },
	{ MIMM },
	{ (natural_t) &hVOCAB },
	{ MFORE },	/* MFORE? was 0 by mistake? */
	{ (natural_t) &hBIF },
	{ (natural_t) &hENDHSH },
	{ (natural_t) &hSTAR },
	{ (natural_t) PAREN }
};
/*
05310 PAREN	PSHS Y
05320 	LDY <UP
05330 PARENL	LDD #')
05340 	PSHU D
05350 	DOCOL
05360 	FDB WORD
05370 	FDB XMACH
05380 	LDX UBLK,Y
05390 	BNE *+6
05400 	LDX UTIB,Y
05401 	BRA *+12
05403 	PSHU X
05405 	DOCOL
05406 	FDB BLOCK get adr
05408 	FDB XMACH
05409 	PULU X
05410 	LDD UIN,Y
05420 	LDA D,X
05425 	BEQ PARENE NUL?
05430 	CMPA #')
05440 	BNE PARENL
05450 	INCB	bump
05453 	BNE *+5 UIN>15	// Why did I abhor labels so? (size of opcode INC UIN,Y)
05456 	INC UIN,Y carry
05460 	STB UIN+1,Y
05470 PARENE	PULS Y
05480 	NEXT
05490 *
*/
void PAREN( void )
{	cell_u	x;
	natural_t	ch;
	for ( ;; )
	{	( * --SP ).integer = ')';
//#if defined DBG_WORD_PARSE
//printf( "parsing for paren, active block == %p tib == %p\n", 
//	UP.task->activeDiscBlock.bytep, UP.task->terminalInputBuffer.bytep );
//#endif
		mCALLdef( hWORD );
		x = UP.task->activeDiscBlock;
		if ( x.integer == 0 )
		{	x = UP.task->terminalInputBuffer;
		}
		else
		{	( * --SP ) = x;
			mCALLdef( hBLOCK );
			x = ( * SP++ );
		}
//#if defined DBG_WORD_PARSE
//printf( "in paren, stopped at (%p) %p + %ld == %p stack:%p stack[ -1 ] == %lx\n", x.bytep,
//	x.chString, UP.task->bufferInputOffset.integer, x.chString + UP.task->bufferInputOffset.integer, 
//	SP, SP[ -1 ].integer );
//#endif
		ch = * ( x.chString + UP.task->bufferInputOffset.integer );
//#if defined DBG_WORD_PARSE
//printf( "character is %c (%02lx)\n", (unsigned char) ch, ch );
//#endif
		if ( ch == '\0' )
		{	break;
		}
		if ( ch == ')' )
		{	++UP.task->bufferInputOffset.integer;
			break;
		}
	}
//#if defined DBG_WORD_PARSE
//printf( "parsing for paren, found %c (%02lx)\n", (unsigned char) ch, ch );
//#endif
}


/*
05500 	FCC 'DAD'
05510 	FCB 3
05520 	FCB MFORE
05530 	FDB PAREN-CFAOFF
05540 	FDB BIF+2
05550 	FDB 0
05560 	FDB DCON-CFAOFF
*/
static character_t sDAD[] = "\x3" "DAD";
definition_header_s hDAD = 
{	{ (natural_t) sDAD },
	{ 0 },
	{ (natural_t) &hPAREN },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ (natural_t) &hDCON },
	{ (natural_t) DAD }
};
/*
05570 DAD	PSHS Y
05580 	PULU Y nfa
05590 	LDB ,Y
05600 	ANDB #NLMASK
05610 	TFR B,A
05620 	NEGA
05630 	LEAX A,Y name
05640 	DECA for NUL
05650 	LEAS A,S allocate
05660 	CLRA
05670 	STA B,S NUL
05680 	PSHU X
05690 	PSHU D,S
05700 	PSHS B,X mark
05710 	DOCOL
05720 	FDB CMOVE for (REFIND)
05730 	FDB XMACH
05740 	LEAX 3,S name
05750 	PSHU X
05760 	LDX GFAOFF,Y
05770 	PSHU X
05780 DADL	DOCOL
05790 	FDB PREF
05800 	FDB XMACH
05810 	LDX [2,U]
05820 	BNE DADC
05830 	LDD #$19 not found
05840 	PSHU D
05850 	JMP ERROR
05860 DADC	CMPY [2,U] this node?
05870 	BEQ DADR
05880 	LEAX RTOFF,X deeper
05890 	LEAU 2,U
05900 	STX ,U
05910 	BRA DADL
05920 DADR	PULS B,X
05930 	STX 4,U
05950 	INCB for NUL
05960 	LEAS B,S drop name
05970 	PULS Y
05980 	NEXT
05990 *
*/
void DAD( void )
{	definition_header_s * definition = SP[ 0 ].definitionp;
	definition_header_s * found;
	character_t * nulTName = definition->nameLink.chString + 1;
	SP[ 0 ].chString = nulTName;
	( * --SP ).cellp = ( definition->vocabLink ).definitionp->parameterLink;
	for ( ;; )
	{	mCALLdef( hPREF );
		found = ( * SP[ 1 ].cellp ).definitionp;
		if ( found == (definition_header_s *) 0 )
			mERROR( DEFINITION_NOT_IN_VOCABULARY );
		if ( found == definition )
		{	break;
		}
		++SP;
		SP[ 0 ].cellp = &( definition->rightLink );	/* hidden definitions are lexically left of what hid them. */
	}
	SP[ 2 ].bytep = definition->nameLink.bytep;
}


/*
20500 	FCC 'REPEAL'
20510 	FCB 6
20520 	FCB MFORE
20530 	FDB DAD-CFAOFF
20540 	FDB BIF+2
20550 	FDB 0
20560 	FDB 0
*/
static character_t sREPEAL[] = "\x6" "REPEAL";
definition_header_s hREPEAL = 
{	{ (natural_t) sREPEAL },
	{ 0 },
	{ (natural_t) &hDAD },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) REPEAL }
};
/*
20570 REPEAL	PSHS Y
20580 	LDX <UP
20590 	LDY UCURR,X
20592 	CMPY UFENCE,X
20594 	BLS REPELX
20600 	LDD LFAOFF,Y
20610 	STD UCURR,X update
20620 	LDD GFAOFF,Y  stash
20625 	PSHU Y
20630 	LEAY PFAOFF,Y
20640 	CMPY UROOT,X
20650 	BNE REPELD
20660 	STD UROOT,X
20670 REPELD	CMPY UDROOT,X
20680 	BNE REPELF
20690 	STD UDROOT,X
20700 REPELF	LDY ,U
20710 	LDD #0
20720 	CMPY UFORE,X end?
20730 	BNE REPELA
20740 	STD UFORE,X
20750 REPELA	DOCOL
20760 	FDB DAD
20760 	FDB XMACH
20770 	LEAU 2,U
20960 	LDD #0
20970 	STD [,U++] ground parent
20980 	PULU D
20990 	LDX <UP
21000 	STD UDP,X
21010 REPELX	PULS Y
21020 	NEXT
21090 *
*/
void REPEAL( void )
{	cell_u definition = UP.task->lastDefined;
	if ( ( definition.bytep < UP.task->forgetFence.bytep ) || ( definition.bytep >= ( memoryImage + ILIM ) ) )
	{	return;
	}
	UP.task->lastDefined = definition.definitionp->allocLink;
	if ( UP.task->searchContextRoot.cellp == definition.definitionp->parameterLink )
	{	UP.task->searchContextRoot.cellp = ( * definition.definitionp->vocabLink.definitionp ).parameterLink;
	}
	if ( UP.task->definitionContextRoot.cellp == definition.definitionp->parameterLink )
	{	UP.task->definitionContextRoot.cellp = ( * definition.definitionp->vocabLink.definitionp ).parameterLink;
	}
	if ( UP.task->forewardBlock.definitionp == definition.definitionp )
	{	UP.task->forewardBlock.definitionp = (definition_header_s *) 0;
	}
	( * --SP ) = definition;
	mCALLdef( hDAD );
	++SP;
	( * ( * SP++ ).cellp ).definitionp = (definition_header_s *) 0;	/* Clear out the child link to this one. */
	UP.task->dictionaryAllocationPointer = ( * SP++ );
}


/*
21100 	FCC 'FORGET'
21110 	FCB 6
21120 	FCB MFORE
21130 	FDB REPEAL-CFAOFF
21140 	FDB BIF+2
21150 	FDB FORE-CFAOFF
21160 	FDB GFA-CFAOFF
*/
static cell_u aFORGET[];
static character_t sFORGET[] = "\x6" "FORGET";
definition_header_s hFORGET =
{	{ (natural_t) sFORGET },
	{ 0 },
	{ (natural_t) &hREPEAL },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hFORE },
	{ (natural_t) &hGFA },
	{ (natural_t) XCOL }, 
	{ { (natural_t) FORGET } }
};
/*
21170 FORGET	DOCOL
21180 	FDB DDFIND
21190 	FDB XMACH
21200 	PSHS Y
21210 	LEAU 2,U
21220 	LDY ,U++
21230 	BNE FORGEF found?
21240 	LDD #0
21250 	PSHU D
21260 	JMP ERROR
21270 FORGEF	LDX <UP
21280 	CMPY UFENCE,X
21290 	BHI FORGER
21300 	LDD #$15
21310 	BRA FORGEF-5
21320 FORGER	LDB MFAOFF,Y
21330 	ANDB #MFORE
21370 	BEQ FORGEL
21380 	LDD #$1A
21390 	BRA FORGEF-5
21400 FORGEL	LDX <UP
21410 	CMPY UCURR,X
21420 	BHS FORGEO
21430 	DOCOL
21440 	FDB REPEAL
21450 	FDB XMACH
21460 	BRA FORGEL
21470 FORGEO	BEQ FORGEN
21480 	LDD #$1B
21490 	BRA FORGEF-5
21500 FORGEN	PULS Y
21510 	JMP REPEAL
*/
void FORGET( void )
{	cell_u definition;
	mCALLdef( hDDFIND );	/* ( --- nfa vocptr ) */
	SP++;
	definition = ( * SP++ );
	if ( definition.definitionp == (definition_header_s *) 0 )
		mERROR( 0L );	/* Is zero the right message? */
	if ( definition.bytep <= UP.task->forgetFence.bytep )
		mERROR( IN_PROTECTED_DICTIONARY );
	if ( definition.definitionp->interpMode.integer & MFORE )
		mERROR( IN_FORWARD_BLOCK );
	for ( ;; )
	{	if ( definition.bytep > UP.task->lastDefined.bytep )
		{	mERROR( ALLOCATION_LIST_CORRUPTED__LOST );
		}
		else if ( definition.bytep == UP.task->lastDefined.bytep )
		{	mCALLdef( hREPEAL );
			break;
		}
		mCALLdef( hREPEAL );
	}
}


/*
21520 FOLLOW	EQU *
21530 * FORGET should be the last definition in the pre-assembled kernel
21540 *
*/
