/*
**  bif_ioex.c
**  bif-c
**
**  Created by Joel Rees on 2014/03/20.
**  Copyright 2014 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIFB/A, as mechanically as possible.
*/


// #include <stddef.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>


#include "bif_eval.h"
#include "bif_m.h"
#include "bifst_a.h"	/* for break_pressed() */
#include "bif_ex.h"


static character_t sEXTENSIONS[] = "\x0a" "EXTENSIONS";
definition_header_s hEXTENSIONS =
{	{ (natural_t) sEXTENSIONS },
	{ MIMM },
	{ (natural_t) &LASTinIO },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XVOC }, 
	{	{ (natural_t) &hEMIT_LEDS }	}
};


static int led_fd = -1;

static character_t sOPEN_LEDS[] = "\x9" "OPEN_LEDS";
definition_header_s hOPEN_LEDS =	
{	{ (natural_t) sOPEN_LEDS },
	{ 0 },
	{ (natural_t) &hEXTENSIONS },
	{ MFORE },
	{ (natural_t) &hEXTENSIONS },
	{ 0 },
	{ 0 },
	{ (natural_t) OPEN_LEDS }
};
/*
OPEN_LEDS    ( --- )
//      Open the unit LEDs device for R/W. 
//
//      This is not the way to do this, but we will do it for now.
*/
void OPEN_LEDS(void)	/* Temporary code to just get output, for now. */
{
	led_fd = open( "/dev/dio104_led", O_RDWR );
	if ( led_fd == -1 )
	{	perror( "Opening LEDS failed!" );
	}
}

static character_t sCLOSE_LEDS[] = "\x0a" "CLOSE_LEDS";
definition_header_s hCLOSE_LEDS =	
{	{ (natural_t) sCLOSE_LEDS },
	{ 0 },
	{ (natural_t) &hOPEN_LEDS },
	{ MFORE },
	{ (natural_t) &hEXTENSIONS },
	{ 0 },
	{ 0 },
	{ (natural_t) CLOSE_LEDS }
};
/*
CLOSE_LEDS    ( --- )
//      CLose the unit LEDs device. 
//
//      This is not the way to do this, but we will do it for now.
*/
void CLOSE_LEDS(void)	/* Temporary code to just get output, for now. */
{
	if ( close( led_fd ) == -1 )
	{	perror( "Closing LEDS failed!!" );
	}
}


static character_t sEMIT_LEDS[] = "\x9" "EMIT_LEDS";
definition_header_s hEMIT_LEDS =	
{	{ (natural_t) sEMIT_LEDS },
	{ 0 },
	{ (natural_t) &hCLOSE_LEDS },
	{ MFORE },
	{ (natural_t) &hEXTENSIONS },
	{ 0 },
	{ 0 },
	{ (natural_t) EMIT_LEDS }
};
/*
EMIT_LEDS    ( c --- )
//      Write c to the unit LEDs. 
//
//      This is not the way to do this, but we will do it for now.
*/
void EMIT_LEDS(void)	/* Temporary code to just get output, for now. */
{
	char ch = (byte_t) ( * SP++ ).integer;
	if ( write( led_fd, &ch, 1 ) != 1 )
	{	perror( "Problem writing to LEDS!!" );
	}
}


static character_t sREAD_LEDS[] = "\x9" "READ_LEDS";
definition_header_s hREAD_LEDS =	
{	{ (natural_t) sREAD_LEDS },
	{ 0 },
	{ (natural_t) &hEMIT_LEDS },
	{ MFORE },
	{ (natural_t) &hEXTENSIONS },
	{ 0 },
	{ 0 },
	{ (natural_t) READ_LEDS }
};
/*
READ_LEDS    ( --- c )
//      Get the current value of the unit LEDs. 
//
//      This is not the way to do this, but we will do it for now.
*/
void READ_LEDS(void)	/* Temporary code to just get input, for now. */
{
	char ch = 0;
	if ( read( led_fd, &ch, 1 ) != 1 )
	{	perror( "Problem reading LEDS!!" );
	}
	( * --SP ).integer = ch;
}


static int sw_fd = -1;

static character_t sOPEN_SWS[] = "\x8" "OPEN_SWS";
definition_header_s hOPEN_SWS =	
{	{ (natural_t) sOPEN_SWS },
	{ 0 },
	{ (natural_t) &hREAD_LEDS },
	{ MFORE },
	{ (natural_t) &hEXTENSIONS },
	{ 0 },
	{ 0 },
	{ (natural_t) OPEN_SWS }
};
/*
OPEN_SWS    ( --- )
//      Open the unit SWs device for READing:
//
//      This is not the way to do this, but we will do it for now.
*/
void OPEN_SWS(void)	/* Temporary code to just get input, for now. */
{
	sw_fd = open( "/dev/dio104_sw", O_RDONLY );
	if ( sw_fd == -1 )
	{	perror( "Opening SWs failed!" );
	}
}

static character_t sOPEN_SWSNBF[] = "\x0b" "OPEN_SWSNBF";
definition_header_s hOPEN_SWSNBF =	
{	{ (natural_t) sOPEN_SWSNBF },
	{ 0 },
	{ (natural_t) &hOPEN_SWS },
	{ MFORE },
	{ (natural_t) &hEXTENSIONS },
	{ 0 },
	{ 0 },
	{ (natural_t) OPEN_SWSNBF }
};
/*
OPEN_SWSNBF    ( flag --- )
//      Open the unit SWs device for READing, with Non-Blocking Flag:
//           flag == 0 => blocking 
//           flag != 0 => non-blocking 
//
//      This is not the way to do this, but we will do it for now.
*/
void OPEN_SWSNBF(void)	/* Temporary code to just get input, for now. */
{
	natural_t flag = ( * SP++ ).integer;

	sw_fd = open( "/dev/dio104_sw", O_RDONLY | ( flag ? O_NONBLOCK : 0 ) );
	if ( sw_fd == -1 )
	{	perror( "Opening SWs failed!" );
	}
}

static character_t sCLOSE_SWS[] = "\x9" "CLOSE_SWS";
definition_header_s hCLOSE_SWS =	
{	{ (natural_t) sCLOSE_SWS },
	{ 0 },
	{ (natural_t) &hOPEN_SWSNBF },
	{ MFORE },
	{ (natural_t) &hEXTENSIONS },
	{ 0 },
	{ 0 },
	{ (natural_t) CLOSE_SWS }
};
/*
CLOSE_SWS    ( --- )
//      CLose the unit SWS device. 
//
//      This is not the way to do this, but we will do it for now.
*/
void CLOSE_SWS(void)	/* Temporary code to just get input, for now. */
{
	if ( close( sw_fd ) == -1 )
	{	perror( "Closing SWs failed!!" );
	}
}


static character_t sREAD_SWS[] = "\x8" "READ_SWS";
definition_header_s hREAD_SWS =	
{	{ (natural_t) sREAD_SWS },
	{ 0 },
	{ (natural_t) &hCLOSE_SWS },
	{ MFORE },
	{ (natural_t) &hEXTENSIONS },
	{ 0 },
	{ 0 },
	{ (natural_t) READ_SWS }
};
/*
READ_SWS    ( --- c )
//      Get the current value of the unit SWs. 
//
//      This is not the way to do this, but we will do it for now.
*/
void READ_SWS(void)	/* Temporary code to just get output, for now. */
{
	char ch = 0;
	if ( read( sw_fd, &ch, 1 ) != 1 )
	{	perror( "Problem reading SWs!!" );
	}
	( * --SP ).integer = ch;
}


static int seg7_fd = -1;

static character_t sOPEN_7SEGS[] = "\x0a" "OPEN_7SEGS";
definition_header_s hOPEN_7SEGS =	
{	{ (natural_t) sOPEN_7SEGS },
	{ 0 },
	{ (natural_t) &hREAD_SWS },
	{ MFORE },
	{ (natural_t) &hEXTENSIONS },
	{ 0 },
	{ 0 },
	{ (natural_t) OPEN_7SEGS }
};
/*
OPEN_7SEGS    ( --- )
//      Open the seven segment device for R/W. 
//
//      This is not the way to do this, but we will do it for now.
*/
void OPEN_7SEGS(void)	/* Temporary code to just get output, for now. */
{
	seg7_fd = open( "/dev/dio104_7seg", O_RDWR );
	if ( seg7_fd == -1 )
	{	perror( "Opening seven segment failed!" );
	}
}

static character_t sCLOSE_7SEGS[] = "\x0b" "CLOSE_7SEGS";
definition_header_s hCLOSE_7SEGS =	
{	{ (natural_t) sCLOSE_7SEGS },
	{ 0 },
	{ (natural_t) &hOPEN_7SEGS },
	{ MFORE },
	{ (natural_t) &hEXTENSIONS },
	{ 0 },
	{ 0 },
	{ (natural_t) CLOSE_7SEGS }
};
/*
CLOSE_7SEGS    ( --- )
//      CLose the seven segment device. 
//
//      This is not the way to do this, but we will do it for now.
*/
void CLOSE_7SEGS(void)	/* Temporary code to just get output, for now. */
{
	if ( close( seg7_fd ) == -1 )
	{	perror( "Closing seven segment failed!!" );
	}
}


static character_t sEMIT_7SEGS[] = "\x0a" "EMIT_7SEGS";
definition_header_s hEMIT_7SEGS =	
{	{ (natural_t) sEMIT_7SEGS },
	{ 0 },
	{ (natural_t) &hCLOSE_7SEGS },
	{ MFORE },
	{ (natural_t) &hEXTENSIONS },
	{ 0 },
	{ 0 },
	{ (natural_t) EMIT_7SEGS }
};
/*
EMIT_7SEGS    ( c --- )
//      Write c to the seven segment. 
//
//      This is not the way to do this, but we will do it for now.
*/
void EMIT_7SEGS(void)	/* Temporary code to just get output, for now. */
{
	char ch = (byte_t) ( * SP++ ).integer;
	if ( write( seg7_fd, &ch, 1 ) != 1 )
	{	perror( "Problem writing to seven segment!!" );
	}
}


static character_t sREAD_7SEGS[] = "\x0a" "READ_7SEGS";
definition_header_s hREAD_7SEGS =	
{	{ (natural_t) sREAD_7SEGS },
	{ 0 },
	{ (natural_t) &hEMIT_7SEGS },
	{ MFORE },
	{ (natural_t) &hEXTENSIONS },
	{ 0 },
	{ 0 },
	{ (natural_t) READ_7SEGS }
};
/*
READ_7SEGS    ( --- c )
//      Get the current value of the seven segment. 
//
//      This is not the way to do this, but we will do it for now.
*/
void READ_7SEGS(void)	/* Temporary code to just get input, for now. */
{
	char ch = 0;
	if ( read( seg7_fd, &ch, 1 ) != 1 )
	{	perror( "Problem reading seven segment!!" );
	}
	( * --SP ).integer = ch;
}


static int lcd_fd = -1;

static character_t sOPEN_LCD[] = "\x8" "OPEN_LCD";
definition_header_s hOPEN_LCD =	
{	{ (natural_t) sOPEN_LCD },
	{ 0 },
	{ (natural_t) &hREAD_7SEGS },
	{ MFORE },
	{ (natural_t) &hEXTENSIONS },
	{ 0 },
	{ 0 },
	{ (natural_t) OPEN_LCD }
};
/*
OPEN_LCD    ( --- )
//      Open the LCD device for R/W. 
//
//      This is not the way to do this, but we will do it for now.
*/
void OPEN_LCD(void)	/* Temporary code to just get output, for now. */
{
	lcd_fd = open( "/dev/dio104_lcd", O_RDWR );
	if ( lcd_fd == -1 )
	{	perror( "Opening LCD failed!" );
	}
}

static character_t sCLOSE_LCD[] = "\x09" "CLOSE_LCD";
definition_header_s hCLOSE_LCD =	
{	{ (natural_t) sCLOSE_LCD },
	{ 0 },
	{ (natural_t) &hOPEN_LCD },
	{ MFORE },
	{ (natural_t) &hEXTENSIONS },
	{ 0 },
	{ 0 },
	{ (natural_t) CLOSE_LCD }
};
/*
CLOSE_LCD    ( --- )
//      CLose the LCD device. 
//
//      This is not the way to do this, but we will do it for now.
*/
void CLOSE_LCD(void)	/* Temporary code to just get output, for now. */
{
	if ( close( lcd_fd ) == -1 )
	{	perror( "Closing LCD failed!!" );
	}
}


static character_t sEMIT_LCD[] = "\x8" "EMIT_LCD";
definition_header_s hEMIT_LCD =	
{	{ (natural_t) sEMIT_LCD },
	{ 0 },
	{ (natural_t) &hCLOSE_LCD },
	{ MFORE },
	{ (natural_t) &hEXTENSIONS },
	{ 0 },
	{ 0 },
	{ (natural_t) EMIT_LCD }
};
/*
EMIT_LCD    ( c --- )
//      Write c to the LCD. 
//
//      This is not the way to do this, but we will do it for now.
*/
void EMIT_LCD(void)	/* Temporary code to just get output, for now. */
{
	char ch = (byte_t) ( * SP++ ).integer;
	if ( write( lcd_fd, &ch, 1 ) != 1 )
	{	perror( "Problem writing to LCD!!" );
	}
}


static character_t sTYPE_LCD[] = "\x8" "TYPE_LCD";
definition_header_s hTYPE_LCD =	
{	{ (natural_t) sTYPE_LCD },
	{ 0 },
	{ (natural_t) &hEMIT_LCD },
	{ MFORE },
	{ (natural_t) &hEXTENSIONS },
	{ 0 },
	{ 0 },
	{ (natural_t) TYPE_LCD }
};
/*
TYPE_LCD    ( strptr count --- )
//      Write count bytes of string at strptr to the LCD. 
//
//      This is not the way to do this, but we will do it for now.
*/
void TYPE_LCD(void)	/* Temporary code to just get output, for now. */
{
	natural_t count = ( * SP++ ).integer;
	char * chp = (char *) ( * SP++ ).bytep;
	if ( write( lcd_fd, chp, count ) != count )
	{	perror( "Problem writing to LCD!!" );
	}
}


static character_t sCLR_LCD[] = "\x8" "CLR_LCD";
definition_header_s hCLR_LCD =	
{	{ (natural_t) sCLR_LCD },
	{ 0 },
	{ (natural_t) &hTYPE_LCD },
	{ MFORE },
	{ (natural_t) &hEXTENSIONS },
	{ 0 },
	{ 0 },
	{ (natural_t) CLR_LCD }
};
/*
CLR_LCD    ( --- )
//      Clear the LCD. 
//
//      This is not the way to do this, but we will do it for now.
*/

/* From dio104lcd.h */
#define	CLRDISP	_IO( 'x', 1 )	/* 1: LCD $BI=<($N%/%j%"%3%^%s%I$H$9$k(B */

void CLR_LCD(void)	/* Temporary code to just get output, for now. */
{
	if ( ioctl( lcd_fd, CLRDISP, 0 ) != 0 )
	{	perror( "Problem clearing the LCD!!" );
	}
}


#if defined READY_FOR_READING_LCD

static character_t sREAD_LCD[] = "\x8" "READ_LCD";
definition_header_s hREAD_LCD =	
{	{ (natural_t) sREAD_LCD },
	{ 0 },
	{ (natural_t) &hCLR_LCD },
	{ MFORE },
	{ (natural_t) &hEXTENSIONS },
	{ 0 },
	{ 0 },
	{ (natural_t) READ_LCD }
};
/*
READ_LCD    ( ? --- ? )
//      Get the contents of the LCD. 
//
//      This is not the way to do this, but we will do it for now.
*/
void READ_LCD(void)	/* Temporary code to just get input, for now. */
{
	char ch = 0;
	if ( read( lcd_fd, &ch, 1 ) != 1 )
	{	perror( "Problem reading LCD!!" );
	}
	( * --SP ).integer = ch;
}

#endif /* defined READY_FOR_READING_LCD */

