/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.tools.jmx;

import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.tools.jmx.ManagedBinding;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class Manager {
    public static void manage(String domain, Injector injector) {
        Manager.manage(ManagementFactory.getPlatformMBeanServer(), domain, injector);
    }

    public static void manage(MBeanServer server, String domain, Injector injector) {
        for (Binding<?> binding : injector.getBindings().values()) {
            StringBuilder name = new StringBuilder();
            name.append(domain).append(":");
            Key<?> key = binding.getKey();
            name.append("type=").append(Manager.quote(key.getTypeLiteral().toString()));
            Annotation annotation = key.getAnnotation();
            if (annotation != null) {
                name.append(",annotation=").append(Manager.quote(((Object)annotation).toString()));
            } else {
                Class<Annotation> annotationType = key.getAnnotationType();
                if (annotationType != null) {
                    name.append(",annotation=").append(Manager.quote("@" + annotationType.getName()));
                }
            }
            try {
                server.registerMBean(new ManagedBinding(binding), new ObjectName(name.toString()));
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException("Bad object name: " + name.toString(), e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static String quote(String value) {
        return ObjectName.quote(value).replace(',', ';');
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: java -Dcom.sun.management.jmxremote " + Manager.class.getName() + " [module class name]");
            System.err.println("Then run 'jconsole' to connect.");
            System.exit(1);
        }
        Module module = (Module)Class.forName(args[0]).newInstance();
        Injector injector = Guice.createInjector(module);
        Manager.manage(args[0], injector);
        System.out.println("Press Ctrl+C to exit...");
        Thread.sleep(Long.MAX_VALUE);
    }
}

