/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.datatype.TextEncodedStringNullTerminated;
import org.jaudiotagger.tag.datatype.TextEncodedStringSizeTerminated;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;

public class MultipleTextEncodedStringNullTerminated
extends AbstractDataType {
    public MultipleTextEncodedStringNullTerminated(String identifier, AbstractTagFrameBody frameBody) {
        super(identifier, frameBody);
        this.value = new Values();
    }

    public MultipleTextEncodedStringNullTerminated(TextEncodedStringSizeTerminated object) {
        super(object);
        this.value = new Values();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MultipleTextEncodedStringNullTerminated)) {
            return false;
        }
        return super.equals(obj);
    }

    public int getSize() {
        return this.size;
    }

    public boolean canBeEncoded() {
        ListIterator li = ((Values)this.value).getList().listIterator();
        while (li.hasNext()) {
            TextEncodedStringNullTerminated next = new TextEncodedStringNullTerminated(this.identifier, this.frameBody, (String)li.next());
            if (next.canBeEncoded()) continue;
            return false;
        }
        return true;
    }

    public void readByteArray(byte[] arr, int offset) throws InvalidDataTypeException {
        block4: {
            do {
                try {
                    TextEncodedStringNullTerminated next = new TextEncodedStringNullTerminated(this.identifier, this.frameBody);
                    next.readByteArray(arr, offset);
                    if (next.getSize() != 0) {
                        ((Values)this.value).add((String)next.getValue());
                        this.size += next.getSize();
                        offset += next.getSize();
                        continue;
                    }
                    break block4;
                }
                catch (InvalidDataTypeException idte) {
                    break block4;
                }
            } while (this.size != 0);
            throw new InvalidDataTypeException("No null terminated Strings found");
        }
    }

    public byte[] writeByteArray() {
        int localSize = 0;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            ListIterator li = ((Values)this.value).getList().listIterator();
            while (li.hasNext()) {
                TextEncodedStringNullTerminated next = new TextEncodedStringNullTerminated(this.identifier, this.frameBody, (String)li.next());
                buffer.write(next.writeByteArray());
                localSize += next.getSize();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.size = localSize;
        return buffer.toByteArray();
    }

    public static class Values {
        private List valueList = new ArrayList();

        public void add(String value) {
            this.valueList.add(value);
        }

        public List getList() {
            return this.valueList;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            ListIterator li = this.valueList.listIterator();
            while (li.hasNext()) {
                String next = (String)li.next();
                sb.append(next);
                if (!li.hasNext()) continue;
                sb.append(",");
            }
            return sb.toString();
        }
    }
}

