/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Hashtable;
import java.util.Properties;

public class AsyncPersistentProps
implements Runnable {
    private File f;
    private Properties p;
    private IOException ioe;
    private boolean closed;
    private boolean changed;
    private boolean writing;

    public Properties getProperties() {
        return this.p;
    }

    public File getFile() {
        return this.f;
    }

    public synchronized Object setProperty(String key, String value) {
        this.checkState();
        Object result = this.p.setProperty(key, value);
        this.changed = true;
        this.notifyAll();
        return result;
    }

    public synchronized Object remove(Object key) {
        this.checkState();
        Object result = ((Hashtable)this.p).remove(key);
        if (result != null) {
            this.changed = true;
            this.notifyAll();
        }
        return result;
    }

    public synchronized void clear() {
        this.checkState();
        ((Hashtable)this.p).clear();
        this.changed = true;
        this.notifyAll();
    }

    public synchronized String getProperty(String key) {
        return this.p.getProperty(key);
    }

    public synchronized void flush() throws IOException {
        while (!this.closed && (this.changed || this.writing)) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.getMessage());
            }
        }
        if (this.ioe != null) {
            IOException ex = this.ioe;
            this.ioe = null;
            throw ex;
        }
    }

    public synchronized void close() throws IOException {
        this.flush();
        this.closed = true;
        this.notifyAll();
    }

    private final synchronized void fail(IOException e) {
        this.closed = true;
        this.ioe = e;
        this.notifyAll();
    }

    private final void checkState() {
        if (this.ioe != null) {
            throw new IllegalStateException(this.ioe.getMessage());
        }
        if (this.closed) {
            throw new IllegalStateException("Sorry, we're closed");
        }
    }

    public void run() {
        while (true) {
            try {
                byte[] b = null;
                AsyncPersistentProps asyncPersistentProps = this;
                synchronized (asyncPersistentProps) {
                    if (this.closed) {
                        return;
                    }
                    if (!this.changed) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            this.fail(new InterruptedIOException(e.getMessage()));
                        }
                        if (!this.changed) {
                            continue;
                        }
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    this.p.store(baos, null);
                    b = baos.toByteArray();
                    this.changed = false;
                    this.writing = true;
                }
                if (this.f.exists()) {
                    this.f.delete();
                }
                FileOutputStream fos = new FileOutputStream(this.f);
                fos.write(b);
                fos.flush();
                fos.close();
                asyncPersistentProps = this;
                synchronized (asyncPersistentProps) {
                    this.writing = false;
                    this.notifyAll();
                    continue;
                }
            }
            catch (IOException e) {
                this.fail(e);
                continue;
            }
            break;
        }
    }

    public AsyncPersistentProps(File f) throws IOException {
        this.f = f;
        this.p = new Properties();
        if (f.exists()) {
            this.p.load(new FileInputStream(f));
        }
        new Thread((Runnable)this, "Props Writer :" + f.getName()).start();
    }
}

