/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.ssdp;

import org.cybergarage.net.HostInterface;
import org.cybergarage.upnp.device.SearchListener;
import org.cybergarage.upnp.ssdp.HTTPMUSocket;
import org.cybergarage.upnp.ssdp.SSDP;
import org.cybergarage.upnp.ssdp.SSDPPacket;
import org.cybergarage.util.ListenerList;

public class SSDPSearchSocket
extends HTTPMUSocket
implements Runnable {
    private boolean useIPv6Address;
    private ListenerList deviceSearchListenerList = new ListenerList();
    private Thread deviceSearchThread = null;

    public SSDPSearchSocket() {
    }

    public SSDPSearchSocket(String bindAddr) {
        this.open(bindAddr);
    }

    public boolean open(String bindAddr) {
        String addr = "239.255.255.250";
        this.useIPv6Address = false;
        if (HostInterface.isIPv6Address(bindAddr)) {
            addr = SSDP.getIPv6Address();
            this.useIPv6Address = true;
        }
        return this.open(addr, 1900, bindAddr);
    }

    public void addSearchListener(SearchListener listener) {
        this.deviceSearchListenerList.add(listener);
    }

    public void removeSearchListener(SearchListener listener) {
        this.deviceSearchListenerList.remove(listener);
    }

    public void performSearchListener(SSDPPacket ssdpPacket) {
        int listenerSize = this.deviceSearchListenerList.size();
        for (int n = 0; n < listenerSize; ++n) {
            SearchListener listener = (SearchListener)this.deviceSearchListenerList.get(n);
            listener.deviceSearchReceived(ssdpPacket);
        }
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.deviceSearchThread == thisThread) {
            Thread.yield();
            SSDPPacket packet = this.receive();
            if (!packet.isDiscover()) continue;
            this.performSearchListener(packet);
        }
    }

    public void start() {
        this.deviceSearchThread = new Thread(this);
        this.deviceSearchThread.setName("device search thread");
        this.deviceSearchThread.start();
    }

    public void stop() {
        this.deviceSearchThread = null;
    }
}

