/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.io;

import com.onionnetworks.io.FilterRAF;
import com.onionnetworks.io.Journal;
import com.onionnetworks.io.RAF;
import com.onionnetworks.util.Range;
import java.io.File;
import java.io.IOException;

public class JournalingRAF
extends FilterRAF {
    Journal journal;

    public synchronized void seekAndWrite(long pos, byte[] b, int off, int len) throws IOException {
        super.seekAndWrite(pos, b, off, len);
        if (this.journal != null) {
            this.journal.addByteRange(new Range(pos, pos + (long)len - 1L));
        }
    }

    public synchronized void renameTo(File newFile) throws IOException {
        super.renameTo(newFile);
        if (this.journal != null) {
            this.journal.setTargetFile(this.raf.getFile());
            this.journal.flush();
        }
    }

    public synchronized void setReadOnly() throws IOException {
        super.setReadOnly();
        this.deleteJournal();
    }

    public synchronized void close() throws IOException {
        super.close();
        if (this.journal != null) {
            this.journal.close();
        }
    }

    public synchronized void deleteOnClose() {
        super.deleteOnClose();
        this.deleteJournal();
    }

    private final void deleteJournal() {
        File f = this.journal.getFile();
        try {
            this.journal.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        f.delete();
        this.journal = null;
    }

    public JournalingRAF(RAF raf, Journal journal) throws IOException {
        super(raf);
        if (raf.getMode().equals("r")) {
            throw new IllegalStateException("Can't create a journal for a read-only file.");
        }
        this.journal = journal;
        journal.setTargetFile(raf.getFile());
    }
}

