/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.FileHeader;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.util.Utils;

public class FileHeaderReader {
    public static FileHeader read(RandomAccessFile raf, Chunk candidate) throws IOException {
        if (raf == null || candidate == null) {
            throw new IllegalArgumentException("Arguments must not be null.");
        }
        if (GUID.GUID_FILE.equals(candidate.getGuid())) {
            raf.seek(candidate.getPosition());
            return new FileHeaderReader().parseData(raf);
        }
        return null;
    }

    protected FileHeaderReader() {
    }

    private FileHeader parseData(RandomAccessFile raf) throws IOException {
        FileHeader result = null;
        long fileHeaderStart = raf.getFilePointer();
        GUID guid = Utils.readGUID(raf);
        if (GUID.GUID_FILE.equals(guid)) {
            BigInteger chunckLen = Utils.readBig64(raf);
            raf.skipBytes(16);
            BigInteger fileSize = Utils.readBig64(raf);
            if ((long)fileSize.intValue() != raf.length()) {
                System.err.println("Filesize of file doesn't match len of Fileheader. (" + fileSize.toString() + ", file: " + raf.length() + ")");
            }
            BigInteger fileTime = Utils.readBig64(raf);
            BigInteger packageCount = Utils.readBig64(raf);
            BigInteger timeEndPos = Utils.readBig64(raf);
            BigInteger duration = Utils.readBig64(raf);
            BigInteger timeStartPos = Utils.readBig64(raf);
            long flags = Utils.readUINT32(raf);
            long minPkgSize = Utils.readUINT32(raf);
            long maxPkgSize = Utils.readUINT32(raf);
            long uncompressedFrameSize = Utils.readUINT32(raf);
            result = new FileHeader(fileHeaderStart, chunckLen, fileSize, fileTime, packageCount, duration, timeStartPos, timeEndPos, flags, minPkgSize, maxPkgSize, uncompressedFrameSize);
        }
        return result;
    }
}

