/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.ogg.util;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OggPageHeader {
    public static final byte[] CAPTURE_PATTERN = new byte[]{79, 103, 103, 83};
    public static final int OGG_PAGE_HEADER_FIXED_LENGTH = 27;
    public static final int MAXIMUM_NO_OF_SEGMENT_SIZE = 255;
    public static final int MAXIMUM_SEGMENT_SIZE = 255;
    public static final int MAXIMUM_PAGE_HEADER_SIZE = 282;
    public static final int MAXIMUM_PAGE_DATA_SIZE = 65025;
    public static final int MAXIMUM_PAGE_SIZE = 65307;
    public static final int FIELD_CAPTURE_PATTERN_POS = 0;
    public static final int FIELD_STREAM_STRUCTURE_VERSION_POS = 4;
    public static final int FIELD_HEADER_TYPE_FLAG_POS = 5;
    public static final int FIELD_ABSOLUTE_GRANULE_POS = 6;
    public static final int FIELD_STREAM_SERIAL_NO_POS = 14;
    public static final int FIELD_PAGE_SEQUENCE_NO_POS = 18;
    public static final int FIELD_PAGE_CHECKSUM_POS = 22;
    public static final int FIELD_PAGE_SEGMENTS_POS = 26;
    public static final int FIELD_SEGMENT_TABLE_POS = 27;
    public static final int FIELD_CAPTURE_PATTERN_LENGTH = 4;
    public static final int FIELD_STREAM_STRUCTURE_VERSION_LENGTH = 1;
    public static final int FIELD_HEADER_TYPE_FLAG_LENGTH = 1;
    public static final int FIELD_ABSOLUTE_GRANULE_LENGTH = 8;
    public static final int FIELD_STREAM_SERIAL_NO_LENGTH = 4;
    public static final int FIELD_PAGE_SEQUENCE_NO_LENGTH = 4;
    public static final int FIELD_PAGE_CHECKSUM_LENGTH = 4;
    public static final int FIELD_PAGE_SEGMENTS_LENGTH = 1;
    private byte[] rawHeaderData;
    private double absoluteGranulePosition;
    private int checksum;
    private byte headerTypeFlag;
    private boolean isValid = false;
    private int pageLength = 0;
    private int pageSequenceNumber;
    private int streamSerialNumber;
    private byte[] segmentTable;
    private List<PacketStartAndLength> packetList = new ArrayList<PacketStartAndLength>();
    private boolean lastPacketIncomplete = false;

    public static OggPageHeader read(RandomAccessFile raf) throws IOException, CannotReadException {
        long start = raf.getFilePointer();
        byte[] b = new byte[CAPTURE_PATTERN.length];
        raf.read(b);
        if (!Arrays.equals(b, CAPTURE_PATTERN)) {
            throw new CannotReadException("OggS Header could not be found, not an ogg stream:" + new String(b));
        }
        raf.seek(start + 26L);
        int pageSegments = raf.readByte() & 0xFF;
        raf.seek(start);
        b = new byte[27 + pageSegments];
        raf.read(b);
        OggPageHeader pageHeader = new OggPageHeader(b);
        return pageHeader;
    }

    public OggPageHeader(byte[] b) {
        this.rawHeaderData = b;
        byte streamStructureRevision = b[4];
        this.headerTypeFlag = b[5];
        if (streamStructureRevision == 0) {
            this.absoluteGranulePosition = 0.0;
            int i = 0;
            while (i < 8) {
                this.absoluteGranulePosition += (double)this.u(b[i + 6]) * Math.pow(2.0, 8 * i);
                ++i;
            }
            this.streamSerialNumber = Utils.getNumberLittleEndian(b, 14, 17);
            this.pageSequenceNumber = Utils.getNumberLittleEndian(b, 18, 21);
            this.checksum = Utils.getNumberLittleEndian(b, 22, 25);
            int pageSegments = this.u(b[26]);
            this.segmentTable = new byte[b.length - 27];
            int packetLength = 0;
            Integer segmentLength = null;
            int i2 = 0;
            while (i2 < this.segmentTable.length) {
                this.segmentTable[i2] = b[27 + i2];
                segmentLength = this.u(this.segmentTable[i2]);
                this.pageLength += segmentLength.intValue();
                packetLength += segmentLength.intValue();
                if (segmentLength < 255) {
                    this.packetList.add(new PacketStartAndLength(this.pageLength - packetLength, packetLength));
                    packetLength = 0;
                }
                ++i2;
            }
            if (segmentLength == 255) {
                this.packetList.add(new PacketStartAndLength(this.pageLength - packetLength, packetLength));
                this.lastPacketIncomplete = true;
            }
            this.isValid = true;
        }
    }

    private int u(int i) {
        return i & 0xFF;
    }

    public boolean isLastPacketIncomplete() {
        return this.lastPacketIncomplete;
    }

    public double getAbsoluteGranulePosition() {
        return this.absoluteGranulePosition;
    }

    public int getCheckSum() {
        return this.checksum;
    }

    public byte getHeaderType() {
        return this.headerTypeFlag;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public int getPageSequence() {
        return this.pageSequenceNumber;
    }

    public int getSerialNumber() {
        return this.streamSerialNumber;
    }

    public byte[] getSegmentTable() {
        return this.segmentTable;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public List<PacketStartAndLength> getPacketList() {
        return this.packetList;
    }

    public byte[] getRawHeaderData() {
        return this.rawHeaderData;
    }

    public String toString() {
        String out = "Ogg Page Header:isvalid:" + this.isValid + ":type:" + this.headerTypeFlag + ":oggpageheaderlength:" + this.rawHeaderData.length + ":length:" + this.pageLength + ":seqno:" + this.getPageSequence() + ":packetincomplete:" + this.isLastPacketIncomplete() + ":sernum:" + this.getSerialNumber();
        for (PacketStartAndLength packet : this.getPacketList()) {
            out = String.valueOf(out) + packet.toString();
        }
        return out;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HeaderTypeFlag {
        FRESH_PACKET(0),
        CONTINUED_PACKET(1),
        START_OF_BITSTREAM(2),
        END_OF_BITSTREAM(4);

        byte fileValue;

        private HeaderTypeFlag(byte fileValue) {
            this.fileValue = fileValue;
        }

        public byte getFileValue() {
            return this.fileValue;
        }
    }

    public static class PacketStartAndLength {
        private Integer startPosition = 0;
        private Integer length = 0;

        public PacketStartAndLength(int startPosition, int length) {
            this.startPosition = startPosition;
            this.length = length;
        }

        public int getStartPosition() {
            return this.startPosition;
        }

        public void setStartPosition(int startPosition) {
            this.startPosition = startPosition;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public String toString() {
            return "start:" + this.startPosition + ":length:" + this.length;
        }
    }
}

