/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns;

import java.io.IOException;
import java.util.Hashtable;
import javax.jmdns.DNSConstants;
import javax.jmdns.DNSIncoming;
import javax.jmdns.DNSQuestion;
import javax.jmdns.DNSRecord;

final class DNSOutgoing
extends DNSConstants {
    int id;
    int flags;
    boolean multicast;
    int numQuestions;
    int numAnswers;
    int numAuthorities;
    int numAdditionals;
    Hashtable names;
    byte[] data;
    int off;
    int len;

    DNSOutgoing(int n) {
        this(n, true);
    }

    DNSOutgoing(int n, boolean bl) {
        this.flags = n;
        this.multicast = bl;
        this.names = new Hashtable();
        this.data = new byte[1460];
        this.off = 12;
    }

    void addQuestion(DNSQuestion dNSQuestion) throws IOException {
        ++this.numQuestions;
        this.writeQuestion(dNSQuestion);
    }

    void addAnswer(DNSIncoming dNSIncoming, DNSRecord dNSRecord) throws IOException {
        if (!dNSRecord.suppressedBy(dNSIncoming)) {
            this.addAnswer(dNSRecord, 0L);
        }
    }

    void addAdditionalAnswer(DNSIncoming dNSIncoming, DNSRecord dNSRecord) throws IOException {
        if (this.off < 1260 && !dNSRecord.suppressedBy(dNSIncoming)) {
            ++this.numAdditionals;
            this.writeRecord(dNSRecord, 0L);
        }
    }

    void addAnswer(DNSRecord dNSRecord, long l) throws IOException {
        if (!(dNSRecord == null || l != 0L && dNSRecord.isExpired(l))) {
            ++this.numAnswers;
            this.writeRecord(dNSRecord, l);
        }
    }

    void addAuthorativeAnswer(DNSRecord dNSRecord) throws IOException {
        ++this.numAuthorities;
        this.writeRecord(dNSRecord, 0L);
    }

    void writeByte(int n) throws IOException {
        if (this.off >= this.data.length) {
            throw new IOException("buffer full");
        }
        this.data[this.off++] = (byte)n;
    }

    void writeBytes(String string, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            this.writeByte(string.charAt(n + n3));
            ++n3;
        }
    }

    void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            this.writeByte(byArray[n + n3]);
            ++n3;
        }
    }

    void writeShort(int n) throws IOException {
        this.writeByte(n >> 8);
        this.writeByte(n);
    }

    void writeInt(int n) throws IOException {
        this.writeShort(n >> 16);
        this.writeShort(n);
    }

    void writeUTF(String string, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            n3 = string.charAt(n + n5);
            n4 = n3 >= 1 && n3 <= 127 ? ++n4 : (n3 > 2047 ? (n4 += 3) : (n4 += 2));
            ++n5;
        }
        this.writeByte(n4);
        n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n + n3);
            if (c >= '\u0001' && c <= '\u007f') {
                this.writeByte(c);
            } else if (c > '\u07ff') {
                this.writeByte(0xE0 | c >> 12 & 0xF);
                this.writeByte(0x80 | c >> 6 & 0x3F);
                this.writeByte(0x80 | c >> 0 & 0x3F);
            } else {
                this.writeByte(0xC0 | c >> 6 & 0x1F);
                this.writeByte(0x80 | c >> 0 & 0x3F);
            }
            ++n3;
        }
    }

    void writeName(String string) throws IOException {
        while (true) {
            int n;
            if ((n = string.indexOf(46)) < 0) {
                n = string.length();
            }
            if (n <= 0) {
                this.writeByte(0);
                return;
            }
            Integer n2 = (Integer)this.names.get(string);
            if (n2 != null) {
                int n3 = n2;
                this.writeByte(n3 >> 8 | 0xC0);
                this.writeByte(n3);
                return;
            }
            this.names.put(string, new Integer(this.off));
            this.writeUTF(string, 0, n);
            if (!(string = string.substring(n)).startsWith(".")) continue;
            string = string.substring(1);
        }
    }

    void writeQuestion(DNSQuestion dNSQuestion) throws IOException {
        this.writeName(dNSQuestion.name);
        this.writeShort(dNSQuestion.type);
        this.writeShort(dNSQuestion.clazz);
    }

    void writeRecord(DNSRecord dNSRecord, long l) throws IOException {
        this.writeName(dNSRecord.name);
        this.writeShort(dNSRecord.type);
        this.writeShort(dNSRecord.clazz | (dNSRecord.unique && this.multicast ? 32768 : 0));
        this.writeInt(l == 0L ? dNSRecord.ttl : dNSRecord.getRemainingTTL(l));
        this.writeShort(0);
        int n = this.off;
        dNSRecord.write(this);
        int n2 = this.off - n;
        this.data[n - 2] = (byte)(n2 >> 8);
        this.data[n - 1] = (byte)(n2 & 0xFF);
    }

    void finish() throws IOException {
        int n = this.off;
        this.off = 0;
        this.writeShort(this.multicast ? 0 : this.id);
        this.writeShort(this.flags);
        this.writeShort(this.numQuestions);
        this.writeShort(this.numAnswers);
        this.writeShort(this.numAuthorities);
        this.writeShort(this.numAdditionals);
        this.off = n;
    }
}

