/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.plaf.windows;

import com.jgoodies.plaf.LookUtils;
import com.jgoodies.plaf.common.ButtonMarginListener;
import com.sun.java.swing.plaf.windows.WindowsButtonUI;
import java.awt.Graphics;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;

public final class ExtWindowsButtonUI
extends WindowsButtonUI {
    private static final ExtWindowsButtonUI INSTANCE = new ExtWindowsButtonUI();
    private final Border ROLLOVER_BORDER = BorderFactory.createRaisedBevelBorder();
    private final Border PRESSED_BORDER = BorderFactory.createLoweredBevelBorder();

    public static ComponentUI createUI(JComponent b) {
        return INSTANCE;
    }

    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        LookUtils.installNarrowMargin(b, this.getPropertyPrefix());
    }

    public void installListeners(AbstractButton b) {
        super.installListeners(b);
        ButtonMarginListener listener = new ButtonMarginListener(this.getPropertyPrefix());
        b.putClientProperty("jgoodies.buttonMarginListener", listener);
        b.addPropertyChangeListener("jgoodies.isNarrow", listener);
    }

    public void uninstallListeners(AbstractButton b) {
        super.uninstallListeners(b);
        PropertyChangeListener listener = (PropertyChangeListener)b.getClientProperty("jgoodies.buttonMarginListener");
        b.removePropertyChangeListener(listener);
    }

    public void update(Graphics g, JComponent c) {
        super.update(g, c);
        AbstractButton b = (AbstractButton)c;
        if (!c.isOpaque()) {
            ButtonModel bm = b.getModel();
            if (bm.isArmed() && bm.isPressed()) {
                this.PRESSED_BORDER.paintBorder(c, g, 0, 0, c.getWidth(), c.getHeight());
            } else if (b.isRolloverEnabled() && bm.isRollover()) {
                this.ROLLOVER_BORDER.paintBorder(c, g, 0, 0, c.getWidth(), c.getHeight());
            }
        }
        this.paint(g, c);
    }
}

